/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.core.ui.ktable.editors;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.ui.dnd.EditorDropListener;
import com.modeliosoft.modelio.api.ui.dnd.IEditorDropClient;
import com.modeliosoft.modelio.api.ui.dnd.ModelElementTransfer;
import com.modeliosoft.modelio.api.ui.text.ResultsProposalPopup;
import com.modeliosoft.modelio.api.utils.UMLMetaclassName;
import com.modeliosoft.modelio.core.app.O;
import com.modeliosoft.modelio.core.app.events.IPickingClient;
import com.modeliosoft.modelio.core.model.ElementFinder;
import com.modeliosoft.modelio.core.model.IElementFilter;
import com.modeliosoft.modelio.core.ui.ktable.KeyValueModel;
import com.modeliosoft.modelio.core.ui.ktable.types.IPropertyType;
import com.modeliosoft.modelio.core.ui.plugin.CoreUi;
import de.kupzog.ktable.KTable;
import de.kupzog.ktable.KTableCellEditor;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.PluginTransfer;

public class HybridCellEditor
extends KTableCellEditor
implements IPickingClient,
IEditorDropClient {
    private Class[] targetClasses = null;
    private IElementFilter elementFilter = null;
    protected boolean acceptNullValue = false;
    private EditorDropListener dropListener;
    Text m_Text2 = null;
    protected KeyAdapter keyListener = new /* Unavailable Anonymous Inner Class!! */;
    protected TraverseListener travListener = new /* Unavailable Anonymous Inner Class!! */;

    public HybridCellEditor(boolean acceptNullValue) {
        this.acceptNullValue = acceptNullValue;
    }

    public HybridCellEditor() {
        this.acceptNullValue = false;
    }

    public boolean acceptDroppedElements(IElement[] target) {
        if (target.length != 1) {
            return false;
        }
        Class[] classArray = this.targetClasses;
        int n = this.targetClasses.length;
        int n2 = 0;
        while (n2 < n) {
            Class c = classArray[n2];
            if (c.isAssignableFrom(target[0].getClass())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean acceptElement(IElement target) {
        Class[] classArray = this.targetClasses;
        int n = this.targetClasses.length;
        int n2 = 0;
        while (n2 < n) {
            Class c = classArray[n2];
            if (c.isAssignableFrom(target.getClass())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void close(boolean save) {
    }

    public void forceClose() {
        if (this.m_Table != null) {
            super.close(true);
        }
    }

    public int getActivationSignals() {
        return 12;
    }

    public void open(KTable table, int col, int row, Rectangle rect) {
        super.open(table, col, row, rect);
        Object content = this.m_Model.getContentAt(this.m_Col, this.m_Row);
        this.initAcceptNullValue(col, row);
        String initialValue = "";
        if (content instanceof IModelElement) {
            IModelElement me = (IModelElement)content;
            initialValue = me.getName();
        } else if (content instanceof String) {
            initialValue = (String)content;
        }
        this.m_Text2.setText(initialValue);
        this.m_Text2.selectAll();
        this.m_Text2.setVisible(true);
        this.m_Text2.setFocus();
        O.getDefault().getPickingClientService().beginPicking((IPickingClient)this);
    }

    public void pickingAborted() {
        if (this.m_Text2 != null && !this.m_Text2.isDisposed()) {
            this.m_Text2.setData(null);
            this.m_Text2.removeKeyListener((KeyListener)this.keyListener);
            this.m_Text2.removeTraverseListener(this.travListener);
            super.close(false);
            this.m_Text2 = null;
        }
    }

    public void setContent(Object content) {
        IModelElement me = (IModelElement)content;
        String text = me.getName();
        if (me.getCompositionOwner() != null) {
            text = String.valueOf(text) + "  (from " + ((IModelElement)me.getCompositionOwner()).getName() + ")";
        }
        this.m_Text2.setText(text);
        this.m_Text2.setData(content);
    }

    public void setDroppedElements(IElement[] target) {
        if (this.acceptElement(target[0])) {
            this.setContent((Object)target[0]);
            this.validate(true);
        }
    }

    public void setElementFilter(IElementFilter elementFilter) {
        this.elementFilter = elementFilter;
    }

    public boolean setElement(IElement target) {
        if (this.acceptElement(target)) {
            this.setContent((Object)target);
            this.validate(true);
            return true;
        }
        return false;
    }

    public void setTargetClasses(Class[] targetClass) {
        this.targetClasses = Arrays.copyOf(targetClass, targetClass.length);
    }

    protected Control createControl() {
        StringBuffer helpTooltip = new StringBuffer();
        if (this.targetClasses.length > 1) {
            helpTooltip.append(CoreUi.I18N.getString("AcceptedTypes"));
        } else if (this.targetClasses.length == 1) {
            helpTooltip.append(CoreUi.I18N.getString("AcceptedType"));
        }
        helpTooltip.append("\n");
        Class[] classArray = this.targetClasses;
        int n = this.targetClasses.length;
        int n2 = 0;
        while (n2 < n) {
            Class clazz = classArray[n2];
            helpTooltip.append("    ");
            if (clazz == String.class) {
                helpTooltip.append(CoreUi.I18N.getString("AnyStringValue"));
            } else {
                helpTooltip.append(clazz.getAnnotation(UMLMetaclassName.class).value());
            }
            helpTooltip.append("\n");
            ++n2;
        }
        helpTooltip.append("\n");
        helpTooltip.append(CoreUi.I18N.getString("HybridCellEditorTootip"));
        this.setToolTipText(helpTooltip.toString());
        this.m_Text2 = new Text((Composite)this.m_Table, 0);
        this.m_Text2.addPaintListener((PaintListener)new /* Unavailable Anonymous Inner Class!! */);
        this.m_Text2.setData(null);
        this.m_Text2.addKeyListener((KeyListener)this.keyListener);
        this.initDropTarget();
        return this.m_Text2;
    }

    protected void onKeyPressed(KeyEvent e) {
        if (e.character == '\r') {
            Vector<Class> metaclasses = new Vector<Class>();
            Class[] classArray = this.targetClasses;
            int n = this.targetClasses.length;
            int n2 = 0;
            while (n2 < n) {
                Class c = classArray[n2];
                if (IElement.class.isAssignableFrom(c)) {
                    Class c2 = c;
                    metaclasses.add(c2);
                }
                ++n2;
            }
            ElementFinder finder = new ElementFinder(O.getDefault().getModelingSession());
            List elements = finder.findByName(metaclasses, this.m_Text2.getText(), this.elementFilter);
            if (elements.isEmpty()) {
                String filter = String.valueOf(this.m_Text2.getText()) + ".*";
                elements = finder.search(metaclasses, filter, this.elementFilter);
                if (elements.isEmpty()) {
                    if (Arrays.asList(this.targetClasses).contains(String.class)) {
                        this.m_Text2.setData((Object)this.m_Text2.getText());
                        this.validate(true);
                    } else {
                        MessageDialog.openInformation((Shell)this.getControl().getShell(), (String)CoreUi.I18N.getString("HybridNotFoundTitle"), (String)CoreUi.I18N.getString("HybridNotFoundMessage"));
                        this.validate(false);
                    }
                } else if (elements.size() == 1) {
                    this.m_Text2.setData(elements.get(0));
                    this.validate(true);
                } else {
                    ResultsProposalPopup rp = new ResultsProposalPopup(this.getControl(), elements, this.acceptNullValue);
                    IModelElement selected = (IModelElement)rp.getChoice();
                    this.m_Text2.setData((Object)selected);
                    this.validate(true);
                }
            } else if (elements.size() == 1) {
                this.m_Text2.setData(elements.get(0));
                this.validate(true);
            } else {
                ResultsProposalPopup rp = new ResultsProposalPopup(this.getControl(), elements, this.acceptNullValue);
                IModelElement selected2 = (IModelElement)rp.getChoice();
                this.m_Text2.setData((Object)selected2);
                this.validate(true);
            }
            return;
        }
        if (e.character == ' ' && (e.stateMask & 0x40000) != 0) {
            String filter = String.valueOf(this.m_Text2.getText()) + ".*";
            Vector<Class> metaclasses = new Vector<Class>();
            IModelElement selected = this.targetClasses;
            int selected2 = ((Class[])selected).length;
            int rp = 0;
            while (rp < selected2) {
                Class c = selected[rp];
                if (IElement.class.isAssignableFrom(c)) {
                    Class c2 = c;
                    metaclasses.add(c2);
                }
                ++rp;
            }
            ElementFinder finder = new ElementFinder(O.getDefault().getModelingSession());
            List elements = finder.search(metaclasses, filter, this.elementFilter);
            if (elements.isEmpty()) {
                MessageDialog.openInformation((Shell)this.getControl().getShell(), (String)CoreUi.I18N.getString("HybridNotFoundTitle"), (String)CoreUi.I18N.getString("HybridNotFoundMessage"));
                this.validate(false);
            } else if (elements.size() == 1 && !this.acceptNullValue) {
                this.m_Text2.setData(elements.get(0));
                this.validate(true);
            } else {
                ResultsProposalPopup rp2 = new ResultsProposalPopup(this.getControl(), elements, this.acceptNullValue);
                selected = (IModelElement)rp2.getChoice();
                this.m_Text2.setData((Object)selected);
                this.validate(true);
            }
        } else if (e.character == '\u001b') {
            this.validate(false);
        } else {
            super.onKeyPressed(e);
        }
    }

    private void initAcceptNullValue(int col, int row) {
        if (this.m_Model instanceof KeyValueModel) {
            KeyValueModel keyValueModel = (KeyValueModel)this.m_Model;
            IPropertyType type = keyValueModel.doGetTypeAt(col, row);
            this.acceptNullValue = type != null ? type.acceptNullValue() : true;
        }
    }

    private void initDropTarget() {
        this.dropListener = new EditorDropListener((IEditorDropClient)this);
        int operations = 3;
        Transfer[] types = new Transfer[]{ModelElementTransfer.getInstance(), PluginTransfer.getInstance()};
        DropTarget target = new DropTarget((Control)this.m_Text2, 3);
        target.setTransfer(types);
        target.addDropListener((DropTargetListener)this.dropListener);
    }

    private void selectNextField() {
        int nextCol = this.m_Col + 1;
        int nextRow = this.m_Row;
        if (nextCol > this.m_Model.getColumnCount() - 1) {
            nextCol = 1;
            ++nextRow;
        }
        if (nextRow > this.m_Model.getRowCount() - 1) {
            nextRow = 1;
        }
        this.m_Table.setSelection(nextCol, nextRow, true);
    }

    private void validate(boolean save) {
        if (save) {
            this.m_Model.setContentAt(this.m_Col, this.m_Row, this.m_Text2.getData());
        }
        this.m_Text2.setData(null);
        this.m_Text2.removeKeyListener((KeyListener)this.keyListener);
        this.m_Text2.removeTraverseListener(this.travListener);
        super.close(save);
        this.selectNextField();
        O.getDefault().getPickingClientService().endPicking((IPickingClient)this);
        this.m_Text2 = null;
    }
}

