/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.core.ui.ktable.editors;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.ui.dnd.EditorDropListener;
import com.modeliosoft.modelio.api.ui.dnd.IEditorDropClient;
import com.modeliosoft.modelio.api.ui.dnd.ModelElementTransfer;
import com.modeliosoft.modelio.core.app.O;
import com.modeliosoft.modelio.core.app.events.IPickingClient;
import com.modeliosoft.modelio.core.ui.ktable.editors.ModelElementCellEditor;
import com.modeliosoft.modelio.core.ui.plugin.CoreUi;
import de.kupzog.ktable.KTable;
import de.kupzog.ktable.KTableCellEditor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.part.PluginTransfer;

public class ModelElementCellEditor
extends KTableCellEditor
implements IPickingClient,
IEditorDropClient {
    private Combo m_Combo = null;
    private final Cursor m_ArrowCursor = new Cursor((Device)Display.getDefault(), 0);
    private final KeyAdapter keyListener = new /* Unavailable Anonymous Inner Class!! */;
    private final TraverseListener travListener = new /* Unavailable Anonymous Inner Class!! */;
    private String[] m_items = null;
    private List<ElementLabel> m_elements = null;
    private boolean acceptNullValue = false;
    private EditorDropListener dropListener;
    private List<Class<?>> allowedClasses = null;

    public ModelElementCellEditor(List<Class<?>> allowedClasses, List<IModelElement> elements, boolean acceptNullValue) {
        ElementLabel elementLabel;
        String elementName;
        this.allowedClasses = allowedClasses;
        this.m_elements = new ArrayList();
        for (IModelElement element : elements) {
            this.m_elements.add(new ElementLabel(this, element));
        }
        Collections.sort(this.m_elements);
        this.acceptNullValue = acceptNullValue;
        if (acceptNullValue) {
            this.m_items = new String[this.m_elements.size() + 1];
            elementName = null;
            elementLabel = null;
            this.m_items[0] = CoreUi.I18N.getString("None");
            int i = 0;
            while (i < this.m_elements.size()) {
                elementLabel = (ElementLabel)this.m_elements.get(i);
                this.m_items[i + 1] = elementName = elementLabel.getLabel();
                ++i;
            }
        } else {
            elementName = null;
            elementLabel = null;
            int i = 0;
            while (i < this.m_elements.size()) {
                elementLabel = (ElementLabel)this.m_elements.get(i);
                this.m_items[i] = elementName = elementLabel.getLabel();
                ++i;
            }
            this.m_items = new String[this.m_elements.size()];
        }
    }

    public boolean acceptDroppedElements(IElement[] target) {
        if (target.length != 1) {
            return false;
        }
        for (Class c : this.allowedClasses) {
            if (!c.isAssignableFrom(target[0].getClass())) continue;
            return true;
        }
        return false;
    }

    public boolean acceptElement(IElement target) {
        for (Class c : this.allowedClasses) {
            if (!c.isAssignableFrom(target.getClass())) continue;
            return true;
        }
        return false;
    }

    public void close(boolean save) {
    }

    public int getActivationSignals() {
        return 12;
    }

    public void open(KTable table, int row, int col, Rectangle rect) {
        super.open(table, row, col, rect);
        O.getDefault().getPickingProviderService().abortPicking();
        IModelElement value = (IModelElement)this.m_Model.getContentAt(this.m_Col, this.m_Row);
        if (this.acceptNullValue) {
            if (value != null) {
                ElementLabel elementLabel = this.getElementLabel(value.getName());
                if (elementLabel != null) {
                    this.m_Combo.setText(elementLabel.getLabel());
                } else {
                    this.m_Combo.setText(CoreUi.I18N.getString("None"));
                }
            } else {
                this.m_Combo.setText(CoreUi.I18N.getString("None"));
            }
        } else if (value != null) {
            ElementLabel elementLabel = this.getElementLabel(value.getName());
            if (elementLabel != null) {
                this.m_Combo.setText(elementLabel.getLabel());
            } else {
                this.m_Combo.setText(CoreUi.I18N.getString(""));
            }
        } else {
            this.m_Combo.setText(CoreUi.I18N.getString(""));
        }
        O.getDefault().getPickingClientService().beginPicking((IPickingClient)this);
    }

    public void pickingAborted() {
        if (this.m_Combo != null && !this.m_Combo.isDisposed()) {
            this.m_Combo.setData(null);
            this.m_Combo.removeKeyListener((KeyListener)this.keyListener);
            this.m_Combo.removeTraverseListener(this.travListener);
            super.close(false);
            this.m_Combo = null;
        }
    }

    public void setBounds(Rectangle rect) {
        super.setBounds(new Rectangle(rect.x, rect.y + 1, rect.width, rect.height - 2));
    }

    public void setContent(Object content) {
        this.m_Combo.setData(content);
    }

    public void setDroppedElements(IElement[] target) {
        if (this.acceptElement(target[0])) {
            this.setContent((Object)target[0]);
            this.validate(true);
        }
    }

    public boolean setElement(IElement target) {
        if (this.acceptElement(target)) {
            this.setContent((Object)target);
            this.validate(true);
            return true;
        }
        return false;
    }

    protected Control createControl() {
        this.m_Combo = new Combo((Composite)this.m_Table, 8);
        this.m_Combo.addPaintListener((PaintListener)new /* Unavailable Anonymous Inner Class!! */);
        if (this.m_items != null) {
            this.m_Combo.setItems(this.m_items);
        }
        this.m_Combo.addKeyListener((KeyListener)this.keyListener);
        this.m_Combo.addTraverseListener(this.travListener);
        this.m_Combo.setCursor(this.m_ArrowCursor);
        this.m_Combo.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.initDropTarget();
        return this.m_Combo;
    }

    protected void onKeyPressed(KeyEvent e) {
        if (e.keyCode == 0x1000001) {
            if (this.m_Combo.getSelectionIndex() > 0) {
                this.m_Combo.select(this.m_Combo.getSelectionIndex() - 1);
                this.m_Combo.setSelection(new Point(0, 0));
            }
        } else if (e.keyCode == 0x1000002) {
            this.m_Combo.select(this.m_Combo.getSelectionIndex() + 1);
            this.m_Combo.setSelection(new Point(0, 0));
        } else {
            if (e.character == '\r') {
                this.validate(true);
                return;
            }
            if (e.character == '\u001b') {
                this.validate(false);
            } else {
                super.onKeyPressed(e);
            }
        }
    }

    protected void onTraverse(TraverseEvent e) {
        switch (e.keyCode) {
            case 0x1000001: 
            case 0x1000002: {
                break;
            }
            default: {
                super.onTraverse(e);
            }
        }
    }

    private ElementLabel getElementLabel(String elementName) {
        for (ElementLabel elementLabel : this.m_elements) {
            if (!elementName.equals(elementLabel.getElement().getName())) continue;
            return elementLabel;
        }
        return null;
    }

    private void initDropTarget() {
        this.dropListener = new EditorDropListener((IEditorDropClient)this);
        int operations = 3;
        Transfer[] types = new Transfer[]{ModelElementTransfer.getInstance(), PluginTransfer.getInstance()};
        DropTarget target = new DropTarget((Control)this.m_Combo, 3);
        target.setTransfer(types);
        target.addDropListener((DropTargetListener)this.dropListener);
    }

    private void selectNextField() {
        int nextCol = this.m_Col + 1;
        int nextRow = this.m_Row;
        if (nextCol > this.m_Model.getColumnCount() - 1) {
            nextCol = 1;
            ++nextRow;
        }
        if (nextRow > this.m_Model.getRowCount() - 1) {
            nextRow = 1;
        }
        this.m_Table.setSelection(nextCol, nextRow, true);
    }

    private void validate(boolean save) {
        if (save) {
            Object pickingContent = this.m_Combo.getData();
            if (pickingContent != null) {
                this.m_Model.setContentAt(this.m_Col, this.m_Row, pickingContent);
            } else if (this.acceptNullValue) {
                int selectedIndex = this.m_Combo.getSelectionIndex();
                if (selectedIndex == 0) {
                    this.m_Model.setContentAt(this.m_Col, this.m_Row, null);
                } else if (selectedIndex > 0) {
                    this.m_Model.setContentAt(this.m_Col, this.m_Row, (Object)((ElementLabel)this.m_elements.get(selectedIndex - 1)).getElement());
                }
            } else {
                this.m_Model.setContentAt(this.m_Col, this.m_Row, (Object)((ElementLabel)this.m_elements.get(this.m_Combo.getSelectionIndex())).getElement());
            }
        }
        this.m_Combo.removeKeyListener((KeyListener)this.keyListener);
        this.m_Combo.removeTraverseListener(this.travListener);
        super.close(save);
        this.selectNextField();
        this.m_Combo = null;
        this.m_ArrowCursor.dispose();
        O.getDefault().getPickingClientService().endPicking((IPickingClient)this);
    }

    static /* synthetic */ Combo access$0(ModelElementCellEditor modelElementCellEditor) {
        return modelElementCellEditor.m_Combo;
    }

    static /* synthetic */ void access$1(ModelElementCellEditor modelElementCellEditor, boolean bl) {
        modelElementCellEditor.validate(bl);
    }
}

