/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.core.ui.ktable.editors;

import com.modeliosoft.modelio.api.mdac.IMdac;
import com.modeliosoft.modelio.api.model.analyst.IProperty;
import com.modeliosoft.modelio.api.model.analyst.IPropertySet;
import com.modeliosoft.modelio.api.model.analyst.IRequirement;
import com.modeliosoft.modelio.api.model.analyst.ITerm;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IExternDocument;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IExternDocumentType;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.utils.ObList;
import com.modeliosoft.modelio.core.app.O;
import com.modeliosoft.modelio.core.documents.DocumentFormat;
import com.modeliosoft.modelio.core.documents.SupportLevel;
import com.modeliosoft.modelio.core.ui.plugin.CoreUi;
import de.kupzog.ktable.KTable;
import de.kupzog.ktable.KTableCellEditor;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ScopeRichTextCellEditor
extends KTableCellEditor {
    private boolean active = false;
    private IModelElement editedElement;
    protected KeyAdapter keyListener = new /* Unavailable Anonymous Inner Class!! */;
    protected TraverseListener travListener = new /* Unavailable Anonymous Inner Class!! */;

    public ScopeRichTextCellEditor(IModelElement editedElement) {
        this.editedElement = editedElement;
    }

    public void closeEditor(boolean save) {
        this.active = false;
        super.close(save);
        this.selectNextField();
    }

    public void close(boolean save) {
    }

    public int getActivationSignals() {
        return 26;
    }

    public void open(KTable table, int col, int row, Rectangle rect) {
        super.open(table, col, row, rect);
        if (!this.active) {
            IPropertySet properties;
            String docTypeName;
            this.active = true;
            if (this.editedElement instanceof IRequirement) {
                docTypeName = this.editedElement.isStereotyped("goal") ? "goal" : (this.editedElement.isStereotyped("business_rule") ? "business_rule" : "requirement");
                properties = ((IRequirement)this.editedElement).getOwner().getType();
            } else if (this.editedElement instanceof ITerm) {
                docTypeName = "term";
                properties = ((ITerm)this.editedElement).getOwner().getType();
            } else {
                assert (false);
                return;
            }
            ObList owned = properties.getOwned();
            IProperty editedProperty = null;
            if (col == 1) {
                editedProperty = (IProperty)owned.get(row - 2);
            } else if (owned.size() >= col - 3) {
                editedProperty = (IProperty)owned.get(col - 3);
            } else {
                assert (false);
                return;
            }
            IExternDocument externDoc = this.getExternDoc(this.editedElement, docTypeName, editedProperty);
            if (externDoc == null) {
                String mimeType = this.getSelectedMimeType();
                DocumentFormat format = O.getDefault().getDocumentFormatsRegistry().getDocumentFormatForMime(mimeType);
                if (format == null) {
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)CoreUi.I18N.getMessage("ScopeRichTextCellEditor.InvalidMimeType", new String[0]), (String)CoreUi.I18N.getMessage("ScopeRichTextCellEditor.InvalidMimeTypeDetails", new String[]{mimeType}));
                } else if (!format.isUsable() || format.getSupportLevel() != SupportLevel.Primary) {
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)CoreUi.I18N.getMessage("ScopeRichTextCellEditor.InvalidMimeType", new String[0]), (String)CoreUi.I18N.getMessage("ScopeRichTextCellEditor.UnsupportedFormatDetails", new String[]{format.getLabel()}));
                } else {
                    externDoc = this.createExternDoc(this.editedElement, docTypeName, mimeType, editedProperty);
                }
            }
            if (externDoc != null) {
                this.closeEditor(true);
                O.getDefault().getActivationService().fireActivate((IElement)externDoc);
            } else {
                this.closeEditor(false);
            }
        } else {
            this.closeEditor(true);
        }
    }

    /*
     * Exception decompiling
     */
    protected IExternDocument createExternDoc(IModelElement element, String docTypeName, String mimeType, IProperty editedProperty) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected IExternDocument getExternDoc(IModelElement element, String docTypeName, IProperty editedProperty) {
        IExternDocument firstRichNote = null;
        for (IExternDocument doc : element.getDocument()) {
            IExternDocumentType docType = doc.getType();
            if (docType == null || !docType.getName().equals(docTypeName)) continue;
            List tagValues = doc.getTagValues("editor_column");
            if (tagValues != null && tagValues.contains(editedProperty.getIdentifier())) {
                return doc;
            }
            if (firstRichNote != null || !docTypeName.equals("Description")) continue;
            firstRichNote = doc;
        }
        return firstRichNote;
    }

    public void setContent(Object content) {
    }

    protected Control createControl() {
        Text m_Text2 = new Text((Composite)this.m_Table, 0);
        m_Text2.setData(null);
        m_Text2.setEnabled(false);
        m_Text2.setEditable(false);
        return m_Text2;
    }

    private void selectNextField() {
        int nextCol = this.m_Col + 1;
        int nextRow = this.m_Row;
        if (nextCol > this.m_Model.getColumnCount() - 1) {
            nextCol = 1;
            ++nextRow;
        }
        if (nextRow > this.m_Model.getRowCount() - 1) {
            nextRow = 1;
        }
        this.m_Table.setSelection(nextCol, nextRow, true);
    }

    private String getSelectedMimeType() {
        for (IMdac module : O.getDefault().getModelingSession().getMdacRegistry().getStartedMdacs()) {
            if (!module.getName().equals("Analyst")) continue;
            String mimeType = module.getConfiguration().getParameterValue("DescriptionMimeType");
            if (mimeType.equals("OoWriter")) {
                return "application/vnd.oasis.opendocument.text";
            }
            if (mimeType.equals("MsWord")) {
                return "application/vnd.openxmlformats-officedocument.wordprocessingml.document";
            }
            if (mimeType.equals("OoHTML")) {
                return "text/html/ooo";
            }
            return "text/html";
        }
        if (System.getProperty("os.name").equals("Linux")) {
            return "application/vnd.oasis.opendocument.text";
        }
        return "application/vnd.openxmlformats-officedocument.wordprocessingml.document";
    }

    static /* synthetic */ void access$0(ScopeRichTextCellEditor scopeRichTextCellEditor, KeyEvent keyEvent) {
        scopeRichTextCellEditor.onKeyPressed(keyEvent);
    }
}

