/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.core.ui.ktable.editors.multiline;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.ui.ModelioDialog;
import com.modeliosoft.modelio.core.ui.ktable.editors.multiline.MultilineTextCellEditor;
import com.modeliosoft.modelio.core.ui.plugin.CoreUi;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.osgi.framework.Bundle;

class EditionDialog
extends ModelioDialog {
    private String content;
    private MultilineTextCellEditor editor = null;
    boolean dialogActive = false;
    private IElement editedElement;
    private String fieldName;
    private Text textfield = null;

    public EditionDialog(Shell parentShell, MultilineTextCellEditor editor, String initialContent) {
        super(parentShell);
        this.content = initialContent;
        this.editor = editor;
        this.editedElement = editor.getEditedElement();
        this.fieldName = editor.getFieldName();
        int style = this.getShellStyle();
        style &= 0xFFFC7FFF;
        this.setShellStyle(style |= 0);
    }

    public void addButtonsInButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CLOSE_LABEL, false);
    }

    public Control createContentArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setFont(parent.getFont());
        this.textfield = new Text(composite, 2114);
        this.textfield.setText(this.content);
        this.textfield.setLayoutData((Object)new GridData(4, 4, true, true));
        this.textfield.addTraverseListener((TraverseListener)new /* Unavailable Anonymous Inner Class!! */);
        return composite;
    }

    public String getContent() {
        return this.content;
    }

    public MultilineTextCellEditor getEditor() {
        return this.editor;
    }

    public void init() {
        this.setLogoImage(null);
        String title = String.valueOf(this.editedElement.getMetaclassName()) + " - " + this.fieldName;
        this.getShell().setText(title);
        this.setTitle(title);
        this.setMessage(CoreUi.I18N.getString("MultipleTextInputHelp"));
        this.dialogActive = true;
    }

    public int open() {
        return super.open();
    }

    public void setContent(String newContent) {
        this.content = newContent;
    }

    protected void cancelPressed() {
        this.editor.closeEditor(false);
        this.dialogActive = false;
        super.cancelPressed();
    }

    protected Image getBundleImage(String relativePath) {
        Bundle imageBundle = Platform.getBundle((String)"org.modelio.core.ui");
        Path bitmapPath = new Path(relativePath);
        URL bitmapUrl = FileLocator.find((Bundle)imageBundle, (IPath)bitmapPath, null);
        ImageDescriptor desc = ImageDescriptor.createFromURL((URL)bitmapUrl);
        return desc.createImage();
    }

    protected void okPressed() {
        this.dialogActive = false;
        this.editor.setContent((Object)this.textfield.getText());
        super.okPressed();
    }

    protected Point getInitialSize() {
        return new Point(800, 600);
    }
}

