/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.core.ui.ktable.editors.multiple;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.ui.ModelioDialog;
import com.modeliosoft.modelio.api.ui.dnd.EditorDropListener;
import com.modeliosoft.modelio.api.ui.dnd.IEditorDropClient;
import com.modeliosoft.modelio.api.ui.dnd.ModelElementTransfer;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.app.O;
import com.modeliosoft.modelio.core.app.events.IPickingClient;
import com.modeliosoft.modelio.core.ui.ktable.editors.multiple.EditionDialog;
import com.modeliosoft.modelio.core.ui.ktable.editors.multiple.IEditionValidator;
import com.modeliosoft.modelio.core.ui.ktable.editors.multiple.LabelProvider;
import com.modeliosoft.modelio.core.ui.ktable.editors.multiple.MultipleElementCellEditor;
import com.modeliosoft.modelio.core.ui.ktable.editors.multiple.Searcher;
import com.modeliosoft.modelio.core.ui.ktable.editors.multiple.TreeContentProvider;
import com.modeliosoft.modelio.core.ui.plugin.CoreUi;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.PluginTransfer;
import org.osgi.framework.Bundle;

class EditionDialog
extends ModelioDialog
implements IEditorDropClient,
IPickingClient {
    private List<IElement> content;
    private Text textfield = null;
    private final Searcher searcher;
    private TableViewer searchResultTree = null;
    private TableViewer contentTree = null;
    private final Class<? extends IElement> targetClass;
    private final IEditionValidator editionValidator;
    private EditorDropListener dropListener;
    private Image upImage;
    private Image downImage;
    private final String fieldName;
    private final IElement editedElement;
    private MultipleElementCellEditor editor = null;
    boolean dialogActive = false;

    public EditionDialog(Shell parentShell, IModelingSession session, MultipleElementCellEditor editor, List<IElement> initialContent, IEditionValidator editionValidator) {
        super(parentShell);
        this.editedElement = editor.getEditedElement();
        this.fieldName = editor.getFieldName();
        this.targetClass = editor.getTargetClass();
        this.searcher = new Searcher(session, this.targetClass, editor.getElementFilter());
        this.content = new ArrayList<IElement>(initialContent);
        this.editor = editor;
        this.editionValidator = editionValidator;
        if (this.targetClass.isArray()) {
            throw new IllegalArgumentException("Target class cannot be an array");
        }
        int style = this.getShellStyle();
        style &= 0xFFFC7FFF;
        this.setShellStyle(style |= 0);
    }

    public boolean acceptDroppedElements(IElement[] target) {
        return target.length == 1 && this.targetClass.isAssignableFrom(target[0].getClass());
    }

    public boolean acceptElement(IElement target) {
        return this.targetClass.isAssignableFrom(target.getClass());
    }

    public void addButtonsInButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CLOSE_LABEL, false);
    }

    public boolean close() {
        if (this.upImage != null) {
            this.upImage.dispose();
            this.upImage = null;
        }
        if (this.downImage != null) {
            this.downImage.dispose();
            this.downImage = null;
        }
        return super.close();
    }

    public Control createContentArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new FormLayout());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setFont(parent.getFont());
        Group searchCriteriaGroup = new Group(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        searchCriteriaGroup.setLayout((Layout)gridLayout);
        FormData fd_searchCriteriaGroup = new FormData();
        fd_searchCriteriaGroup.top = new FormAttachment(0, 5);
        fd_searchCriteriaGroup.right = new FormAttachment(100, -5);
        fd_searchCriteriaGroup.left = new FormAttachment(0, 5);
        searchCriteriaGroup.setLayoutData((Object)fd_searchCriteriaGroup);
        searchCriteriaGroup.setText(CoreUi.I18N.getString("Search"));
        Label nameLabel = new Label((Composite)searchCriteriaGroup, 0);
        nameLabel.setText(CoreUi.I18N.getString("Pattern"));
        this.textfield = new Text((Composite)searchCriteriaGroup, 2052);
        this.textfield.setText(this.searcher.getExpression());
        this.textfield.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.textfield.addTraverseListener((TraverseListener)new /* Unavailable Anonymous Inner Class!! */);
        this.textfield.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        Label resultsLabel = new Label((Composite)searchCriteriaGroup, 0);
        resultsLabel.setLayoutData((Object)new GridData(4, 1024, true, true, 2, 1));
        resultsLabel.setText(CoreUi.I18N.getString("SearchResults"));
        this.searchResultTree = new TableViewer((Composite)searchCriteriaGroup, 2048);
        this.searchResultTree.getTable().setLayoutData((Object)new GridData(4, 1024, true, true, 2, 1));
        this.searchResultTree.setContentProvider((IContentProvider)new TreeContentProvider(null));
        this.searchResultTree.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.searchResultTree.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.searchResultTree.getTable().addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */);
        Button upButton = new Button(composite, 12);
        FormData fd_up = new FormData();
        fd_up.top = new FormAttachment((Control)searchCriteriaGroup, 5, 1024);
        fd_up.left = new FormAttachment(50, -25);
        upButton.setLayoutData((Object)fd_up);
        this.upImage = this.getBundleImage("icons/up_16.png");
        upButton.setImage(this.upImage);
        Button downButton = new Button(composite, 8);
        FormData fd_down = new FormData();
        fd_down.top = new FormAttachment((Control)upButton, 0, 128);
        fd_down.left = new FormAttachment((Control)upButton, 5, 131072);
        downButton.setLayoutData((Object)fd_down);
        this.downImage = this.getBundleImage("icons/down_16.png");
        downButton.setImage(this.downImage);
        downButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        upButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        Group contentGroup = new Group(composite, 32);
        FormLayout contentLayout = new FormLayout();
        contentGroup.setLayout((Layout)contentLayout);
        FormData fd_contentGroup = new FormData();
        fd_contentGroup.top = new FormAttachment((Control)upButton, 5, 1024);
        fd_contentGroup.right = new FormAttachment(100, -5);
        fd_contentGroup.left = new FormAttachment(0, 5);
        fd_contentGroup.bottom = new FormAttachment(100, -5);
        contentGroup.setLayoutData((Object)fd_contentGroup);
        contentGroup.setText(CoreUi.I18N.getString("ChoosenElements"));
        this.contentTree = new TableViewer((Composite)contentGroup, 2048);
        FormData fd_contentTree = new FormData();
        fd_contentTree.top = new FormAttachment(0, 5);
        fd_contentTree.bottom = new FormAttachment(100, -5);
        fd_contentTree.right = new FormAttachment(100, -5);
        fd_contentTree.left = new FormAttachment(0, 5);
        this.contentTree.getTable().setLayoutData((Object)fd_contentTree);
        this.contentTree.setContentProvider((IContentProvider)new TreeContentProvider(this.content));
        this.contentTree.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.contentTree.getTable().addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */);
        this.contentTree.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.contentTree.setInput((Object)this.content);
        PickingHandler p = new PickingHandler(this);
        this.getShell().addShellListener((ShellListener)p);
        this.getShell().addDisposeListener((DisposeListener)p);
        this.initDropTarget();
        return composite;
    }

    public List<IElement> getContent() {
        return this.content;
    }

    public TableViewer getContentTree() {
        return this.contentTree;
    }

    public Image getDownImage() {
        return this.downImage;
    }

    public EditorDropListener getDropListener() {
        return this.dropListener;
    }

    public IElement getEditedElement() {
        return this.editedElement;
    }

    public IEditionValidator getEditionValidator() {
        return this.editionValidator;
    }

    public MultipleElementCellEditor getEditor() {
        return this.editor;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public TableViewer getSearchResultTree() {
        return this.searchResultTree;
    }

    public Searcher getSearcher() {
        return this.searcher;
    }

    public Class<? extends IElement> getTargetClass() {
        return this.targetClass;
    }

    public Text getTextfield() {
        return this.textfield;
    }

    public Image getUpImage() {
        return this.upImage;
    }

    public void init() {
        String targetName;
        this.setLogoImage(null);
        try {
            targetName = (String)this.targetClass.getDeclaredField("MetaclassName").get(this.targetClass);
        }
        catch (Exception e) {
            targetName = "elements";
        }
        String titleKey = String.valueOf(this.editedElement.getMetaclassName()) + this.fieldName + targetName;
        this.getShell().setText(CoreUi.I18N.getString(titleKey));
        this.setTitle(CoreUi.I18N.getString(titleKey));
        this.setMessage(CoreUi.I18N.getString("MultipleInputHelp"));
        this.dialogActive = true;
    }

    public int open() {
        return super.open();
    }

    public void pickingAborted() {
        this.editor.closeEditor(true);
        this.dialogActive = false;
        this.close();
    }

    public void setContent(List<IElement> newContent) {
        this.content = new ArrayList<IElement>(newContent);
        this.contentTree.setInput((Object)this.content);
    }

    public void setDroppedElements(IElement[] target) {
        if (target != null && target.length == 1 && !this.content.contains(target[0])) {
            this.content.add(target[0]);
            this.contentTree.refresh();
        }
    }

    public boolean setElement(IElement target) {
        if (this.acceptElement(target)) {
            if (!this.content.contains(target)) {
                this.content.add(target);
                this.contentTree.setInput((Object)this.content);
            }
            return true;
        }
        return false;
    }

    protected void cancelPressed() {
        this.editor.closeEditor(false);
        O.getDefault().getPickingClientService().endPicking((IPickingClient)this);
        this.dialogActive = false;
        super.cancelPressed();
    }

    protected Image getBundleImage(String relativePath) {
        Bundle imageBundle = Platform.getBundle((String)"org.modelio.core.ui");
        Path bitmapPath = new Path(relativePath);
        URL bitmapUrl = FileLocator.find((Bundle)imageBundle, (IPath)bitmapPath, null);
        ImageDescriptor desc = ImageDescriptor.createFromURL((URL)bitmapUrl);
        return desc.createImage();
    }

    protected void okPressed() {
        this.editionValidator.validate(this.getContent());
        this.dialogActive = false;
        super.okPressed();
    }

    private void initDropTarget() {
        this.dropListener = new EditorDropListener((IEditorDropClient)this);
        int operations = 3;
        Transfer[] types = new Transfer[]{ModelElementTransfer.getInstance(), PluginTransfer.getInstance()};
        DropTarget target = new DropTarget(this.contentTree.getControl(), 3);
        target.setTransfer(types);
        target.addDropListener((DropTargetListener)this.dropListener);
    }

    static /* synthetic */ Searcher access$0(EditionDialog editionDialog) {
        return editionDialog.searcher;
    }

    static /* synthetic */ Text access$1(EditionDialog editionDialog) {
        return editionDialog.textfield;
    }

    static /* synthetic */ TableViewer access$2(EditionDialog editionDialog) {
        return editionDialog.searchResultTree;
    }

    static /* synthetic */ List access$3(EditionDialog editionDialog) {
        return editionDialog.content;
    }

    static /* synthetic */ TableViewer access$4(EditionDialog editionDialog) {
        return editionDialog.contentTree;
    }

    static /* synthetic */ MultipleElementCellEditor access$5(EditionDialog editionDialog) {
        return editionDialog.editor;
    }
}

