/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.core.ui.ktable.editors.multiple;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.model.IElementFilter;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;

class Searcher {
    private String expression = "";
    private IModelingSession session = null;
    private Class<? extends IElement> targetClass;
    private IElementFilter elementFilter = null;

    public Searcher(IModelingSession session, Class<? extends IElement> targetClass, IElementFilter elementFilter) {
        this.session = session;
        if (targetClass == null) {
            throw new IllegalArgumentException("Target class cannot be NULL");
        }
        this.targetClass = targetClass.isArray() ? targetClass.getComponentType() : targetClass;
        this.elementFilter = elementFilter;
    }

    public String getExpression() {
        return this.expression;
    }

    public List<IElement> search() {
        List rawResults = this.session.getModel().findByClass(this.targetClass);
        Vector<IElement> filteredResults = new Vector<IElement>();
        Pattern p = Pattern.compile(this.expression);
        for (IElement e : rawResults) {
            if (!(e instanceof IModelElement)) continue;
            IModelElement me = (IModelElement)e;
            if (p.matcher(me.getName()).matches() && this.elementFilter == null) {
                filteredResults.add(e);
                continue;
            }
            if (!p.matcher(me.getName()).matches() || !this.elementFilter.accept(e)) continue;
            filteredResults.add(e);
        }
        return filteredResults;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }
}

