/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.core.ui.ktable.editors.stringList;

import com.modeliosoft.modelio.api.ui.ModelioDialog;
import com.modeliosoft.modelio.core.ui.ktable.editors.stringList.AddButtonListener;
import com.modeliosoft.modelio.core.ui.ktable.editors.stringList.ContentTableListener;
import com.modeliosoft.modelio.core.ui.ktable.editors.stringList.IStringListValidator;
import com.modeliosoft.modelio.core.ui.ktable.editors.stringList.MoveDownButtonListener;
import com.modeliosoft.modelio.core.ui.ktable.editors.stringList.MoveUpButtonListener;
import com.modeliosoft.modelio.core.ui.ktable.editors.stringList.RemoveButtonListener;
import com.modeliosoft.modelio.core.ui.ktable.editors.stringList.StringAdapter;
import com.modeliosoft.modelio.core.ui.ktable.editors.stringList.StringAdapterEditorActivationStrategy;
import com.modeliosoft.modelio.core.ui.ktable.editors.stringList.StringAdapterModifier;
import com.modeliosoft.modelio.core.ui.ktable.editors.stringList.StringListCellEditor;
import com.modeliosoft.modelio.core.ui.ktable.editors.stringList.StringListContentProvider;
import com.modeliosoft.modelio.core.ui.ktable.editors.stringList.StringListLabelProvider;
import com.modeliosoft.modelio.core.ui.ktable.editors.stringList.StringTextListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;

class StringListEditionDialog
extends ModelioDialog {
    private List<StringAdapter> content = null;
    private TableViewer contentTable = null;
    private Image addImage = null;
    private Image removeImage = null;
    private StringListCellEditor editor = null;
    private Button addParameterButton = null;
    private Button removeParameterButton = null;
    private IStringListValidator editionValidator = null;
    private String title = "";
    private StringAdapterModifier stringAdapterModifier = null;
    private Text addStringText = null;
    private StringTextListener stringTextListener = null;
    private String message = "";
    private String detailedMessage = "";
    private int size = 0;
    private ContentTableListener contentTableListener = null;
    private Image moveUpImage = null;
    private Image moveDownImage = null;
    private Button moveUpParameterButton = null;
    private Button moveDownParameterButton = null;
    private AddButtonListener addButtonListener = null;
    private MoveUpButtonListener moveUpButtonListener = null;
    private MoveDownButtonListener moveDownButtonListener = null;
    private RemoveButtonListener removeButtonListener = null;

    public StringListEditionDialog(Shell parentShell, String title, String message, int size, String detailedMessage, StringListCellEditor editor, List<String> initialContent, IStringListValidator editionValidator) {
        super(parentShell);
        this.title = title;
        this.message = message;
        this.size = size;
        this.detailedMessage = detailedMessage;
        this.content = this.initContent(initialContent);
        this.editor = editor;
        this.editionValidator = editionValidator;
        this.addImage = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.modelio.core.ui", (String)"icons/add_16.png").createImage();
        this.removeImage = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.modelio.core.ui", (String)"icons/remove_16.png").createImage();
        this.moveUpImage = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.modelio.core.ui", (String)"icons/up_16.png").createImage();
        this.moveDownImage = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.modelio.core.ui", (String)"icons/down_16.png").createImage();
    }

    public void addAdapter(StringAdapter adapter) {
        this.content.add(adapter);
        this.refresh();
    }

    public void addButtonsInButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    public boolean close() {
        if (this.moveUpButtonListener != null) {
            this.moveUpParameterButton.removeSelectionListener((SelectionListener)this.moveUpButtonListener);
            this.moveUpButtonListener = null;
        }
        if (this.moveDownButtonListener != null) {
            this.moveDownParameterButton.removeSelectionListener((SelectionListener)this.moveDownButtonListener);
            this.moveDownButtonListener = null;
        }
        if (this.removeButtonListener != null) {
            this.removeParameterButton.removeSelectionListener((SelectionListener)this.removeButtonListener);
            this.removeParameterButton = null;
        }
        if (this.addButtonListener != null) {
            this.addParameterButton.removeSelectionListener((SelectionListener)this.addButtonListener);
            this.addButtonListener = null;
        }
        if (this.stringTextListener != null) {
            this.addStringText.removeModifyListener((ModifyListener)this.stringTextListener);
            this.addStringText.removeKeyListener((KeyListener)this.stringTextListener);
            this.stringTextListener = null;
        }
        if (this.contentTableListener != null) {
            this.contentTable.removeSelectionChangedListener((ISelectionChangedListener)this.contentTableListener);
            this.contentTable.getTable().removeKeyListener((KeyListener)this.contentTableListener);
            this.contentTable.getTable().removeControlListener((ControlListener)this.contentTableListener);
            this.contentTableListener = null;
        }
        if (this.addImage != null) {
            this.addImage.dispose();
            this.addImage = null;
        }
        if (this.removeImage != null) {
            this.removeImage.dispose();
            this.removeImage = null;
        }
        if (this.moveUpImage != null) {
            this.moveUpImage.dispose();
            this.moveUpImage = null;
        }
        if (this.moveDownImage != null) {
            this.moveDownImage.dispose();
            this.moveDownImage = null;
        }
        return super.close();
    }

    public Control createContentArea(Composite parent) {
        Composite area = new Composite(parent, 0);
        area.setLayout((Layout)new GridLayout(2, false));
        area.setLayoutData((Object)new GridData(4, 4, true, true));
        area.setFont(parent.getFont());
        this.createDetailedText(area);
        this.createListField(area);
        this.createListButtons(area);
        this.createAddStringField(area);
        this.initListeners();
        this.getShell().pack();
        return area;
    }

    public Button getAddParameterButton() {
        return this.addParameterButton;
    }

    public Text getAddStringText() {
        return this.addStringText;
    }

    public TableViewer getContentTable() {
        return this.contentTable;
    }

    public Button getMoveDownParameterButton() {
        return this.moveDownParameterButton;
    }

    public Button getMoveUpParameterButton() {
        return this.moveUpParameterButton;
    }

    public Button getRemoveParameterButton() {
        return this.removeParameterButton;
    }

    public List<StringAdapter> getSelectedAdapters() {
        IStructuredSelection structuredSelection = (IStructuredSelection)this.contentTable.getSelection();
        return structuredSelection.toList();
    }

    public void init() {
        this.setLogoImage(null);
        this.getShell().setText(this.title);
        this.setTitle(this.title);
        this.setMessage(this.message);
        Point minSize = new Point(440, 270);
        this.getShell().setMinimumSize(minSize);
    }

    public void moveDown(List<StringAdapter> adapters) {
        int i = adapters.size() - 1;
        while (i > -1) {
            StringAdapter adapter = adapters.get(i);
            int index = this.getIndexDown(adapter, this.content);
            if (index == -1) break;
            this.content.remove(adapter);
            this.content.add(index, adapter);
            --i;
        }
        this.refresh();
    }

    public void moveUp(List<StringAdapter> adapters) {
        for (StringAdapter adapter : adapters) {
            int index = this.getIndexUp(adapter, this.content);
            if (index == -1) break;
            this.content.remove(adapter);
            this.content.add(index, adapter);
        }
        this.refresh();
    }

    public int open() {
        return super.open();
    }

    public void refresh() {
        this.contentTable.setInput((Object)this.content);
        if (this.size != -1) {
            this.addStringText.setEnabled(this.content.size() < this.size);
        }
    }

    public void removeAdapters(List<StringAdapter> adapters) {
        for (StringAdapter adapter : adapters) {
            this.content.remove(adapter);
        }
        this.refresh();
    }

    protected void cancelPressed() {
        this.editor.closeEditor(false);
        super.cancelPressed();
    }

    protected Image getBundleImage(String relativePath) {
        Bundle imageBundle = Platform.getBundle((String)"org.modelio.core.ui");
        Path bitmapPath = new Path(relativePath);
        URL bitmapUrl = FileLocator.find((Bundle)imageBundle, (IPath)bitmapPath, null);
        ImageDescriptor desc = ImageDescriptor.createFromURL((URL)bitmapUrl);
        return desc.createImage();
    }

    protected void okPressed() {
        List values = this.getValues(this.content);
        this.editionValidator.validate(values);
        this.editor.closeEditor(true);
        super.okPressed();
    }

    private void createAddStringField(Composite area) {
        this.addStringText = new Text(area, 2048);
        if (this.size != -1) {
            this.addStringText.setEnabled(this.content.size() < this.size);
        }
        GridData gd_addStringText = new GridData(4, 128, true, false);
        this.addStringText.setLayoutData((Object)gd_addStringText);
        this.addStringText.forceFocus();
        this.addParameterButton = new Button(area, 0);
        this.addParameterButton.setImage(this.addImage);
        this.addParameterButton.setEnabled(false);
        GridData gd_addParameterButton = new GridData(16384, 128, false, false);
        gd_addParameterButton.heightHint = 21;
        gd_addParameterButton.widthHint = 21;
        this.addParameterButton.setLayoutData((Object)gd_addParameterButton);
    }

    private void createDetailedText(Composite area) {
        if (this.detailedMessage != null && !this.detailedMessage.equals("")) {
            Label detailText = new Label(area, 0);
            detailText.setText(this.detailedMessage);
            GridData gd_detailText = new GridData(4, 128, true, false, 2, 1);
            gd_detailText.horizontalIndent = 3;
            detailText.setLayoutData((Object)gd_detailText);
        }
    }

    private void createListButtons(Composite area) {
        Composite buttonsComposite = new Composite(area, 0);
        GridLayout gl_buttonComposite = new GridLayout(1, false);
        gl_buttonComposite.marginWidth = 0;
        gl_buttonComposite.marginHeight = 0;
        buttonsComposite.setLayout((Layout)gl_buttonComposite);
        GridData gd_buttonsComposite = new GridData(16384, 128, false, false);
        buttonsComposite.setLayoutData((Object)gd_buttonsComposite);
        this.moveUpParameterButton = new Button(buttonsComposite, 0);
        this.moveUpParameterButton.setImage(this.moveUpImage);
        this.moveUpParameterButton.setEnabled(false);
        GridData gd_moveUpParameterButton = new GridData(16384, 128, false, false);
        gd_moveUpParameterButton.heightHint = 21;
        gd_moveUpParameterButton.widthHint = 21;
        this.moveUpParameterButton.setLayoutData((Object)gd_moveUpParameterButton);
        this.moveDownParameterButton = new Button(buttonsComposite, 0);
        this.moveDownParameterButton.setImage(this.moveDownImage);
        this.moveDownParameterButton.setEnabled(false);
        GridData gd_moveDownParameterButton = new GridData(16384, 128, false, false);
        gd_moveDownParameterButton.heightHint = 21;
        gd_moveDownParameterButton.widthHint = 21;
        this.moveDownParameterButton.setLayoutData((Object)gd_moveDownParameterButton);
        this.removeParameterButton = new Button(buttonsComposite, 0);
        this.removeParameterButton.setImage(this.removeImage);
        this.removeParameterButton.setEnabled(false);
        GridData gd_removeParameterButton = new GridData(16384, 128, false, false);
        gd_removeParameterButton.heightHint = 21;
        gd_removeParameterButton.widthHint = 21;
        this.removeParameterButton.setLayoutData((Object)gd_removeParameterButton);
    }

    private void createListField(Composite area) {
        this.contentTable = new TableViewer(area);
        String[] columnNames = new String[]{"Value"};
        TableColumn column0 = new TableColumn(this.contentTable.getTable(), 16384, 0);
        column0.setWidth(150);
        this.contentTable.setColumnProperties(columnNames);
        this.contentTable.setContentProvider((IContentProvider)new StringListContentProvider());
        this.contentTable.setLabelProvider((IBaseLabelProvider)new StringListLabelProvider());
        this.initEditor();
        this.contentTable.setInput((Object)this.content);
        GridData gd_contentTree = new GridData(4, 4, true, true);
        this.contentTable.getControl().setLayoutData((Object)gd_contentTree);
    }

    private int getIndexDown(StringAdapter adapter, List<StringAdapter> list) {
        int index = list.indexOf(adapter);
        if (index == -1) {
            return -1;
        }
        if (++index >= list.size()) {
            return -1;
        }
        return index;
    }

    private int getIndexUp(StringAdapter adapter, List<StringAdapter> list) {
        int index = list.indexOf(adapter);
        if (index < 1) {
            return -1;
        }
        return --index;
    }

    private List<String> getValues(List<StringAdapter> adapters) {
        ArrayList<String> values = new ArrayList<String>();
        for (StringAdapter adapter : adapters) {
            values.add(adapter.getValue());
        }
        return values;
    }

    private List<StringAdapter> initContent(List<String> values) {
        ArrayList<StringAdapter> adapters = new ArrayList<StringAdapter>();
        for (String value : values) {
            adapters.add(new StringAdapter(value));
        }
        return adapters;
    }

    private void initEditor() {
        TextCellEditor[] cellEditors = new TextCellEditor[]{new TextCellEditor((Composite)this.contentTable.getTable(), 0)};
        this.contentTable.setCellEditors((CellEditor[])cellEditors);
        String[] properties = new String[]{"name"};
        this.contentTable.setColumnProperties(properties);
        this.stringAdapterModifier = new StringAdapterModifier(this);
        this.contentTable.setCellModifier((ICellModifier)this.stringAdapterModifier);
        this.contentTable.getTable().addKeyListener((KeyListener)this.stringAdapterModifier);
        StringAdapterEditorActivationStrategy actSupport = new StringAdapterEditorActivationStrategy((ColumnViewer)this.contentTable);
        TableViewerEditor.create((TableViewer)this.contentTable, null, (ColumnViewerEditorActivationStrategy)actSupport, (int)58);
    }

    private void initListeners() {
        this.contentTableListener = new ContentTableListener(this);
        this.contentTable.addSelectionChangedListener((ISelectionChangedListener)this.contentTableListener);
        this.contentTable.getTable().addKeyListener((KeyListener)this.contentTableListener);
        this.contentTable.getTable().addControlListener((ControlListener)this.contentTableListener);
        this.moveUpButtonListener = new MoveUpButtonListener(this);
        this.moveUpParameterButton.addSelectionListener((SelectionListener)this.moveUpButtonListener);
        this.moveDownButtonListener = new MoveDownButtonListener(this);
        this.moveDownParameterButton.addSelectionListener((SelectionListener)this.moveDownButtonListener);
        this.removeButtonListener = new RemoveButtonListener(this);
        this.removeParameterButton.addSelectionListener((SelectionListener)this.removeButtonListener);
        this.addButtonListener = new AddButtonListener(this);
        this.addParameterButton.addSelectionListener((SelectionListener)this.addButtonListener);
        this.stringTextListener = new StringTextListener(this);
        this.addStringText.addModifyListener((ModifyListener)this.stringTextListener);
        this.addStringText.addKeyListener((KeyListener)this.stringTextListener);
    }
}

