/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.core.ui.ktable.renderers;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.core.ui.EditionUI;
import com.modeliosoft.modelio.core.ui.ISharedImages;
import de.kupzog.ktable.KTable;
import de.kupzog.ktable.KTableModel;
import de.kupzog.ktable.SWTX;
import de.kupzog.ktable.renderers.DefaultCellRenderer;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class HybridCellRenderer
extends DefaultCellRenderer {
    protected Text m_text;
    private Image indicatorImage = null;
    private boolean displayOwner = true;
    private static String RENDERER_LIGHTBULB = "renderer.lightbulb";

    public HybridCellRenderer(KTable table, int style, boolean displayOwner) {
        super(style);
        this.displayOwner = displayOwner;
        ISharedImages sharedImage = EditionUI.getSharedImages();
        this.indicatorImage = sharedImage.getImage(RENDERER_LIGHTBULB);
        if (this.indicatorImage == null) {
            ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.modelio.core.ui", (String)"icons/indicator.png");
            sharedImage.declareImage(RENDERER_LIGHTBULB, imageDescriptor);
            this.indicatorImage = sharedImage.getImage(RENDERER_LIGHTBULB);
        }
    }

    public int getOptimalWidth(GC gc, int col, int row, Object content, boolean fixed, KTableModel model) {
        String text;
        if (content == null) {
            text = "null";
        } else if (content instanceof IModelElement) {
            IElement owner;
            IModelElement me = (IModelElement)content;
            text = me.getName();
            if (this.displayOwner && (owner = me.getCompositionOwner()) instanceof IModelElement) {
                text = String.valueOf(text) + " (from " + ((IModelElement)owner).getName() + ")";
            }
        } else {
            text = content instanceof String ? (String)content : (content instanceof IElement ? ((IElement)content).getMetaclassName() : content.getClass().getSimpleName());
        }
        int width = SWTX.getCachedStringExtent((GC)gc, (String)text).x + 20;
        if (this.indicatorImage != null) {
            width += this.indicatorImage.getBounds().width;
        }
        return width;
    }

    public void drawCell(GC gc, Rectangle initialRect, int col, int row, Object content, boolean focus, boolean fixed, boolean clicked, KTableModel model) {
        String text;
        Rectangle rect = initialRect;
        this.applyFont(gc);
        if (content == null) {
            text = "null";
        } else if (content instanceof IModelElement) {
            IElement owner;
            IModelElement me = (IModelElement)content;
            text = me.getName();
            if (this.displayOwner && (owner = me.getCompositionOwner()) instanceof IModelElement) {
                text = String.valueOf(text) + " (from " + ((IModelElement)owner).getName() + ")";
            }
        } else {
            text = content instanceof String ? (String)content : (content instanceof IElement ? ((IElement)content).getMetaclassName() : content.getClass().getSimpleName());
        }
        if (focus && (this.m_Style & 0x10) != 0) {
            rect = this.drawDefaultSolidCellLine(gc, rect, COLOR_LINE_LIGHTGRAY, COLOR_LINE_LIGHTGRAY);
            this.drawCellContent(gc, rect, text, null, this.getForeground(), COLOR_BGFOCUS);
            gc.drawFocus(rect.x, rect.y, rect.width, rect.height);
        } else if (focus && (this.m_Style & 0x20) != 0) {
            rect = this.drawDefaultSolidCellLine(gc, rect, COLOR_BGROWFOCUS, COLOR_BGROWFOCUS);
            this.drawCellContent(gc, rect, text, null, COLOR_FGROWFOCUS, COLOR_BGROWFOCUS);
        } else {
            rect = this.drawDefaultSolidCellLine(gc, rect, COLOR_LINE_LIGHTGRAY, COLOR_LINE_LIGHTGRAY);
            this.drawCellContent(gc, rect, text, null, this.getForeground(), this.getBackground());
        }
        if ((this.m_Style & 0x80) != 0) {
            this.drawCommentSign(gc, rect);
        }
        this.drawIndicator(gc, rect);
        this.resetFont(gc);
    }

    public void setCommentIndication(boolean value) {
        this.m_Style = value ? (this.m_Style |= 0x80) : (this.m_Style &= 0xFFFFFF7F);
    }

    protected final void drawIndicator(GC gc, Rectangle rect) {
        if (this.indicatorImage != null) {
            Rectangle imageRect = this.indicatorImage.getBounds();
            gc.drawImage(this.indicatorImage, rect.x + rect.width - imageRect.width, rect.y);
        }
    }

    protected void finalize() throws Throwable {
        this.indicatorImage = null;
        super.finalize();
    }

    public Image getIndicatorImage() {
        return this.indicatorImage;
    }

    public Text getM_text() {
        return this.m_text;
    }
}

