/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.core.ui.ktable.renderers;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.core.app.StandardImageService;
import de.kupzog.ktable.KTable;
import de.kupzog.ktable.KTableModel;
import de.kupzog.ktable.SWTX;
import de.kupzog.ktable.renderers.DefaultCellRenderer;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Text;

public class ImageCellRenderer
extends DefaultCellRenderer {
    protected Text m_text;
    private Image image = null;

    public ImageCellRenderer(KTable table, int style, Class<? extends IElement> metaclass, String dependencyName) {
        super(style);
        this.image = StandardImageService.getMetaclassImage((String)dependencyName, metaclass);
    }

    public int getOptimalWidth(GC gc, int col, int row, Object content, boolean fixed, KTableModel model) {
        return SWTX.getCachedStringExtent((GC)gc, (String)content.toString()).x + 8;
    }

    public void drawCell(GC gc, Rectangle initialRect, int col, int row, Object content, boolean focus, boolean fixed, boolean clicked, KTableModel model) {
        Rectangle rect = initialRect;
        this.applyFont(gc);
        String text = (String)content;
        if (focus && (this.m_Style & 0x10) != 0) {
            rect = this.drawDefaultSolidCellLine(gc, rect, COLOR_LINE_LIGHTGRAY, COLOR_LINE_LIGHTGRAY);
            this.drawCellContent(gc, rect, text, null, this.getForeground(), COLOR_BGFOCUS);
            gc.drawFocus(rect.x, rect.y, rect.width, rect.height);
        } else if (focus && (this.m_Style & 0x20) != 0) {
            rect = this.drawDefaultSolidCellLine(gc, rect, COLOR_BGROWFOCUS, COLOR_BGROWFOCUS);
            this.drawCellContent(gc, rect, text, null, COLOR_FGROWFOCUS, COLOR_BGROWFOCUS);
        } else {
            rect = this.drawDefaultSolidCellLine(gc, rect, COLOR_LINE_LIGHTGRAY, COLOR_LINE_LIGHTGRAY);
            this.drawCellContent(gc, rect, text, null, this.getForeground(), this.getBackground());
        }
        if ((this.m_Style & 0x80) != 0) {
            this.drawCommentSign(gc, rect);
        }
        this.drawImage(gc, rect);
        this.resetFont(gc);
    }

    public void setCommentIndication(boolean value) {
        this.m_Style = value ? (this.m_Style |= 0x80) : (this.m_Style &= 0xFFFFFF7F);
    }

    protected final void drawImage(GC gc, Rectangle rect) {
        if (this.image != null) {
            Rectangle imageRect = this.image.getBounds();
            gc.drawImage(this.image, rect.x + rect.width - imageRect.width, rect.y);
        }
    }
}

