/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.core.ui.ktable.renderers;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IExternDocument;
import com.modeliosoft.modelio.core.app.O;
import com.modeliosoft.modelio.core.app.StandardImageService;
import com.modeliosoft.modelio.core.documents.DocumentFormat;
import com.modeliosoft.modelio.core.ui.EditionUI;
import de.kupzog.ktable.KTableModel;
import de.kupzog.ktable.SWTX;
import de.kupzog.ktable.renderers.DefaultCellRenderer;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Text;

public class ScopeRichTextCellRenderer
extends DefaultCellRenderer {
    protected Text m_text;
    private Image image = null;

    public ScopeRichTextCellRenderer(int style) {
        super(style);
    }

    public int getOptimalWidth(GC gc, int col, int row, Object content, boolean fixed, KTableModel model) {
        if (content == null) {
            return 30;
        }
        return SWTX.getCachedStringExtent((GC)gc, (String)content.toString()).x + 8;
    }

    public void drawCell(GC gc, Rectangle initialRect, int col, int row, Object content, boolean focus, boolean fixed, boolean clicked, KTableModel model) {
        Rectangle rect = initialRect;
        this.applyFont(gc);
        this.image = null;
        if (content != null && content instanceof IExternDocument) {
            IExternDocument externDocument = (IExternDocument)content;
            String mimeType = externDocument.getMimeType();
            DocumentFormat format = O.getDefault().getDocumentFormatsRegistry().getDocumentFormatForMime(mimeType);
            if (format != null) {
                ImageDescriptor desc = format.getIconDescriptor();
                this.image = desc != null ? this.getCmsDecoratedImage(format.toString(), desc) : StandardImageService.getCmsStereotypedImage((IElement)externDocument, null);
            }
        } else if (!"".equals(content)) {
            this.image = EditionUI.getSharedImages().getImage("edition.dot");
        }
        String text = "";
        if (focus && (this.m_Style & 0x10) != 0) {
            rect = this.drawDefaultSolidCellLine(gc, rect, COLOR_LINE_LIGHTGRAY, COLOR_LINE_LIGHTGRAY);
            this.drawCellContent(gc, rect, text, null, this.getForeground(), COLOR_BGFOCUS);
            gc.drawFocus(rect.x, rect.y, rect.width, rect.height);
        } else if (focus && (this.m_Style & 0x20) != 0) {
            rect = this.drawDefaultSolidCellLine(gc, rect, COLOR_BGROWFOCUS, COLOR_BGROWFOCUS);
            this.drawCellContent(gc, rect, text, null, COLOR_FGROWFOCUS, COLOR_BGROWFOCUS);
        } else {
            rect = this.drawDefaultSolidCellLine(gc, rect, COLOR_LINE_LIGHTGRAY, COLOR_LINE_LIGHTGRAY);
            this.drawCellContent(gc, rect, text, null, this.getForeground(), this.getBackground());
        }
        if ((this.m_Style & 0x80) != 0) {
            this.drawCommentSign(gc, rect);
        }
        this.drawImage(gc, rect);
        this.resetFont(gc);
    }

    private Image getCmsDecoratedImage(String imageKey, ImageDescriptor descriptor) {
        String key = "MDAC." + imageKey + ".ICON";
        Image img = StandardImageService.getImage((String)key);
        if (img == null) {
            StandardImageService.declareImage((String)key, (ImageDescriptor)descriptor);
            img = StandardImageService.getImage((String)key);
        }
        return img;
    }

    public void setCommentIndication(boolean value) {
        this.m_Style = value ? (this.m_Style |= 0x80) : (this.m_Style &= 0xFFFFFF7F);
    }

    protected final void drawImage(GC gc, Rectangle rect) {
        if (this.image != null) {
            Rectangle imageRect = this.image.getBounds();
            gc.drawImage(this.image, rect.x + (rect.width - imageRect.width) / 2, rect.y);
        }
    }
}

