/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.core.ui.richnote;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IExternDocumentType;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.ui.richnote.DocTypeAdapter;
import com.modeliosoft.modelio.core.ui.richnote.DocTypeChooserContentProvider;
import com.modeliosoft.modelio.core.ui.richnote.DocTypeChooserDriver;
import com.modeliosoft.modelio.core.ui.richnote.DocTypeChooserLabelProvider;
import com.modeliosoft.modelio.core.ui.richnote.DocTypeChooserModel;
import com.modeliosoft.modelio.core.ui.richnote.DocTypeChooserSorter;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;

class DocTypeChooserDriver {
    IModelingSession session;
    private IModelElement element;
    private DocTypeChooserSelectionListener selectionListener = null;
    private DocTypeChooserModel leftModel;
    private TreeViewer leftViewer;

    public DocTypeChooserDriver(IModelingSession session) {
        this.session = session;
        this.selectionListener = new DocTypeChooserSelectionListener(this);
    }

    protected void finalize() throws Throwable {
        this.leftViewer.removeSelectionChangedListener((ISelectionChangedListener)this.selectionListener);
        super.finalize();
    }

    public StructuredViewer createViewer(Composite parent) {
        this.leftViewer = new TreeViewer(parent, 2048);
        this.leftViewer.setContentProvider((IContentProvider)new DocTypeChooserContentProvider());
        this.leftViewer.setLabelProvider((IBaseLabelProvider)new DocTypeChooserLabelProvider(this.session));
        this.leftViewer.setSorter((ViewerSorter)new DocTypeChooserSorter());
        this.leftViewer.setAutoExpandLevel(-1);
        this.leftViewer.addSelectionChangedListener((ISelectionChangedListener)this.selectionListener);
        return this.leftViewer;
    }

    public IExternDocumentType getSelection() {
        Object[] objectArray = ((IStructuredSelection)this.leftViewer.getSelection()).toArray();
        if (objectArray.length != 0) {
            Object obj = objectArray[0];
            DocTypeAdapter adapter = (DocTypeAdapter)obj;
            IExternDocumentType noteType = adapter.getDocType();
            return noteType;
        }
        return null;
    }

    public void init(IElement anElement) {
        if (anElement instanceof IModelElement) {
            this.element = (IModelElement)anElement;
            this.leftModel = new DocTypeChooserModel(this.session, this.element);
            this.leftViewer.setInput((Object)this.leftModel);
            this.setExpandedState();
        }
    }

    private void setExpandedState() {
        this.leftViewer.setAutoExpandLevel(3);
    }

    static /* synthetic */ TreeViewer access$0(DocTypeChooserDriver docTypeChooserDriver) {
        return docTypeChooserDriver.leftViewer;
    }
}

