/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.core.ui.richnote;

import com.modeliosoft.modelio.api.mdac.IMdac;
import com.modeliosoft.modelio.api.model.extension.IModule;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IExternDocument;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.app.StandardImageService;
import com.modeliosoft.modelio.core.mdacs.IMdacRegistry;
import com.modeliosoft.modelio.core.model.IMetamodelExtensions;
import com.modeliosoft.modelio.core.ui.richnote.DocTypeAdapter;
import com.modeliosoft.modelio.core.ui.richnote.DocTypeModuleAdapter;
import com.modeliosoft.modelio.core.ui.richnote.DocTypeStereotypeAdapter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

class DocTypeChooserLabelProvider
extends LabelProvider {
    private IModelingSession modelingSession = null;

    public DocTypeChooserLabelProvider(IModelingSession modelingSession) {
        this.modelingSession = modelingSession;
    }

    public Image getImage(Object element) {
        if (element instanceof DocTypeModuleAdapter) {
            DocTypeModuleAdapter adapter = (DocTypeModuleAdapter)element;
            IModule module = adapter.getMdac();
            return this.getModuleImage(module);
        }
        if (element instanceof DocTypeAdapter) {
            return StandardImageService.getMetaclassImage(IExternDocument.class);
        }
        if (element instanceof DocTypeStereotypeAdapter) {
            DocTypeStereotypeAdapter stereotypeAdapter = (DocTypeStereotypeAdapter)element;
            Image image = this.getStereotypeImage(stereotypeAdapter.getStereotype());
            if (image == null) {
                image = StandardImageService.getUmlIcon((IElement)stereotypeAdapter.getStereotype());
            }
            return image;
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof DocTypeModuleAdapter) {
            IMdacRegistry mdacRegistry;
            IMdac module;
            DocTypeModuleAdapter adapter = (DocTypeModuleAdapter)element;
            if (this.modelingSession != null && (module = (mdacRegistry = this.modelingSession.getMdacRegistry()).getLoadedMdac(adapter.getMdac())) != null) {
                return module.getLabel();
            }
            return adapter.getMdac().getName();
        }
        if (element instanceof DocTypeAdapter) {
            StringBuffer noteTypeLabel = new StringBuffer();
            DocTypeAdapter adapter = (DocTypeAdapter)element;
            String label = adapter.getDocType().getLabel();
            if (!"".equals(label)) {
                noteTypeLabel.append(label);
            } else {
                noteTypeLabel.append(adapter.getDocType().getName());
            }
            return noteTypeLabel.toString();
        }
        if (element instanceof DocTypeStereotypeAdapter) {
            StringBuffer noteTypeLabel = new StringBuffer();
            DocTypeStereotypeAdapter adapter = (DocTypeStereotypeAdapter)element;
            noteTypeLabel.append("<<");
            String label = adapter.getStereotype().getLabel();
            if (!"".equals(label)) {
                noteTypeLabel.append(label);
            } else {
                noteTypeLabel.append(adapter.getStereotype().getName());
            }
            noteTypeLabel.append(">>");
            return noteTypeLabel.toString();
        }
        return element.toString();
    }

    private Image getModuleImage(IModule moduleModel) {
        ImageDescriptor defaultModuleDescriptor;
        IMdacRegistry mdacRegistry;
        IMdac module;
        String key = "MDAC." + moduleModel.getName();
        Image moduleImage = StandardImageService.getImage((String)key);
        if (moduleImage != null) {
            return moduleImage;
        }
        if (this.modelingSession != null && (module = (mdacRegistry = this.modelingSession.getMdacRegistry()).getLoadedMdac(moduleModel)) != null) {
            ImageDescriptor moduleImageDescriptor = module.getMdacImageDescriptor();
            if (moduleImageDescriptor != null) {
                StandardImageService.declareImage((String)key, (ImageDescriptor)moduleImageDescriptor);
                moduleImage = StandardImageService.getImage((String)key);
            }
            if (moduleImage != null) {
                return moduleImage;
            }
        }
        if ((moduleImage = StandardImageService.getImage((String)"DefaultModuleImage")) == null && (defaultModuleDescriptor = StandardImageService.getUmlImageDescriptor((IElement)moduleModel)) != null) {
            StandardImageService.declareImage((String)"DefaultModuleImage", (ImageDescriptor)defaultModuleDescriptor);
            moduleImage = StandardImageService.getImage((String)"DefaultModuleImage");
        }
        return moduleImage;
    }

    private Image getStereotypeImage(IStereotype stereotype) {
        Image image = null;
        IMetamodelExtensions metamodelExtensions = this.modelingSession.getModel().getMetamodelExtensions();
        IModule module = metamodelExtensions.getModule(stereotype);
        if (module != null) {
            IMdac mdac = this.modelingSession.getMdacRegistry().getLoadedMdac(module);
            image = mdac.getImage(stereotype, IMdac.ImageType.ICON);
        }
        return image;
    }
}

