/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.core.ui.richnote;

import com.modeliosoft.modelio.api.model.extension.IModule;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IExternDocumentType;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import com.modeliosoft.modelio.api.utils.ObList;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.model.IMetamodelExtensions;
import com.modeliosoft.modelio.core.ui.richnote.DocTypeModuleAdapter;
import com.modeliosoft.modelio.core.ui.richnote.DocTypeStereotypeAdapter;
import java.util.HashMap;
import java.util.Map;

class DocTypeChooserModel {
    private IModelingSession session;
    Map<IModule, DocTypeModuleAdapter> mdacAdapters;
    private IModelElement element;

    DocTypeChooserModel(IModelingSession session, IModelElement element) {
        this.session = session;
        this.element = element;
        this.mdacAdapters = new HashMap();
        this.init();
    }

    DocTypeChooserModel(IModelingSession session) {
        this.session = session;
        this.element = null;
        this.mdacAdapters = new HashMap();
    }

    public DocTypeModuleAdapter getMdacAdapter(IModule module) {
        return (DocTypeModuleAdapter)this.mdacAdapters.get(module);
    }

    public Map<IModule, DocTypeModuleAdapter> getMdacAdapters() {
        return this.mdacAdapters;
    }

    public DocTypeStereotypeAdapter getStereotypeAdapter(IModule module, IStereotype stereotype) {
        DocTypeModuleAdapter mdacAdapter = (DocTypeModuleAdapter)this.mdacAdapters.get(module);
        if (mdacAdapter != null) {
            return mdacAdapter.getAdapter(stereotype);
        }
        return null;
    }

    void addDocType(IModule mdac, IExternDocumentType noteType) {
        DocTypeModuleAdapter adapter = (DocTypeModuleAdapter)this.mdacAdapters.get(mdac);
        if (adapter == null) {
            adapter = new DocTypeModuleAdapter(mdac);
            this.mdacAdapters.put(mdac, adapter);
        }
        adapter.addDocType(noteType);
    }

    void addStereotype(IModule mdac, IStereotype stereotype) {
        DocTypeModuleAdapter adapter = (DocTypeModuleAdapter)this.mdacAdapters.get(mdac);
        if (adapter == null) {
            adapter = new DocTypeModuleAdapter(mdac);
            this.mdacAdapters.put(mdac, adapter);
        }
        adapter.addStereotype(stereotype);
    }

    private void init() {
        IMetamodelExtensions extensions = this.session.getModel().getMetamodelExtensions();
        if (this.session == null) {
            return;
        }
        ObList stereotypes = this.element.getExtension();
        for (IStereotype stereotype : stereotypes) {
            IModule module;
            boolean hasDocTypes = false;
            ObList docTypes = stereotype.getDefinedExternDocumentType();
            for (IExternDocumentType docType : docTypes) {
                if (docType.isHidden()) continue;
                hasDocTypes = true;
                break;
            }
            if (!hasDocTypes || (module = extensions.getModule(stereotype)) == null || this.session.getMdacRegistry().getStartedMdac(module) == null) continue;
            this.addStereotype(module, stereotype);
        }
        ObList docTypes = extensions.getExternDocumentTypes(this.element.getClass());
        for (IExternDocumentType docType : docTypes) {
            IModule module;
            if (!docType.isHidden() && docType.getOwnerReference() != null) {
                module = extensions.getModule(docType);
                if (module == null || this.session.getMdacRegistry().getStartedMdac(module) == null) continue;
                this.addDocType(module, docType);
                continue;
            }
            if (docType.isHidden() || docType.getOwnerStereotype() == null || !this.element.isStereotyped(docType.getOwnerStereotype().getName()) || (module = extensions.getModule(docType)) == null || this.session.getMdacRegistry().getStartedMdac(module) == null) continue;
            this.addDocType(module, docType);
        }
    }
}

