/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.modelingwizard.autodiagram.creator;

import com.modeliosoft.modelio.api.diagram.IDiagramHandle;
import com.modeliosoft.modelio.api.diagram.IDiagramService;
import com.modeliosoft.modelio.api.model.IModelingSession;
import com.modeliosoft.modelio.api.model.diagrams.IAbstractDiagram;
import com.modeliosoft.modelio.api.model.diagrams.IClassDiagram;
import com.modeliosoft.modelio.api.model.diagrams.IDiagramSet;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.modelio.Modelio;
import com.modeliosoft.modelio.api.utils.StereotypeNotFoundException;
import com.modeliosoft.modelio.modelingwizard.autodiagram.creator.IDiagramCreator;

public abstract class AbstractDiagramCreator
implements IDiagramCreator {
    protected IModelingSession modelingSession;

    public AbstractDiagramCreator(IModelingSession session) {
        this.modelingSession = session;
    }

    public final IAbstractDiagram createDiagram(IModelElement main) throws StereotypeNotFoundException {
        IAbstractDiagram diagram;
        block15: {
            diagram = this.getExistingAutoDiagram(main);
            try {
                if (diagram == null) {
                    diagram = this.createAutoDiagram(main);
                }
                if (diagram != null) break block15;
                return null;
            }
            catch (Error e) {
                e.printStackTrace();
                if (diagram != null) {
                    diagram.delete();
                }
                return null;
            }
        }
        IDiagramService ds = Modelio.getInstance().getDiagramService();
        Throwable throwable = null;
        Object var5_7 = null;
        try (IDiagramHandle dh = ds.getDiagramHandle(diagram);){
            dh.setBatchMode(true);
            this.initialUnmasking(dh, main);
            this.layout(dh);
            dh.save();
            dh.setBatchMode(false);
            return diagram;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public final IAbstractDiagram getExistingAutoDiagram(IModelElement main) {
        IModelElement context = this.getAutoDiagramContext(main);
        if (context != null) {
            for (IAbstractDiagram diagram : context.getproduct()) {
                if (!diagram.getName().equals(String.valueOf(main.getName()) + " (" + this.getAutoDiagramName() + ")")) continue;
                return diagram;
            }
        }
        return null;
    }

    private IAbstractDiagram createAutoDiagram(IModelElement main) throws StereotypeNotFoundException {
        IModelElement context = this.getAutoDiagramContext(main);
        if (context == null) {
            return null;
        }
        IDiagramSet diagramroot = this.modelingSession.getModel().getUmlProject().getDiagramRoot();
        IDiagramSet allAutoDiagrams = null;
        for (IDiagramSet dset : diagramroot.getSub()) {
            if (!dset.getName().equals("Auto Diagrams")) continue;
            allAutoDiagrams = dset;
            break;
        }
        if (allAutoDiagrams == null) {
            allAutoDiagrams = (IDiagramSet)this.modelingSession.getModel().createElement("DiagramSet");
            allAutoDiagrams.setName("Auto Diagrams");
            diagramroot.addSub(allAutoDiagrams);
        }
        IDiagramSet autogroup = null;
        for (IDiagramSet dset : allAutoDiagrams.getSub()) {
            if (!dset.getName().equals(this.getAutoDiagramGroup())) continue;
            autogroup = dset;
            break;
        }
        if (autogroup == null) {
            autogroup = (IDiagramSet)this.modelingSession.getModel().createElement("DiagramSet");
            autogroup.setName(this.getAutoDiagramGroup());
            allAutoDiagrams.addSub(autogroup);
        }
        IClassDiagram diagram = this.modelingSession.getModel().createClassDiagram(String.valueOf(main.getName()) + " (" + this.getAutoDiagramName() + ")", context, "AutoDiagram");
        autogroup.addReferencedDiagram((IAbstractDiagram)diagram);
        return diagram;
    }

    protected abstract void initialUnmasking(IDiagramHandle var1, IModelElement var2);

    protected abstract void layout(IDiagramHandle var1);
}

