/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.modelingwizard.autodiagram.creator;

import com.modeliosoft.modelio.api.diagram.IDiagramHandle;
import com.modeliosoft.modelio.api.diagram.IDiagramLink;
import com.modeliosoft.modelio.api.diagram.IDiagramNode;
import com.modeliosoft.modelio.api.diagram.InvalidDestinationPointException;
import com.modeliosoft.modelio.api.diagram.InvalidPointsPathException;
import com.modeliosoft.modelio.api.diagram.InvalidSourcePointException;
import com.modeliosoft.modelio.api.model.IModelingSession;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.statik.IAssociationEnd;
import com.modeliosoft.modelio.api.model.uml.statik.IClassifier;
import com.modeliosoft.modelio.api.model.uml.statik.IGeneralization;
import com.modeliosoft.modelio.api.model.uml.statik.IInterfaceRealization;
import com.modeliosoft.modelio.api.model.uml.statik.IModelTree;
import com.modeliosoft.modelio.api.model.uml.statik.INameSpace;
import com.modeliosoft.modelio.api.model.uml.statik.IPackage;
import com.modeliosoft.modelio.modelingwizard.autodiagram.StyleConstants;
import com.modeliosoft.modelio.modelingwizard.autodiagram.creator.AbstractDiagramCreator;
import com.modeliosoft.modelio.modelingwizard.autodiagram.layout.DiagonalLayout;
import java.util.ArrayList;
import java.util.List;

public class PackageContentStructureCreator
extends AbstractDiagramCreator {
    public List<IDiagramNode> _contentDgs = new ArrayList();

    public PackageContentStructureCreator(IModelingSession session) {
        super(session);
    }

    public String getAutoDiagramName() {
        return "structure_autodiagram";
    }

    public String getAutoDiagramGroup() {
        return "Package Structure";
    }

    public IModelElement getAutoDiagramContext(IModelElement main) {
        return main;
    }

    protected void initialUnmasking(IDiagramHandle dh, IModelElement main) {
        if (main instanceof IPackage) {
            this.initialUnmasking(dh, (IModelTree)main);
        }
    }

    private void initialUnmasking(IDiagramHandle dh, IModelTree main) {
        for (IDiagramNode node : dh.getDiagramNode().getNodes()) {
            node.mask();
        }
        for (IModelTree child : main.getOwnedElement()) {
            List nodes;
            if (child instanceof IPackage || (nodes = dh.unmask((IElement)child, 0, 0)) == null || nodes.size() <= 0) continue;
            IDiagramNode node = (IDiagramNode)nodes.get(0);
            node.setRepresentationMode(1);
            this.initStyle(main, child, node);
            this._contentDgs.add(node);
        }
        for (IModelTree child : main.getOwnedElement()) {
            if (child instanceof INameSpace) {
                IDiagramLink link;
                List links;
                List nodes;
                INameSpace parent;
                for (IGeneralization g : ((INameSpace)child).getParent()) {
                    parent = g.getSuperType();
                    nodes = dh.getDiagramGraphics((IElement)parent);
                    if (nodes == null || nodes.isEmpty() || (links = dh.unmask((IElement)g, 0, 0)) == null || links.size() <= 0 || !(link = (IDiagramLink)links.get(0)).getFrom().equals(link.getTo())) continue;
                    link.mask();
                }
                for (IInterfaceRealization ir : ((INameSpace)child).getRealized()) {
                    parent = ir.getImplemented();
                    nodes = dh.getDiagramGraphics((IElement)parent);
                    if (nodes == null || nodes.isEmpty() || (links = dh.unmask((IElement)ir, 0, 0)) == null || links.size() <= 0 || !(link = (IDiagramLink)links.get(0)).getFrom().equals(link.getTo())) continue;
                    link.mask();
                }
            }
            if (!(child instanceof IClassifier)) continue;
            for (IAssociationEnd a : ((IClassifier)child).getPart(IAssociationEnd.class)) {
                IDiagramLink link;
                List links;
                IAssociationEnd other = (IAssociationEnd)a.getOppositeEnds().get(0);
                IClassifier owner = other.getOwner();
                List nodes = dh.getDiagramGraphics((IElement)owner);
                if (nodes == null || nodes.isEmpty() || (links = dh.unmask((IElement)other.getRelated(), 0, 0)) == null || links.size() <= 0 || !(link = (IDiagramLink)links.get(0)).getFrom().equals(link.getTo())) continue;
                link.mask();
            }
        }
    }

    public void initStyle(IModelTree main, IModelTree owner, IDiagramNode node) {
        if (main.equals((Object)node.getElement())) {
            node.setStyle(StyleConstants.getStyleHandle((String)"main"));
        } else if (node.getElement().getElementStatus().isRamcObject()) {
            node.setStyle(StyleConstants.getStyleHandle((String)"ramc"));
        } else {
            node.setStyle(StyleConstants.getStyleHandle((String)"intern"));
        }
    }

    private boolean isInSamePackage(IModelTree elt1, IModelTree elt2) {
        IModelTree parent1 = this.getOwnerPackage(elt1);
        IModelTree parent2 = this.getOwnerPackage(elt2);
        return parent1 != null && parent2 != null && parent1.equals((Object)parent2);
    }

    private IModelTree getOwnerPackage(IModelTree elt) {
        IModelTree parent = elt.getOwner();
        while (parent != null) {
            if (parent instanceof IPackage) {
                return parent;
            }
            parent = parent.getOwner();
        }
        return parent;
    }

    protected void layout(IDiagramHandle dh) {
        DiagonalLayout layout = new DiagonalLayout();
        try {
            layout.layout(dh, this._contentDgs);
        }
        catch (InvalidDestinationPointException | InvalidPointsPathException | InvalidSourcePointException e) {
            e.printStackTrace();
        }
    }
}

