/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.modelingwizard.autodiagram.creator;

import com.modeliosoft.modelio.api.diagram.IDiagramHandle;
import com.modeliosoft.modelio.api.diagram.IDiagramNode;
import com.modeliosoft.modelio.api.diagram.InvalidDestinationPointException;
import com.modeliosoft.modelio.api.diagram.InvalidPointsPathException;
import com.modeliosoft.modelio.api.diagram.InvalidSourcePointException;
import com.modeliosoft.modelio.api.model.IModelingSession;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.statik.IModelTree;
import com.modeliosoft.modelio.api.model.uml.statik.INameSpace;
import com.modeliosoft.modelio.api.model.uml.statik.INamespaceUse;
import com.modeliosoft.modelio.api.model.uml.statik.IPackage;
import com.modeliosoft.modelio.modelingwizard.autodiagram.StyleConstants;
import com.modeliosoft.modelio.modelingwizard.autodiagram.creator.AbstractDiagramCreator;
import com.modeliosoft.modelio.modelingwizard.autodiagram.layout.DiagonalLayout;
import java.util.ArrayList;
import java.util.List;

public class SubPackageStructureCreator
extends AbstractDiagramCreator {
    public List<IDiagramNode> _contentDgs = new ArrayList();

    public SubPackageStructureCreator(IModelingSession session) {
        super(session);
    }

    public String getAutoDiagramName() {
        return "subpackage_structure_autodiagram";
    }

    public String getAutoDiagramGroup() {
        return "SubPackage Structure";
    }

    public IModelElement getAutoDiagramContext(IModelElement main) {
        return main;
    }

    protected void initialUnmasking(IDiagramHandle dh, IModelElement main) {
        if (main instanceof IPackage) {
            this.initialUnmasking(dh, (IModelTree)main);
        }
    }

    private void initialUnmasking(IDiagramHandle dh, IModelTree main) {
        for (IDiagramNode node : dh.getDiagramNode().getNodes()) {
            node.mask();
        }
        for (IModelTree child : main.getOwnedElement(IPackage.class)) {
            List nodes = dh.unmask((IElement)child, 0, 0);
            if (nodes == null || nodes.size() <= 0) continue;
            IDiagramNode node = (IDiagramNode)nodes.get(0);
            node.setRepresentationMode(1);
            this.initStyle(main, child, node);
            this._contentDgs.add(node);
        }
        for (IModelTree child : main.getOwnedElement(IPackage.class)) {
            for (INamespaceUse blueLink : this.getNamespaceUseToElement((INameSpace)((IPackage)child))) {
                dh.unmask((IElement)blueLink, 0, 0);
            }
        }
    }

    private List<INamespaceUse> getNamespaceUseToElement(INameSpace namespaceElt) {
        ArrayList<INamespaceUse> nsus = new ArrayList<INamespaceUse>();
        int k = 0;
        while (k < namespaceElt.carduserNamespaceUse()) {
            INamespaceUse blueLink = (INamespaceUse)namespaceElt.getuserNamespaceUse().get(k);
            if (blueLink.getuser() instanceof IPackage && this.isInSamePackage((IModelTree)namespaceElt, (IModelTree)blueLink.getuser())) {
                nsus.add(blueLink);
            }
            ++k;
        }
        return nsus;
    }

    public void initStyle(IModelTree main, IModelTree owner, IDiagramNode node) {
        if (main.equals((Object)node.getElement())) {
            node.setStyle(StyleConstants.getStyleHandle((String)"main"));
        } else if (node.getElement().getElementStatus().isRamcObject()) {
            node.setStyle(StyleConstants.getStyleHandle((String)"ramc"));
        } else {
            node.setStyle(StyleConstants.getStyleHandle((String)"intern"));
        }
    }

    private boolean isInSamePackage(IModelTree elt1, IModelTree elt2) {
        IModelTree parent1 = this.getOwnerPackage(elt1);
        IModelTree parent2 = this.getOwnerPackage(elt2);
        return parent1 != null && parent2 != null && parent1.equals((Object)parent2);
    }

    private IModelTree getOwnerPackage(IModelTree elt) {
        IModelTree parent = elt.getOwner();
        while (parent != null) {
            if (parent instanceof IPackage) {
                return parent;
            }
            parent = parent.getOwner();
        }
        return parent;
    }

    protected void layout(IDiagramHandle dh) {
        DiagonalLayout layout = new DiagonalLayout();
        try {
            layout.layout(dh, this._contentDgs);
        }
        catch (InvalidDestinationPointException | InvalidPointsPathException | InvalidSourcePointException e) {
            e.printStackTrace();
        }
    }
}

