/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.modelingwizard.autodiagram.layout;

import com.modeliosoft.modelio.api.diagram.IDiagramHandle;
import com.modeliosoft.modelio.api.diagram.IDiagramLink;
import com.modeliosoft.modelio.api.diagram.IDiagramNode;
import com.modeliosoft.modelio.api.diagram.ILinkPath;
import com.modeliosoft.modelio.api.diagram.InvalidDestinationPointException;
import com.modeliosoft.modelio.api.diagram.InvalidPointsPathException;
import com.modeliosoft.modelio.api.diagram.InvalidSourcePointException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;

public class CircleLayout {
    public void layout(IDiagramHandle dh, List<IDiagramNode> contentDgs) throws InvalidSourcePointException, InvalidPointsPathException, InvalidDestinationPointException {
        int maxWidth = 0;
        int maxHeight = 0;
        for (IDiagramNode content : contentDgs) {
            content.fitToContent();
            Rectangle r = content.getBounds();
            maxWidth = Math.max(maxWidth, r.width);
            maxHeight = Math.max(maxHeight, r.height);
        }
        double radius = (double)Math.max(maxHeight, maxWidth) * (1.5 + (double)(contentDgs.size() / 10));
        PrecisionPoint center = new PrecisionPoint((double)maxWidth + radius, (double)maxHeight + radius);
        this.moveElements(contentDgs, center, radius);
        dh.save();
        for (IDiagramNode source : contentDgs) {
            Rectangle sourceR = source.getBounds();
            for (IDiagramLink link : source.getFromLinks()) {
                link.setRouterKind(IDiagramLink.LinkRouterKind.DIRECT);
                IDiagramNode target = (IDiagramNode)link.getTo();
                Rectangle targetR = target.getBounds();
                ILinkPath path = link.getPath();
                ArrayList<Point> points = new ArrayList<Point>();
                if (sourceR.x > targetR.x) {
                    points.add(new Point(sourceR.x + sourceR.width / 2, sourceR.y + sourceR.height / 2));
                    points.add(new Point(targetR.x + targetR.width / 2, targetR.y + targetR.height / 2));
                } else {
                    points.add(new Point(targetR.x + targetR.width / 2, targetR.y + targetR.height / 2));
                    points.add(new Point(sourceR.x + sourceR.width / 2, sourceR.y + sourceR.height / 2));
                }
                path.setPoints(points);
                link.setPath(path);
            }
        }
        dh.save();
    }

    protected void moveElements(List<IDiagramNode> dgs, PrecisionPoint center, double radius) {
        int n = dgs.size();
        double angleDeg = 360 / n;
        double angleRad = Math.PI * angleDeg / 180.0;
        double cos = Math.cos(angleRad);
        double sin = Math.sin(angleRad);
        PrecisionPoint p = new PrecisionPoint(0.0, radius);
        for (IDiagramNode node : dgs) {
            Rectangle r = node.getBounds();
            node.setLocation(center.x + p.x - r.width / 2, center.y + p.y - r.height / 2);
            double newX = p.preciseX * cos + p.preciseY * sin;
            double newY = -p.preciseX * sin + p.preciseY * cos;
            p = new PrecisionPoint(newX, newY);
        }
    }
}

