/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.modelingwizard.autodiagram.layout;

import com.modeliosoft.modelio.api.diagram.IDiagramHandle;
import com.modeliosoft.modelio.api.diagram.IDiagramLink;
import com.modeliosoft.modelio.api.diagram.IDiagramNode;
import com.modeliosoft.modelio.api.diagram.ILinkPath;
import com.modeliosoft.modelio.api.diagram.InvalidDestinationPointException;
import com.modeliosoft.modelio.api.diagram.InvalidPointsPathException;
import com.modeliosoft.modelio.api.diagram.InvalidSourcePointException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public class DiagonalLayout {
    private static final int HSPACING = 30;
    private static final int VSPACING = 30;
    private static final int ANCHORSPACING = 30;
    private int _contentgW;
    private int _contentgH;

    public void layout(IDiagramHandle dh, List<IDiagramNode> contentDgs) throws InvalidSourcePointException, InvalidPointsPathException, InvalidDestinationPointException {
        Collections.sort(contentDgs, new /* Unavailable Anonymous Inner Class!! */);
        for (IDiagramNode content : contentDgs) {
            content.fitToContent();
            int toLinks = content.getToLinks().size();
            int fromLinks = content.getFromLinks().size();
            Rectangle r = content.getBounds();
            content.setSize(Math.max(r.width, (toLinks > 0 ? toLinks - 1 : toLinks) * 30), Math.max(r.height, (fromLinks > 0 ? fromLinks - 1 : fromLinks) * 30));
        }
        Dimension size = this.computeDiagonalSize(contentDgs);
        this._contentgW = size.width;
        this._contentgH = size.height;
        int _contentgX = 30;
        int _contentgY = 30;
        this.moveDiagonalElements(contentDgs, _contentgX, _contentgY);
        dh.save();
        for (IDiagramNode source : contentDgs) {
            Rectangle sourceR = source.getBounds();
            int sourceN = source.getFromLinks().size();
            int sourceH = sourceR.height;
            int sourceYoffset = (sourceH - (sourceN - 1) * 30) / 2;
            for (IDiagramLink link : source.getFromLinks()) {
                IDiagramNode target = (IDiagramNode)link.getTo();
                Rectangle targetR = target.getBounds();
                int targetN = target.getToLinks().size();
                int targetW = targetR.width;
                int targetXoffset = (targetW - (targetN - 1) * 30) / 2 + target.getToLinks().indexOf(link) * 30;
                ILinkPath path = link.getPath();
                ArrayList<Point> points = new ArrayList<Point>();
                if (sourceR.x < targetR.x) {
                    points.add(new Point(sourceR.x + sourceR.width, sourceR.y + sourceYoffset));
                    points.add(new Point(targetR.x + targetXoffset, sourceR.y + sourceYoffset));
                    points.add(new Point(targetR.x + targetXoffset, targetR.y));
                } else {
                    points.add(new Point(sourceR.x, sourceR.y + sourceYoffset));
                    points.add(new Point(targetR.x + targetXoffset, sourceR.y + sourceYoffset));
                    points.add(new Point(targetR.x + targetXoffset, targetR.y + targetR.height));
                }
                path.setPoints(points);
                link.setPath(path);
                sourceYoffset += 30;
            }
        }
    }

    private Dimension computeDiagonalSize(List<IDiagramNode> dgs) {
        int width = 0;
        int height = 0;
        for (IDiagramNode node : dgs) {
            node.fitToContent();
            Rectangle r = node.getBounds();
            width = width + r.height + 30;
            height = height + r.height + 30;
        }
        if (width > 0) {
            width = height - 30;
        }
        if (height > 0) {
            height -= 30;
        }
        return new Dimension(width, height);
    }

    protected void moveDiagonalElements(List<IDiagramNode> dgs, int x0, int y0) {
        int x = x0;
        int y = y0;
        for (IDiagramNode node : dgs) {
            node.setLocation(x, y);
            int w = node.getBounds().width;
            int h = node.getBounds().height;
            x = x + w + 30;
            y = y + h + 30;
        }
    }
}

