/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.modelingwizard.autodiagram.layout;

import com.modeliosoft.modelio.api.diagram.IDiagramHandle;
import com.modeliosoft.modelio.api.diagram.IDiagramLink;
import com.modeliosoft.modelio.api.diagram.IDiagramNode;
import com.modeliosoft.modelio.api.diagram.ILinkPath;
import com.modeliosoft.modelio.api.diagram.InvalidDestinationPointException;
import com.modeliosoft.modelio.api.diagram.InvalidPointsPathException;
import com.modeliosoft.modelio.api.diagram.InvalidSourcePointException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public class FourGroupStructuralLayout {
    private static final int HSPACING = 20;
    private static final int VSPACING = 40;
    private static final int ANCHORSPACING = 50;
    private static final int ASSOCLENGTH = 250;
    private static final int GENLENGTH = 100;
    private static final int REFLECT_SPACING = 20;
    private int _centerX = 0;
    private int _centerY = 0;
    private int _mainX = 0;
    private int _mainY = 0;
    private int _mainW = 0;
    private int _mainH = 0;
    private int _topgW = 0;
    private int _topgH = 0;
    private int _leftgW = 0;
    private int _leftgH = 0;
    private int _rightgW = 0;
    private int _rightgH = 0;
    private int _bottomgW = 0;
    private int _bottomgH = 0;
    private int _reflexivegH = 0;
    private int _reflexivegW = 0;

    private Dimension computeHgroupSize(List<IDiagramNode> dgs) {
        int width = 0;
        int height = 0;
        for (IDiagramNode node : dgs) {
            Rectangle r = node.getBounds();
            width = width + r.width + 20;
            height = Math.max(height, r.height);
        }
        if (width > 0) {
            width -= 20;
        }
        return new Dimension(width, height);
    }

    private Dimension computeVerticalSize(List<IDiagramNode> dgs) {
        int width = 0;
        int height = 0;
        for (IDiagramNode node : dgs) {
            Rectangle r = node.getBounds();
            width = Math.max(width, r.width);
            height = height + r.height + 40;
        }
        if (height > 0) {
            height -= 40;
        }
        return new Dimension(width, height);
    }

    public void layout(IDiagramHandle dh, IDiagramNode mainDG, List<IDiagramNode> topDgs, List<IDiagramNode> bottomDgs, List<IDiagramNode> leftDgs, List<IDiagramNode> rightDgs, List<IDiagramLink> linkDgs) throws InvalidSourcePointException, InvalidPointsPathException, InvalidDestinationPointException {
        int xoffset;
        int w;
        ArrayList<Point> points;
        ILinkPath path;
        int yoffset;
        int h;
        int n;
        Rectangle r;
        Rectangle r2;
        int nlinks;
        Dimension size = this.computeHgroupSize(topDgs);
        this._topgW = size.width;
        this._topgH = size.height;
        size = this.computeHgroupSize(bottomDgs);
        this._bottomgW = size.width;
        this._bottomgH = size.height;
        for (IDiagramNode left : leftDgs) {
            nlinks = left.getFromLinks().size() + left.getToLinks().size();
            r2 = left.getBounds();
            left.setSize(r2.width, r2.height + (nlinks - 1) * 50);
        }
        size = this.computeVerticalSize(leftDgs);
        this._leftgW = size.width;
        this._leftgH = size.height;
        for (IDiagramNode right : rightDgs) {
            nlinks = right.getFromLinks().size() + right.getToLinks().size();
            r2 = right.getBounds();
            right.setSize(r2.width, r2.height + (nlinks - 1) * 50);
        }
        size = this.computeVerticalSize(rightDgs);
        this._rightgW = size.width;
        this._rightgH = size.height;
        this._reflexivegH = 20 * (linkDgs.size() + 1);
        this._reflexivegW = 20 * (linkDgs.size() + 1);
        mainDG.fitToContent();
        Rectangle mainRect = mainDG.getBounds();
        this._mainW = Math.max(180, Math.max(mainRect.width, this._reflexivegW)) + this._reflexivegW;
        this._mainH = Math.max(mainRect.height, Math.max(this._leftgH, this._rightgH)) + this._reflexivegH;
        mainDG.setSize(this._mainW, this._mainH);
        this._centerX = (this._leftgW + 250 + this._mainW + 250 + this._rightgW) / 2;
        this._centerY = 40 + this._topgH + 100 + this._mainH / 2;
        this._mainX = this._centerX - this._mainW / 2;
        this._mainY = this._centerY - this._mainH / 2;
        int _leftgX = 0;
        int _leftgY = this._centerY - this._leftgH / 2 - this._reflexivegH / 2;
        int _rightgX = this._mainX + this._mainW + 250;
        int _rightgY = this._centerY - this._rightgH / 2 - this._reflexivegH / 2;
        int _topgX = this._centerX - this._topgW / 2;
        int _topgY = this._mainY - this._topgH - 100;
        int _bottomgX = this._centerX - this._bottomgW / 2;
        int _bottomgY = this._mainY + this._mainH + 100;
        mainDG.setLocation(this._mainX, this._mainY);
        this.moveHorizontalElements(topDgs, _topgX, _topgY, this._topgH);
        this.moveHorizontalElements(bottomDgs, _bottomgX, _bottomgY, this._bottomgH);
        this.moveVerticalElements(leftDgs, _leftgX, _leftgY, this._leftgW);
        this.moveVerticalElements(rightDgs, _rightgX, _rightgY, this._rightgW);
        for (IDiagramNode left : leftDgs) {
            r = left.getBounds();
            n = left.getFromLinks().size() + left.getToLinks().size();
            h = r.height;
            yoffset = (h - (n - 1) * 50) / 2;
            for (IDiagramLink link : left.getFromLinks()) {
                path = link.getPath();
                points = new ArrayList<Point>();
                points.add(new Point(this._mainX, r.y + yoffset));
                points.add(new Point(r.x + r.width, r.y + yoffset));
                path.setPoints(points);
                link.setPath(path);
                yoffset += 50;
            }
            for (IDiagramLink link : left.getToLinks()) {
                path = link.getPath();
                points = new ArrayList();
                points.add(new Point(r.x + r.width, r.y + yoffset));
                points.add(new Point(this._mainX, r.y + yoffset));
                path.setPoints(points);
                link.setPath(path);
                yoffset += 50;
            }
        }
        for (IDiagramNode right : rightDgs) {
            r = right.getBounds();
            n = right.getFromLinks().size() + right.getToLinks().size();
            h = r.height;
            yoffset = (h - (n - 1) * 50) / 2;
            for (IDiagramLink link : right.getFromLinks()) {
                path = link.getPath();
                points = new ArrayList();
                points.add(new Point(this._mainX + this._mainW, r.y + yoffset));
                points.add(new Point(r.x, r.y + yoffset));
                path.setPoints(points);
                link.setPath(path);
                yoffset += 50;
            }
            for (IDiagramLink link : right.getToLinks()) {
                path = link.getPath();
                points = new ArrayList();
                points.add(new Point(r.x + r.width, r.y + yoffset));
                points.add(new Point(this._mainX, r.y + yoffset));
                path.setPoints(points);
                link.setPath(path);
                yoffset += 50;
            }
        }
        for (IDiagramNode top : topDgs) {
            r = top.getBounds();
            n = top.getFromLinks().size() + top.getToLinks().size();
            w = r.width;
            xoffset = (w - (n - 1) * 50) / 2;
            for (IDiagramLink link : top.getFromLinks()) {
                path = link.getPath();
                points = new ArrayList();
                points.add(new Point(r.x + r.width / 2, r.y + r.height));
                points.add(new Point(r.x + r.width / 2, this._mainY - 50));
                points.add(new Point(this._mainX + this._mainW / 2, this._mainY - 50));
                points.add(new Point(this._mainX + this._mainW / 2, this._mainY));
                path.setPoints(points);
                link.setPath(path);
                xoffset += 50;
            }
            for (IDiagramLink link : top.getToLinks()) {
                path = link.getPath();
                points = new ArrayList();
                points.add(new Point(this._mainX + this._mainW / 2, this._mainY));
                points.add(new Point(this._mainX + this._mainW / 2, this._mainY - 50));
                points.add(new Point(r.x + r.width / 2, this._mainY - 50));
                points.add(new Point(r.x + r.width / 2, r.y + r.height));
                path.setPoints(points);
                link.setPath(path);
                xoffset += 50;
            }
        }
        for (IDiagramNode bottom : bottomDgs) {
            r = bottom.getBounds();
            n = bottom.getFromLinks().size() + bottom.getToLinks().size();
            w = r.width;
            xoffset = (w - (n - 1) * 50) / 2;
            for (IDiagramLink link : bottom.getFromLinks()) {
                path = link.getPath();
                points = new ArrayList();
                points.add(new Point(r.x + r.width / 2, r.y));
                points.add(new Point(r.x + r.width / 2, this._mainY + this._mainH + 50));
                points.add(new Point(this._mainX + this._mainW / 2, this._mainY + this._mainH + 50));
                points.add(new Point(this._mainX + this._mainW / 2, this._mainY + this._mainH));
                path.setPoints(points);
                link.setPath(path);
                xoffset += 50;
            }
            for (IDiagramLink link : bottom.getToLinks()) {
                path = link.getPath();
                points = new ArrayList();
                points.add(new Point(this._mainX + this._mainW / 2, this._mainY));
                points.add(new Point(this._mainX + this._mainW / 2, this._mainY - 50));
                points.add(new Point(r.x + r.width / 2, this._mainY - 50));
                points.add(new Point(r.x + r.width / 2, r.y + r.height));
                path.setPoints(points);
                link.setPath(path);
                xoffset += 50;
            }
        }
        int offset = 20;
        for (IDiagramLink link : linkDgs) {
            ILinkPath path2 = link.getPath();
            ArrayList<Point> points2 = new ArrayList<Point>();
            points2.add(new Point(this._mainX + this._mainW, this._mainY + this._mainH - offset));
            points2.add(new Point(this._mainX + this._mainW + offset, this._mainY + this._mainH - offset));
            points2.add(new Point(this._mainX + this._mainW + offset, this._mainY + this._mainH + offset));
            points2.add(new Point(this._mainX + this._mainW - offset, this._mainY + this._mainH + offset));
            points2.add(new Point(this._mainX + this._mainW - offset, this._mainY + this._mainH));
            path2.setPoints(points2);
            link.setPath(path2);
            offset += 20;
        }
    }

    protected void moveHorizontalElements(List<IDiagramNode> dgs, int x0, int y0, int nodeHeigth) {
        int x = x0;
        int y = y0;
        for (IDiagramNode right : dgs) {
            right.setLocation(x, y);
            int w = right.getBounds().width;
            right.setSize(w, nodeHeigth);
            x = x + w + 20;
        }
    }

    protected void moveVerticalElements(List<IDiagramNode> dgs, int x0, int y0, int nodeWidth) {
        int x = x0;
        int y = y0;
        for (IDiagramNode node : dgs) {
            node.setLocation(x, y);
            int h = node.getBounds().height;
            node.setSize(nodeWidth, h);
            y = y + h + 40;
        }
    }
}

