/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.modelingwizard.handlers;

import com.modeliosoft.modelio.api.model.IModelingSession;
import com.modeliosoft.modelio.api.model.ITransaction;
import com.modeliosoft.modelio.api.model.InvalidTransactionException;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.statik.IClassifier;
import com.modeliosoft.modelio.api.model.uml.statik.INameSpace;
import com.modeliosoft.modelio.api.model.uml.statik.IPackage;
import com.modeliosoft.modelio.api.modelio.Modelio;
import com.modeliosoft.modelio.api.utils.StereotypeNotFoundException;
import com.modeliosoft.modelio.modelingwizard.autodiagram.creator.ClassStructureCreator;
import com.modeliosoft.modelio.modelingwizard.autodiagram.creator.DependencyCreator;
import com.modeliosoft.modelio.modelingwizard.autodiagram.creator.InheritanceCreator;
import com.modeliosoft.modelio.modelingwizard.autodiagram.creator.PackageContentStructureCreator;
import com.modeliosoft.modelio.modelingwizard.autodiagram.creator.SubPackageStructureCreator;
import com.modeliosoft.modelio.modelingwizard.handlers.AbstractAutoDiagramHandler;
import java.util.List;

public class AllDiagrams
extends AbstractAutoDiagramHandler {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute(List<IElement> selectedElements) {
        IModelingSession session = Modelio.getInstance().getModelingSession();
        ITransaction transaction = session.createTransaction("Create All Diagrams");
        try {
            try {
                ClassStructureCreator csc = new ClassStructureCreator(session);
                for (IElement selectedElement : selectedElements) {
                    if (!(selectedElement instanceof IClassifier)) continue;
                    csc.createDiagram((IModelElement)((IClassifier)selectedElement));
                }
                InheritanceCreator ic = new InheritanceCreator(session);
                for (IElement selectedElement : selectedElements) {
                    if (!(selectedElement instanceof IClassifier)) continue;
                    ic.createDiagram((IModelElement)((IClassifier)selectedElement));
                }
                SubPackageStructureCreator pc = new SubPackageStructureCreator(session);
                for (IElement selectedElement : selectedElements) {
                    if (!(selectedElement instanceof IPackage)) continue;
                    pc.createDiagram((IModelElement)selectedElement);
                }
                PackageContentStructureCreator pcsc = new PackageContentStructureCreator(session);
                for (IElement selectedElement : selectedElements) {
                    if (!(selectedElement instanceof IPackage)) continue;
                    pcsc.createDiagram((IModelElement)selectedElement);
                }
                DependencyCreator dc = new DependencyCreator(session);
                for (IElement selectedElement : selectedElements) {
                    if (!(selectedElement instanceof INameSpace)) continue;
                    dc.createDiagram((IModelElement)((INameSpace)selectedElement));
                }
                session.commit(transaction);
                transaction = null;
                return;
            }
            catch (InvalidTransactionException e) {
                transaction = null;
                if (transaction == null) return;
                session.rollback(transaction);
                return;
            }
            catch (StereotypeNotFoundException e) {
                e.printStackTrace();
                if (transaction == null) return;
                session.rollback(transaction);
                return;
            }
        }
        finally {
            if (transaction != null) {
                session.rollback(transaction);
            }
        }
    }

    public boolean isEnabled() {
        return false;
    }
}

