/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.modelingwizard.handlers;

import com.modeliosoft.modelio.api.model.IModelingSession;
import com.modeliosoft.modelio.api.model.ITransaction;
import com.modeliosoft.modelio.api.model.InvalidTransactionException;
import com.modeliosoft.modelio.api.model.diagrams.IAbstractDiagram;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.statik.IClassifier;
import com.modeliosoft.modelio.api.modelio.Modelio;
import com.modeliosoft.modelio.api.utils.StereotypeNotFoundException;
import com.modeliosoft.modelio.core.app.O;
import com.modeliosoft.modelio.modelingwizard.autodiagram.creator.ClassStructureCreator;
import com.modeliosoft.modelio.modelingwizard.handlers.AbstractAutoDiagramHandler;
import java.util.List;

public class ClassStructureDiagram
extends AbstractAutoDiagramHandler {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute(List<IElement> selectedElements) {
        IModelingSession session = Modelio.getInstance().getModelingSession();
        ITransaction transaction = session.createTransaction("Create ClassStructure Diagram");
        try {
            try {
                ClassStructureCreator csc = new ClassStructureCreator(session);
                for (IElement selectedElement : selectedElements) {
                    if (!(selectedElement instanceof IClassifier)) continue;
                    IAbstractDiagram createDiagram = csc.createDiagram((IModelElement)((IClassifier)selectedElement));
                    O.getDefault().getActivationService().fireActivate((IElement)createDiagram);
                }
                session.commit(transaction);
                transaction = null;
                return;
            }
            catch (InvalidTransactionException e) {
                transaction = null;
                if (transaction == null) return;
                session.rollback(transaction);
                return;
            }
            catch (StereotypeNotFoundException e) {
                e.printStackTrace();
                if (transaction == null) return;
                session.rollback(transaction);
                return;
            }
        }
        finally {
            if (transaction != null) {
                session.rollback(transaction);
            }
        }
    }

    public boolean isEnabled() {
        IModelingSession session = Modelio.getInstance().getModelingSession();
        ClassStructureCreator pc = new ClassStructureCreator(session);
        List selection = this.getSelection();
        for (IElement elt : selection) {
            if (elt instanceof IClassifier) {
                if (elt.getElementStatus().isRamcObject()) {
                    return false;
                }
                if (pc.getAutoDiagramContext((IModelElement)((IClassifier)elt)) == null) {
                    return false;
                }
                IAbstractDiagram existingAutoDiagram = pc.getExistingAutoDiagram((IModelElement)((IClassifier)elt));
                if (existingAutoDiagram == null || existingAutoDiagram.getElementStatus().isModifiable()) continue;
                return false;
            }
            return false;
        }
        return !selection.isEmpty();
    }
}

