/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.modelingwizard.handlers;

import com.modeliosoft.modelio.api.model.IModelingSession;
import com.modeliosoft.modelio.api.model.ITransaction;
import com.modeliosoft.modelio.api.model.InvalidTransactionException;
import com.modeliosoft.modelio.api.model.diagrams.IAbstractDiagram;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.statik.INameSpace;
import com.modeliosoft.modelio.api.modelio.Modelio;
import com.modeliosoft.modelio.api.utils.StereotypeNotFoundException;
import com.modeliosoft.modelio.core.app.O;
import com.modeliosoft.modelio.modelingwizard.autodiagram.creator.DependencyCreator;
import com.modeliosoft.modelio.modelingwizard.handlers.AbstractAutoDiagramHandler;
import java.util.List;

public class DependencyDiagram
extends AbstractAutoDiagramHandler {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute(List<IElement> selectedElements) {
        IModelingSession session = Modelio.getInstance().getModelingSession();
        ITransaction transaction = session.createTransaction("Create Dependency Diagram");
        try {
            try {
                DependencyCreator dc = new DependencyCreator(session);
                for (IElement selectedElement : selectedElements) {
                    if (!(selectedElement instanceof INameSpace)) continue;
                    IAbstractDiagram createDiagram = dc.createDiagram((IModelElement)((INameSpace)selectedElement));
                    O.getDefault().getActivationService().fireActivate((IElement)createDiagram);
                }
                session.commit(transaction);
                transaction = null;
                return;
            }
            catch (InvalidTransactionException e) {
                transaction = null;
                if (transaction == null) return;
                session.rollback(transaction);
                return;
            }
            catch (StereotypeNotFoundException e) {
                e.printStackTrace();
                if (transaction == null) return;
                session.rollback(transaction);
                return;
            }
        }
        finally {
            if (transaction != null) {
                session.rollback(transaction);
            }
        }
    }

    public boolean isEnabled() {
        IModelingSession session = Modelio.getInstance().getModelingSession();
        DependencyCreator pc = new DependencyCreator(session);
        List selection = this.getSelection();
        for (IElement elt : selection) {
            if (elt instanceof INameSpace) {
                if (elt.getElementStatus().isRamcObject()) {
                    return false;
                }
                if (pc.getAutoDiagramContext((IModelElement)((INameSpace)elt)) == null) {
                    return false;
                }
                IAbstractDiagram existingAutoDiagram = pc.getExistingAutoDiagram((IModelElement)((INameSpace)elt));
                if (existingAutoDiagram == null || existingAutoDiagram.getElementStatus().isModifiable()) continue;
                return false;
            }
            return false;
        }
        return !selection.isEmpty();
    }
}

