/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.modelingwizard.plugin;

import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.log.PluginLogger;
import com.modeliosoft.modelio.diagram.styles.plugin.DiagramStyles;
import com.modeliosoft.modelio.modelingwizard.plugin.Activator;
import com.modeliosoft.modelio.ui.i18n.BundledMessages;
import java.net.URL;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.osgi.framework.Bundle;

public final class ModelingWizard {
    private IModelingSession modelingSession;
    public static final String PLUGIN_ID = "org.modelio.modelingwizard";
    public static final PluginLogger LOG = new PluginLogger("org.modelio.modelingwizard");
    public static final BundledMessages I18N = new BundledMessages("org.modelio.modelingwizard", ResourceBundle.getBundle("modelingwizard"));
    private static final ModelingWizard INSTANCE = new ModelingWizard();

    public static ModelingWizard getInstance() {
        return INSTANCE;
    }

    public IModelingSession getModelingSession() {
        return this.modelingSession;
    }

    public void sessionClosed(IModelingSession session) {
        this.modelingSession = null;
    }

    public void sessionOpened(IModelingSession session) {
        this.modelingSession = session;
        Bundle bundle = Activator.getDefault().getBundle();
        URL url = FileLocator.find((Bundle)bundle, (IPath)new Path("res/style/extern.style"), null);
        if (url != null) {
            DiagramStyles.getInstance().getStyleManager().createStyle(session.getProjectSpacePath(), "extern", "default", url);
        }
        if ((url = FileLocator.find((Bundle)bundle, (IPath)new Path("res/style/intern.style"), null)) != null) {
            DiagramStyles.getInstance().getStyleManager().createStyle(session.getProjectSpacePath(), "intern", "default", url);
        }
        if ((url = FileLocator.find((Bundle)bundle, (IPath)new Path("res/style/main.style"), null)) != null) {
            DiagramStyles.getInstance().getStyleManager().createStyle(session.getProjectSpacePath(), "main", "default", url);
        }
    }

    private ModelingWizard() {
    }
}

