/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.browser.dnd;

import com.modeliosoft.modelio.api.model.diagrams.IAbstractDiagram;
import com.modeliosoft.modelio.api.model.diagrams.IDiagramSet;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.utils.ObList;
import com.modeliosoft.modelio.api.utils.exceptions.InvalidModelManipulationException;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.jni.ITransaction;
import com.modeliosoft.modelio.core.model.ModelServices;
import com.modeliosoft.modelio.core.transaction.ITransactionManager;
import com.modeliosoft.modelio.core.transaction.InvalidTransactionException;
import com.modeliosoft.modelio.core.transaction.NotCurrentTransactionException;
import com.modeliosoft.modelio.diagram.browser.model.core.DiagramRef;
import com.modeliosoft.modelio.diagram.browser.plugin.DiagramBrowser;
import com.modeliosoft.modelio.diagram.browser.view.BrowserView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonDropAdapter;
import org.eclipse.ui.navigator.CommonDropAdapterAssistant;

public class BrowserDropAssistant
extends CommonDropAdapterAssistant {
    public IStatus handleDrop(CommonDropAdapter dropAdapter, DropTargetEvent event, Object target) {
        IElement targetElement = this.getTargetAdapter(target);
        if (targetElement == null) {
            return Status.CANCEL_STATUS;
        }
        if (!this.checkTransferType(dropAdapter)) {
            return Status.CANCEL_STATUS;
        }
        Object data = event.data;
        if (data == null || target == null) {
            return Status.CANCEL_STATUS;
        }
        List draggedObjects = this.getDraggedObjects();
        if (draggedObjects.isEmpty()) {
            return Status.CANCEL_STATUS;
        }
        IElement destinationParent = null;
        if (targetElement instanceof IDiagramSet) {
            destinationParent = targetElement;
        }
        if (event.detail == 1) {
            return this.processDropCopy(draggedObjects, destinationParent);
        }
        if (event.detail == 2) {
            return this.processDropMove(draggedObjects, destinationParent);
        }
        return null;
    }

    private IStatus processDropMove(List<Object> movedObjects, IElement target) throws NotCurrentTransactionException {
        for (Object obj : movedObjects) {
            if (!(obj instanceof IElement) || !obj.equals(target) && !this.isParentOf((IElement)obj, target)) continue;
            return Status.CANCEL_STATUS;
        }
        IModelingSession modelingSession = DiagramBrowser.getInstance().getModelingSession();
        ITransactionManager transactionManager = modelingSession.getTransactionManager();
        ITransaction transaction = transactionManager.createTransaction("Cut");
        try {
            IDiagramSet targetSet;
            ArrayList<IDiagramSet> movedSets = new ArrayList<IDiagramSet>();
            for (Object obj : movedObjects) {
                if (!(obj instanceof IDiagramSet)) continue;
                movedSets.add((IDiagramSet)obj);
            }
            try {
                ModelServices.moveTo((Collection)new ObList(movedSets), (IElement)target);
            }
            catch (Exception e) {
                transactionManager.rollback(transaction);
                transaction = null;
                DiagramBrowser.LOG.error((Throwable)e);
                MessageDialog.openError(null, (String)"Error", (String)e.getLocalizedMessage());
                if (!(e instanceof InvalidModelManipulationException)) {
                    DiagramBrowser.LOG.error((Throwable)e);
                }
                if (transaction != null) {
                    transactionManager.rollback(transaction);
                }
                return null;
            }
            if (target instanceof IDiagramSet) {
                targetSet = (IDiagramSet)target;
                for (Object obj : movedObjects) {
                    if (!(obj instanceof DiagramRef)) continue;
                    DiagramRef ref = (DiagramRef)obj;
                    targetSet.addReferencedDiagram(ref.getReferencedDiagram());
                    ref.getReferenceOwner().removeReferencedDiagram(ref.getReferencedDiagram());
                }
            }
            if (target instanceof IDiagramSet) {
                targetSet = (IDiagramSet)target;
                for (Object obj : movedObjects) {
                    if (!(obj instanceof IAbstractDiagram)) continue;
                    IAbstractDiagram diagram = (IAbstractDiagram)obj;
                    targetSet.addReferencedDiagram(diagram);
                }
            }
            transactionManager.commit(transaction);
            transaction = null;
            Display.getCurrent().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (InvalidTransactionException e) {
            transaction = null;
            IStatus iStatus = Status.CANCEL_STATUS;
            return iStatus;
        }
        finally {
            if (transaction != null) {
                transactionManager.rollback(transaction);
            }
        }
    }

    private IStatus processDropCopy(List<Object> copiedObjects, IElement target) throws NotCurrentTransactionException {
        for (Object obj : copiedObjects) {
            if (!(obj instanceof IElement) || !obj.equals(target) && !this.isParentOf((IElement)obj, target)) continue;
            return Status.CANCEL_STATUS;
        }
        IModelingSession modelingSession = DiagramBrowser.getInstance().getModelingSession();
        ITransactionManager transactionManager = modelingSession.getTransactionManager();
        ITransaction transaction = transactionManager.createTransaction("Cut");
        try {
            IDiagramSet targetSet;
            ArrayList<IDiagramSet> copiedSets = new ArrayList<IDiagramSet>();
            for (Object obj : copiedObjects) {
                if (!(obj instanceof IDiagramSet)) continue;
                copiedSets.add((IDiagramSet)obj);
            }
            if (!copiedSets.isEmpty()) {
                try {
                    ModelServices.copyTo((Collection)new ObList(copiedSets), (IElement)target);
                }
                catch (Exception e) {
                    transactionManager.rollback(transaction);
                    transaction = null;
                    if (!(e instanceof InvalidModelManipulationException)) {
                        DiagramBrowser.LOG.error((Throwable)e);
                    }
                    MessageDialog.openError(null, (String)"Error", (String)e.getLocalizedMessage());
                    if (transaction != null) {
                        transactionManager.rollback(transaction);
                    }
                    return null;
                }
            }
            if (target instanceof IDiagramSet) {
                targetSet = (IDiagramSet)target;
                for (Object obj : copiedObjects) {
                    if (!(obj instanceof DiagramRef)) continue;
                    DiagramRef ref = (DiagramRef)obj;
                    targetSet.addReferencedDiagram(ref.getReferencedDiagram());
                }
            }
            if (target instanceof IDiagramSet) {
                targetSet = (IDiagramSet)target;
                for (Object obj : copiedObjects) {
                    if (!(obj instanceof IAbstractDiagram)) continue;
                    IAbstractDiagram diagram = (IAbstractDiagram)obj;
                    targetSet.addReferencedDiagram(diagram);
                }
            }
            try {
                transactionManager.commit(transaction);
                transaction = null;
                Display.getCurrent().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            catch (InvalidTransactionException e) {
                IStatus iStatus;
                block19: {
                    transaction = null;
                    iStatus = Status.CANCEL_STATUS;
                    if (transaction == null) break block19;
                    transactionManager.rollback(transaction);
                }
                return iStatus;
            }
        }
        finally {
            if (transaction != null) {
                transactionManager.rollback(transaction);
            }
        }
    }

    private IElement getTargetAdapter(Object target) {
        if (target != null && target instanceof IDiagramSet) {
            return (IElement)target;
        }
        return null;
    }

    public IStatus validateDrop(Object target, int operation, TransferData transferType) {
        IElement targetElement = this.getTargetAdapter(target);
        if (targetElement == null) {
            return Status.CANCEL_STATUS;
        }
        if (!targetElement.getElementStatus().isModifiable()) {
            return Status.CANCEL_STATUS;
        }
        if (!this.checkTransferType(transferType)) {
            return Status.CANCEL_STATUS;
        }
        List selectedElements = this.getDraggedObjects();
        if (selectedElements.isEmpty()) {
            return Status.CANCEL_STATUS;
        }
        if (operation == 2 && target instanceof IDiagramSet) {
            IDiagramSet parent = (IDiagramSet)target;
            for (Object obj : selectedElements) {
                if (!(obj instanceof IElement) || !obj.equals(targetElement) && !this.isParentOf((IElement)obj, (IElement)parent)) continue;
                return Status.CANCEL_STATUS;
            }
        }
        return Status.OK_STATUS;
    }

    private boolean checkTransferType(TransferData transferType) {
        return LocalSelectionTransfer.getTransfer().isSupportedType(transferType);
    }

    private boolean checkTransferType(CommonDropAdapter dropAdapter) {
        return LocalSelectionTransfer.getTransfer().isSupportedType(dropAdapter.getCurrentTransfer());
    }

    private List<Object> getDraggedObjects() {
        ArrayList<Object> selectedObjects = new ArrayList<Object>();
        ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object o : structuredSelection) {
                if (o instanceof IAdaptable) {
                    IAdaptable ma = (IAdaptable)o;
                    if (ma.getAdapter(IAbstractDiagram.class) != null) {
                        selectedObjects.add(ma.getAdapter(IAbstractDiagram.class));
                    }
                    if (ma.getAdapter(IDiagramSet.class) != null) {
                        selectedObjects.add(ma.getAdapter(IDiagramSet.class));
                    }
                    if (ma.getAdapter(IElement.class) == null) continue;
                    selectedObjects.add(ma.getAdapter(IElement.class));
                    continue;
                }
                if (!(o instanceof DiagramRef)) continue;
                selectedObjects.add(o);
            }
        }
        return selectedObjects;
    }

    private boolean isParentOf(IElement parentCandidate, IElement element) {
        IElement parent = element.getCompositionOwner();
        if (parent == null) {
            return false;
        }
        if (parentCandidate.equals((Object)parent)) {
            return true;
        }
        return this.isParentOf(parentCandidate, parent);
    }

    protected BrowserView getBrowserView() {
        BrowserView browserView = (BrowserView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("com.modeliosoft.modelio.diagram.browser.BrowserViewID");
        return browserView;
    }
}

