/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.browser.handlers;

import com.modeliosoft.modelio.api.utils.exceptions.InvalidModelManipulationException;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.jni.ITransaction;
import com.modeliosoft.modelio.core.transaction.ITransactionManager;
import com.modeliosoft.modelio.core.transaction.InvalidTransactionException;
import com.modeliosoft.modelio.diagram.browser.plugin.DiagramBrowser;
import com.modeliosoft.modelio.diagram.browser.view.BrowserView;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractBrwModelHandler
extends AbstractHandler {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IModelingSession session = DiagramBrowser.getInstance().getModelingSession();
        ITransactionManager transactionManager = session.getTransactionManager();
        ITransaction transaction = transactionManager.createTransaction("Diagram browser action");
        try {
            try {
                this.doExecute(event, this.getSelected(), session);
                transactionManager.commit(transaction);
                transaction = null;
                return null;
            }
            catch (InvalidTransactionException exception) {
                transaction = null;
                if (transaction == null) return null;
                transactionManager.rollback(transaction);
                return null;
            }
            catch (InvalidModelManipulationException e) {
                DiagramBrowser.LOG.warning(e.toString());
                String title = DiagramBrowser.I18N.getMessage("AbstractBrwModelHandler.Error.title", new String[0]);
                MessageDialog.openError(null, (String)title, (String)e.getLocalizedMessage());
                if (transaction == null) return null;
                transactionManager.rollback(transaction);
                return null;
            }
        }
        finally {
            if (transaction != null) {
                transactionManager.rollback(transaction);
            }
        }
    }

    protected List<Object> getSelected() {
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (selection instanceof IStructuredSelection) {
            return ((IStructuredSelection)selection).toList();
        }
        return Collections.emptyList();
    }

    protected abstract void doExecute(ExecutionEvent var1, List<Object> var2, IModelingSession var3);

    protected BrowserView getBrowserView() {
        BrowserView browserView = (BrowserView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("com.modeliosoft.modelio.diagram.browser.BrowserViewID");
        return browserView;
    }
}

