/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.browser.model.byset;

import com.modeliosoft.modelio.api.model.diagrams.IAbstractDiagram;
import com.modeliosoft.modelio.api.model.diagrams.IDiagramSet;
import com.modeliosoft.modelio.api.model.extension.IProject;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.diagram.browser.model.byset.BySetContentProvider;
import com.modeliosoft.modelio.diagram.browser.model.core.DiagramRef;
import com.modeliosoft.modelio.diagram.browser.model.core.VirtualFolder;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class BySetContentProvider
implements ITreeContentProvider {
    private VirtualFolder allDiagramsFolder;
    private IModelingSession session;

    public void inputChanged(Viewer v, Object oldInput, Object newInput) {
    }

    public void dispose() {
        this.allDiagramsFolder = null;
        this.session = null;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof IProject) {
            IProject project = (IProject)inputElement;
            if (this.allDiagramsFolder == null) {
                this.allDiagramsFolder = new AllDiagramsNode(this, this.session, null);
            }
            return new Object[]{project.getDiagramRoot(), this.allDiagramsFolder};
        }
        return new Object[0];
    }

    public Object getParent(Object child) {
        if (child instanceof IAbstractDiagram) {
            return this.allDiagramsFolder;
        }
        if (child instanceof DiagramRef) {
            return ((DiagramRef)child).getReferenceOwner();
        }
        return null;
    }

    public Object[] getChildren(Object parent) {
        if (parent instanceof IDiagramSet) {
            IDiagramSet theDiagramSet = (IDiagramSet)parent;
            ArrayList<DiagramRef> objects = new ArrayList<DiagramRef>();
            objects.addAll((Collection<DiagramRef>)theDiagramSet.getSub());
            for (IAbstractDiagram diagram : theDiagramSet.getReferencedDiagram()) {
                objects.add(new DiagramRef(diagram, theDiagramSet));
            }
            return objects.toArray();
        }
        if (parent instanceof AllDiagramsNode) {
            return ((VirtualFolder)parent).getChildren(parent);
        }
        return new Object[0];
    }

    public boolean hasChildren(Object parent) {
        if (parent instanceof DiagramRef) {
            return false;
        }
        if (parent instanceof IDiagramSet) {
            IDiagramSet theDiagramSet = (IDiagramSet)parent;
            return theDiagramSet.cardSub() + theDiagramSet.cardReferencedDiagram() > 0;
        }
        if (parent instanceof AllDiagramsNode) {
            return ((VirtualFolder)parent).hasChildren(parent);
        }
        return false;
    }

    public BySetContentProvider(IModelingSession session) {
        this.session = session;
    }
}

