/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.browser.model.bytype;

import com.modeliosoft.modelio.api.model.diagrams.IAbstractDiagram;
import com.modeliosoft.modelio.api.model.extension.IProject;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.jni.INativeModelingSession;
import com.modeliosoft.modelio.diagram.browser.model.bytype.ByTypeContentProvider;
import com.modeliosoft.modelio.diagram.browser.model.core.VirtualFolder;
import com.modeliosoft.modelio.diagram.browser.plugin.DiagramBrowser;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ByTypeContentProvider
implements ITreeContentProvider {
    Map<String, VirtualFolder> types = new HashMap();
    private IModelingSession session;

    public void inputChanged(Viewer v, Object oldInput, Object newInput) {
    }

    public void dispose() {
        this.session = null;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof IProject) {
            this.updateTypes();
            return this.types.values().toArray(new Object[0]);
        }
        return new Object[0];
    }

    public Object getParent(Object child) {
        if (child instanceof IAbstractDiagram) {
            String type = this.getType((IAbstractDiagram)child);
            return this.types.get(type);
        }
        return null;
    }

    public Object[] getChildren(Object parent) {
        if (parent instanceof VirtualFolder) {
            return ((VirtualFolder)parent).getChildren(parent);
        }
        return new Object[0];
    }

    public boolean hasChildren(Object parent) {
        if (parent instanceof VirtualFolder) {
            return ((VirtualFolder)parent).hasChildren(parent);
        }
        return false;
    }

    public ByTypeContentProvider(IModelingSession session) {
        this.session = session;
    }

    private void updateTypes() {
        INativeModelingSession nativeSession = this.session.getNativeSession();
        if (nativeSession == null) {
            return;
        }
        for (IElement e : nativeSession.findByClass(IAbstractDiagram.class)) {
            IAbstractDiagram diagram = (IAbstractDiagram)e;
            String type = this.getType(diagram);
            if (this.types.containsKey(type)) continue;
            String filteringType = type;
            1 newFolder = new /* Unavailable Anonymous Inner Class!! */;
            newFolder.setName(this.getI18nType(diagram));
            this.types.put(type, newFolder);
        }
    }

    protected String getType(IAbstractDiagram diagram) {
        if (diagram.cardExtension() > 0) {
            IStereotype s = (IStereotype)diagram.getExtension().get(0);
            if (s.getLabel().isEmpty()) {
                return s.getName();
            }
            return s.getLabel();
        }
        return diagram.getMetaclassName();
    }

    private String getI18nType(IAbstractDiagram diagram) {
        if (diagram.cardExtension() > 0) {
            IStereotype s = (IStereotype)diagram.getExtension().get(0);
            if (s.getLabel().isEmpty()) {
                return s.getName();
            }
            return s.getLabel();
        }
        return DiagramBrowser.I18N.getString(String.valueOf(diagram.getMetaclassName()) + ".label");
    }

    static /* synthetic */ IModelingSession access$0(ByTypeContentProvider byTypeContentProvider) {
        return byTypeContentProvider.session;
    }
}

