/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.browser.model.core;

import com.modeliosoft.modelio.api.model.diagrams.IAbstractDiagram;
import com.modeliosoft.modelio.api.model.diagrams.IDiagramSet;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.jni.ITransaction;
import com.modeliosoft.modelio.core.transaction.ITransactionManager;
import com.modeliosoft.modelio.core.transaction.InvalidTransactionException;
import com.modeliosoft.modelio.diagram.browser.model.core.DiagramRef;
import com.modeliosoft.modelio.diagram.browser.plugin.DiagramBrowser;
import com.modeliosoft.modelio.diagram.browser.view.BrowserView;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TreeItem;

public class DefaultLabelEditor
implements ICellModifier {
    private BrowserView view;

    public DefaultLabelEditor(BrowserView view) {
        this.view = view;
    }

    public boolean canModify(Object object, String property) {
        TreeItem[] selection = this.view.getCommonViewer().getTree().getSelection();
        return selection.length == 1 && this.isEditable(object);
    }

    public Object getValue(Object object, String property) {
        if (object instanceof IDiagramSet) {
            return ((IDiagramSet)object).getName();
        }
        if (object instanceof DiagramRef) {
            return ((DiagramRef)object).referencedDiagram.getName();
        }
        if (object instanceof IAbstractDiagram) {
            return ((IAbstractDiagram)object).getName();
        }
        DiagramBrowser.LOG.error("DefaultLabelEditor: unknown type '%s'", new Object[]{object.getClass().getName()});
        return null;
    }

    public void modify(Object object, String property, Object value) {
        IModelingSession modelingSession;
        Object data = object instanceof TreeItem ? ((Item)object).getData() : object;
        Object currentValue = this.getValue(data, property);
        if (!value.equals(currentValue) && (modelingSession = this.getModelingSession()) != null) {
            ITransactionManager transactionManager = modelingSession.getTransactionManager();
            ITransaction transaction = null;
            try {
                try {
                    transaction = transactionManager.createTransaction("Rename");
                    if (data instanceof IDiagramSet) {
                        ((IDiagramSet)data).setName((String)value);
                    }
                    if (data instanceof DiagramRef) {
                        ((DiagramRef)data).referencedDiagram.setName((String)value);
                    }
                    if (data instanceof IAbstractDiagram) {
                        ((IAbstractDiagram)data).setName((String)value);
                    }
                    transactionManager.commit(transaction);
                    transaction = null;
                }
                catch (InvalidTransactionException e) {
                    transaction = null;
                    if (transaction != null) {
                        transactionManager.rollback(transaction);
                    }
                }
            }
            finally {
                if (transaction != null) {
                    transactionManager.rollback(transaction);
                }
            }
        }
    }

    private IModelingSession getModelingSession() {
        return DiagramBrowser.getInstance().getModelingSession();
    }

    private boolean isEditable(Object object) {
        return object instanceof IDiagramSet || object instanceof DiagramRef || object instanceof IAbstractDiagram;
    }
}

