/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.browser.model.core;

import com.modeliosoft.modelio.api.model.diagrams.IAbstractDiagram;
import com.modeliosoft.modelio.api.model.diagrams.IDiagramSet;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElementStatus;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import com.modeliosoft.modelio.core.app.StandardImageService;
import com.modeliosoft.modelio.core.app.StatusImageDecorator;
import com.modeliosoft.modelio.diagram.browser.model.core.DefaultLabelProvider;
import com.modeliosoft.modelio.diagram.browser.model.core.DiagramRef;
import com.modeliosoft.modelio.diagram.browser.model.core.VirtualFolder;
import com.modeliosoft.modelio.diagram.browser.view.BrowserView;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;

/*
 * Exception performing whole class analysis ignored.
 */
public class DefaultLabelProvider
extends StyledCellLabelProvider {
    private BrowserView browserView;
    private Map<String, Image> images = new HashMap();
    private ImageDescriptor linkOverlayImageDescriptor;
    private static final Color GRAY = Display.getCurrent().getSystemColor(15);
    private static final Color DARK_GRAY = Display.getCurrent().getSystemColor(16);

    public DefaultLabelProvider(BrowserView browserView) {
        this();
        this.browserView = browserView;
    }

    public void dispose() {
        super.dispose();
        for (Image image : this.images.values()) {
            image.dispose();
        }
        this.images.clear();
        this.browserView = null;
    }

    private DefaultLabelProvider() {
        Bundle imageBundle = Platform.getBundle((String)"org.modelio.diagram.browser");
        URL bitmapUrl = FileLocator.find((Bundle)imageBundle, (IPath)new Path("icons/opened_folder_16.png"), null);
        this.images.put("OPENEDFOLDER", ImageDescriptor.createFromURL((URL)bitmapUrl).createImage());
        bitmapUrl = FileLocator.find((Bundle)imageBundle, (IPath)new Path("icons/closed_folder_16.png"), null);
        this.images.put("CLOSEDFOLDER", ImageDescriptor.createFromURL((URL)bitmapUrl).createImage());
        bitmapUrl = FileLocator.find((Bundle)imageBundle, (IPath)new Path("icons/refoverlay.png"), null);
        this.linkOverlayImageDescriptor = ImageDescriptor.createFromURL((URL)bitmapUrl);
    }

    public void update(ViewerCell cell) {
        Object obj = cell.getElement();
        if (obj instanceof VirtualFolder) {
            this.updateFolderLabel(cell, (VirtualFolder)obj);
            this.updateFolderImage(cell, (VirtualFolder)obj);
            return;
        }
        if (obj instanceof DiagramRef) {
            this.updateDiagramRefLabel(cell, (DiagramRef)obj);
            this.updateDiagramRefImage(cell, (DiagramRef)obj);
            return;
        }
        if (obj instanceof IDiagramSet) {
            this.updateDiagramSetLabel(cell, (IDiagramSet)obj);
            this.updateDiagramSetImage(cell, (IDiagramSet)obj);
            return;
        }
        if (obj instanceof IElement) {
            this.updateElementLabel(cell, (IElement)obj);
            this.updateElementImage(cell, (IElement)obj);
            return;
        }
        super.update(cell);
    }

    private void updateDiagramSetLabel(ViewerCell cell, IDiagramSet diagramSet) {
        if (diagramSet.getElementStatus().isRamcObject()) {
            cell.setForeground(GRAY);
        } else {
            cell.setForeground(null);
        }
        cell.setText(LabelTextProvider.getLabelText((IElement)diagramSet));
    }

    private void updateDiagramSetImage(ViewerCell cell, IDiagramSet diagramSet) {
        cell.setImage(this.getCmsDiagramSetImage(diagramSet));
    }

    private void updateFolderLabel(ViewerCell cell, VirtualFolder folder) {
        cell.setForeground(DARK_GRAY);
        if (folder.getRepresentedElement() == null) {
            cell.setText(folder.getName());
        } else {
            cell.setText(LabelTextProvider.getLabelText((IElement)folder.getRepresentedElement()));
        }
    }

    private void updateFolderImage(ViewerCell cell, VirtualFolder folder) {
        IElement element = folder.getRepresentedElement();
        if (element == null) {
            if (this.browserView.getCommonViewer().getExpandedState((Object)folder)) {
                cell.setImage((Image)this.images.get("OPENEDFOLDER"));
            } else {
                cell.setImage((Image)this.images.get("CLOSEDFOLDER"));
            }
        } else {
            cell.setImage(StandardImageService.getCmsStereotypedImage((IElement)element, null));
        }
    }

    private void updateDiagramRefImage(ViewerCell cell, DiagramRef diagramRef) {
        Image standardImage;
        IAbstractDiagram diagram = diagramRef.getReferencedDiagram();
        String key = this.getKey(diagram);
        if (!this.images.containsKey(key) && (standardImage = StandardImageService.getCmsStereotypedImage((IElement)diagram, null)) != null) {
            this.images.put(key, new DecorationOverlayIcon(standardImage, this.linkOverlayImageDescriptor, 3).createImage());
        }
        cell.setImage((Image)this.images.get(key));
    }

    private void updateDiagramRefLabel(ViewerCell cell, DiagramRef diagramRef) {
        cell.setText(LabelTextProvider.getLabelText((IElement)diagramRef.getReferencedDiagram()));
    }

    private Image getCmsDiagramSetImage(IDiagramSet element) {
        IElementStatus elementStatus = element.getElementStatus();
        String key = this.browserView.getCommonViewer().getExpandedState((Object)element) ? "Opened." : "Closed.";
        key = elementStatus.isCmsManaged() && elementStatus.isCmsLocked() ? String.valueOf(key) + "DiagramSet.CI" : (elementStatus.isCmsManaged() && !elementStatus.isCmsLocked() && !elementStatus.isRamcObject() ? String.valueOf(key) + "DiagramSet.CO" : (elementStatus.isCmsAdded() && !elementStatus.isRamcObject() ? String.valueOf(key) + "DiagramSet.ADD" : String.valueOf(key) + "DiagramSet.NV"));
        Image image = StandardImageService.getImage((String)key);
        if (image == null) {
            ImageDescriptor baseImage;
            Bundle imageBundle;
            if (this.browserView.getCommonViewer().getExpandedState((Object)element)) {
                imageBundle = Platform.getBundle((String)"org.modelio.diagram.browser");
                URL bitmapUrl = FileLocator.find((Bundle)imageBundle, (IPath)new Path("icons/opened_set_16.png"), null);
                baseImage = ImageDescriptor.createFromURL((URL)bitmapUrl);
            } else {
                imageBundle = Platform.getBundle((String)"org.modelio.diagram.browser");
                URL bitmapUrl = FileLocator.find((Bundle)imageBundle, (IPath)new Path("icons/closed_set_16.png"), null);
                baseImage = ImageDescriptor.createFromURL((URL)bitmapUrl);
            }
            ImageDescriptor imgDesc = StatusImageDecorator.buildDecoratedImage((ImageDescriptor)baseImage, (IElementStatus)element.getElementStatus());
            StandardImageService.declareImage((String)key, (ImageDescriptor)imgDesc);
            image = StandardImageService.getImage((String)key);
        }
        return image;
    }

    private String getKey(IAbstractDiagram diagram) {
        StringBuilder s = new StringBuilder(30);
        s.append(diagram.getMetaclassName());
        IStereotype stereo = StandardImageService.getIconBrowserProvidingStereotype((IModelElement)diagram, null);
        if (stereo != null) {
            s.append(".");
            s.append(stereo.getName());
        }
        s.append(".link");
        IElementStatus stat = diagram.getElementStatus();
        if (stat.isCmsManaged()) {
            s.append(stat.isCmsLocked() ? (char)'l' : '_');
            s.append(stat.isCmsModified() ? (char)'m' : '_');
        } else {
            s.append(stat.isCmsAdded() ? (char)'a' : '_');
        }
        s.append(stat.isRamcObject() ? (char)'r' : '_');
        return s.toString();
    }

    private void updateElementImage(ViewerCell cell, IElement element) {
        cell.setImage(StandardImageService.getCmsStereotypedImage((IElement)element, null));
    }

    private void updateElementLabel(ViewerCell cell, IElement element) {
        if (element.getElementStatus().isRamcObject()) {
            cell.setForeground(GRAY);
        } else {
            cell.setForeground(null);
        }
        cell.setText(LabelTextProvider.getLabelText((IElement)element));
    }
}

