/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.browser.plugin;

import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.log.PluginLogger;
import com.modeliosoft.modelio.diagram.browser.view.BrowserView;
import com.modeliosoft.modelio.ui.i18n.BundledMessages;
import java.util.ResourceBundle;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class DiagramBrowser {
    public static final String PLUGIN_ID = "org.modelio.diagram.browser";
    public static final PluginLogger LOG = new PluginLogger("org.modelio.diagram.browser");
    public static final BundledMessages I18N = new BundledMessages("org.modelio.diagram.browser", ResourceBundle.getBundle("diagram-browser"));
    private static DiagramBrowser _instance;
    private IModelingSession modelingSession = null;

    private DiagramBrowser() {
    }

    public static DiagramBrowser getInstance() {
        if (_instance == null) {
            _instance = new DiagramBrowser();
        }
        return _instance;
    }

    public void sessionClosed() {
        BrowserView view = this.getView();
        if (view != null) {
            view.sessionClosed(this.modelingSession);
        }
        this.modelingSession = null;
    }

    public void sessionOpened(IModelingSession session) {
        this.modelingSession = session;
        BrowserView view = this.getView();
        if (view != null) {
            view.sessionOpened(session);
        }
    }

    public IModelingSession getModelingSession() {
        return this.modelingSession;
    }

    private BrowserView getView() {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        BrowserView view = (BrowserView)page.findViewReference("com.modeliosoft.modelio.diagram.browser.BrowserViewID").getView(false);
        return view;
    }
}

