/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.browser.view;

import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class BrowserActivationStrategy
extends ColumnViewerEditorActivationStrategy
implements MouseListener {
    private int time = 0;
    private Object selectedObject = null;
    private ColumnViewer viewer;

    public BrowserActivationStrategy(ColumnViewer viewer) {
        super(viewer);
        this.viewer = viewer;
        viewer.getControl().addMouseListener((MouseListener)this);
    }

    protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
        if (event.eventType == 1 && event.keyCode == 0x100000B) {
            return true;
        }
        return event.eventType == 4;
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
        Object sourceObject = null;
        Object eventSource = e.getSource();
        if (eventSource instanceof Tree) {
            Tree tree = (Tree)eventSource;
            TreeItem clickedItem = tree.getItem(new Point(e.x, e.y));
            TreeItem[] items = tree.getSelection();
            if (items.length == 1 && clickedItem != null) {
                sourceObject = items[0].getData();
            }
        }
        if (sourceObject == null) {
            return;
        }
        boolean leftButtonClicked = false;
        if (e.button == 1) {
            leftButtonClicked = true;
        }
        if (this.time == 0 && leftButtonClicked) {
            this.time = e.time;
            this.selectedObject = sourceObject;
            return;
        }
        if (leftButtonClicked) {
            int delta = e.time - this.time;
            if (delta > 300 && delta < 1000 && this.selectedObject == sourceObject) {
                this.time = 0;
                this.selectedObject = sourceObject;
                this.viewer.editElement(sourceObject, 0);
                return;
            }
            this.time = e.time;
            this.selectedObject = sourceObject;
            return;
        }
    }
}

