/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.browser.view;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.core.app.O;
import com.modeliosoft.modelio.core.app.events.IPickingProvider;
import com.modeliosoft.modelio.diagram.browser.view.BrowserView;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.osgi.framework.Bundle;

public class BrowserPickingManager
implements IPickingProvider,
MouseListener,
MouseTrackListener,
MouseMoveListener {
    private IElement rootPickingElement = null;
    private BrowserView view;
    private Cursor pickingCursor;
    private Cursor defaultCursor;
    private Cursor noCursor;
    private Cursor yesCursor;

    public BrowserPickingManager(BrowserView view) {
        this.view = view;
        this.pickingCursor = this.createCursor("icons/picking_cursor.png");
        this.noCursor = this.createCursor("icons/picking_cursor_no.png");
        this.yesCursor = this.createCursor("icons/picking_cursor_yes.png");
        this.defaultCursor = view.getCommonViewer().getTree().getCursor();
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
    }

    private IElement getPickedElement(MouseEvent e) {
        Object data;
        Tree tree;
        TreeItem item;
        Object source = e.getSource();
        if (source instanceof Tree && (item = (tree = (Tree)source).getItem(new Point(e.x, e.y))) != null && (data = item.getData()) instanceof IElement) {
            IElement element = (IElement)data;
            return element;
        }
        return null;
    }

    public void mouseUp(MouseEvent e) {
        IElement pickedElement;
        if (e.button == 1 && (pickedElement = this.getPickedElement(e)) != null && O.getDefault().getPickingProviderService().acceptElement(pickedElement)) {
            O.getDefault().getPickingProviderService().setElement(pickedElement);
        }
    }

    public void mouseEnter(MouseEvent e) {
        this.view.getCommonViewer().getTree().setCursor(this.pickingCursor);
    }

    public void mouseExit(MouseEvent e) {
        this.view.getCommonViewer().getTree().setCursor(this.defaultCursor);
    }

    public void mouseHover(MouseEvent e) {
    }

    public void dispose() {
        if (this.pickingCursor != null) {
            this.pickingCursor.dispose();
        }
        if (this.noCursor != null) {
            this.noCursor.dispose();
        }
        if (this.yesCursor != null) {
            this.yesCursor.dispose();
        }
    }

    public void beginPicking() {
        if (!this.view.getCommonViewer().getTree().isDisposed()) {
            List selection = this.getRootSelection();
            if (selection.size() == 1) {
                this.rootPickingElement = (IElement)selection.get(0);
            }
            this.view.getCommonViewer().getTree().addMouseListener((MouseListener)this);
            this.view.getCommonViewer().getTree().addMouseTrackListener((MouseTrackListener)this);
            this.view.getCommonViewer().getTree().addMouseMoveListener((MouseMoveListener)this);
        }
    }

    public void endPicking() {
        if (!this.view.getCommonViewer().getTree().isDisposed()) {
            this.view.getCommonViewer().getTree().removeMouseListener((MouseListener)this);
            this.view.getCommonViewer().getTree().removeMouseTrackListener((MouseTrackListener)this);
            this.view.getCommonViewer().getTree().removeMouseMoveListener((MouseMoveListener)this);
            this.view.getCommonViewer().getTree().setCursor(this.defaultCursor);
            if (this.rootPickingElement != null) {
                this.view.selectElement(this.rootPickingElement);
            }
        }
    }

    public void mouseMove(MouseEvent e) {
        Object data;
        Tree tree;
        TreeItem item;
        IElement element = null;
        Object source = e.getSource();
        if (source instanceof Tree && (item = (tree = (Tree)source).getItem(new Point(e.x, e.y))) != null && (data = item.getData()) instanceof IElement) {
            element = (IElement)data;
        }
        if (element != null) {
            if (O.getDefault().getPickingProviderService().acceptElement(element)) {
                this.view.getCommonViewer().getTree().setCursor(this.yesCursor);
            } else {
                this.view.getCommonViewer().getTree().setCursor(this.noCursor);
            }
        } else {
            this.view.getCommonViewer().getTree().setCursor(this.pickingCursor);
        }
    }

    private List<IElement> getRootSelection() {
        ArrayList<IElement> selectionList = new ArrayList<IElement>();
        ISelection selection = this.view.getCommonViewer().getSelection();
        if (selection instanceof IStructuredSelection) {
            List selectedElements = ((IStructuredSelection)selection).toList();
            for (Object object : selectedElements) {
                if (!(object instanceof IAdaptable)) continue;
                IAdaptable adapter = (IAdaptable)object;
                IElement element = (IElement)adapter.getAdapter(IElement.class);
                selectionList.add(element);
            }
        }
        return selectionList;
    }

    private Cursor createCursor(String cursorFilename) {
        Bundle imageBundle = Platform.getBundle((String)"org.modelio.diagram.browser");
        URL bitmapUrl = FileLocator.find((Bundle)imageBundle, (IPath)new Path(cursorFilename), null);
        ImageData bitmapData = ImageDescriptor.createFromURL((URL)bitmapUrl).getImageData();
        return new Cursor((Device)Display.getCurrent(), bitmapData, 10, 9);
    }
}

