/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.browser.view;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.app.O;
import com.modeliosoft.modelio.core.app.events.INavigationListener;
import com.modeliosoft.modelio.core.app.events.INavigationService;
import com.modeliosoft.modelio.core.app.events.IPickingProvider;
import com.modeliosoft.modelio.core.app.events.IPickingProviderService;
import com.modeliosoft.modelio.core.model.change.IModelChangeListener;
import com.modeliosoft.modelio.core.model.change.IStatusChangeListener;
import com.modeliosoft.modelio.diagram.browser.model.IBrowserModel;
import com.modeliosoft.modelio.diagram.browser.model.bycontext.ByCtxModel;
import com.modeliosoft.modelio.diagram.browser.model.byset.BySetModel;
import com.modeliosoft.modelio.diagram.browser.model.bytype.ByTypeModel;
import com.modeliosoft.modelio.diagram.browser.model.flat.FlatModel;
import com.modeliosoft.modelio.diagram.browser.plugin.DiagramBrowser;
import com.modeliosoft.modelio.diagram.browser.view.BrowserActivateSender;
import com.modeliosoft.modelio.diagram.browser.view.BrowserActivationStrategy;
import com.modeliosoft.modelio.diagram.browser.view.BrowserModelChangeListener;
import com.modeliosoft.modelio.diagram.browser.view.BrowserPickingManager;
import com.modeliosoft.modelio.diagram.browser.view.BrowserView;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.State;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerEditor;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;

public class BrowserView
extends CommonNavigator
implements INavigationListener {
    public static final String VIEW_ID = "com.modeliosoft.modelio.diagram.browser.BrowserViewID";
    public static final String CONTENT_NAVIGATOR_ID = "com.modeliosoft.modelio.diagram.browser.BrowserContentID";
    private IBrowserModel model;
    private IModelingSession modelingSession;
    private ITreeViewerListener expandlistener;
    BrowserModelChangeListener modelChangeListener;
    private BrowserActivateSender activateSender;
    private BrowserActivationStrategy actSupport = null;
    private BrowserPickingManager pickingManager;

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.configureBrowser((IBrowserModel)new BySetModel());
        this.initEditor();
        IContextService contextService = (IContextService)this.getViewSite().getService(IContextService.class);
        contextService.activateContext("com.modeliosoft.modelio.diagram.browser.ContextID");
        this.getViewSite().getActionBars().getMenuManager().removeAll();
        this.getViewSite().getActionBars().getMenuManager().update();
        this.setTitleToolTip("");
        this.expandlistener = new ExpandCollapseListener(this);
        this.getCommonViewer().addTreeListener(this.expandlistener);
        this.getCommonViewer().getTree().addMouseListener((MouseListener)this.actSupport);
        if (DiagramBrowser.getInstance().getModelingSession() != null) {
            this.sessionOpened(DiagramBrowser.getInstance().getModelingSession());
        }
    }

    public void dispose() {
        if (this.modelingSession != null) {
            this.disconnectFromSession(this.modelingSession);
        }
        super.dispose();
    }

    public IBrowserModel getBrowserModel() {
        return this.model;
    }

    public IModelingSession getModelingSession() {
        return this.modelingSession;
    }

    public void navigateTo(IElement target) {
        this.selectElement(target);
    }

    public void selectElement(IElement element) {
        CommonViewer viewer = this.getCommonViewer();
        viewer.setSelection((ISelection)new StructuredSelection((Object)element), true);
    }

    public void sessionClosed(IModelingSession session) {
        this.disconnectFromSession(session);
        this.modelingSession = null;
    }

    public void sessionOpened(IModelingSession session) {
        this.modelingSession = session;
        this.connectToSession(session);
    }

    public void switchBrowserModel(IBrowserModel newModel) {
        this.configureBrowser(newModel);
        this.getCommonViewer().refresh();
        this.getCommonViewer().expandToLevel(2);
    }

    protected CommonViewer createCommonViewerObject(Composite aParent) {
        return new ModifiedCommonViewer(this, this.getViewSite().getId(), aParent, 770);
    }

    protected String getContentProviderId() {
        return CONTENT_NAVIGATOR_ID;
    }

    protected IAdaptable getInitialInput() {
        return null;
    }

    private void configureBrowser(IBrowserModel newModel) {
        this.model = newModel;
        this.getCommonViewer().setContentProvider((IContentProvider)this.model.getContentProvider(this.modelingSession));
        this.getCommonViewer().setLabelProvider(this.model.getLabelProvider(this));
        this.getCommonViewer().setSorter(this.model.getSorter());
        this.getCommonViewer().setCellModifier(this.model.getLabelEditor(this));
    }

    private void connectToSession(IModelingSession session) {
        assert (session != null);
        this.getCommonViewer().setInput((Object)session.getModel().getProject());
        this.modelChangeListener = new BrowserModelChangeListener(this);
        this.modelingSession.getModel().addModelListener((IModelChangeListener)this.modelChangeListener);
        this.modelingSession.getModel().addStatusListener((IStatusChangeListener)this.modelChangeListener);
        INavigationService navigationService = O.getDefault().getNavigateService();
        navigationService.addNavigationListener((INavigationListener)this);
        this.activateSender = new BrowserActivateSender();
        this.getCommonViewer().getTree().addMouseListener((MouseListener)this.activateSender);
        this.pickingManager = new BrowserPickingManager(this);
        IPickingProviderService pickingService = O.getDefault().getPickingProviderService();
        pickingService.addPickingProvider((IPickingProvider)this.pickingManager);
        IWorkbenchPartSite locator = this.getSite();
        String commandId = "com.modeliosoft.modelio.diagram.browser.SwitchBrowserTypeCommandID";
        ICommandService commandService = (ICommandService)locator.getService(ICommandService.class);
        Command command = commandService.getCommand("com.modeliosoft.modelio.diagram.browser.SwitchBrowserTypeCommandID");
        State state = command.getState("org.eclipse.ui.commands.radioState");
        if (state != null) {
            Object stateValue = state.getValue();
            if ("flat".equals(stateValue)) {
                this.switchBrowserModel((IBrowserModel)new FlatModel());
            } else if ("byType".equals(stateValue)) {
                this.switchBrowserModel((IBrowserModel)new ByTypeModel());
            } else if ("user".equals(stateValue)) {
                this.switchBrowserModel((IBrowserModel)new BySetModel());
            } else if ("context".equals(stateValue)) {
                this.switchBrowserModel((IBrowserModel)new ByCtxModel());
            } else assert (false);
        } else {
            try {
                HandlerUtil.updateRadioState((Command)command, (String)"user");
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
            this.configureBrowser((IBrowserModel)new BySetModel());
        }
    }

    private void disconnectFromSession(IModelingSession session) {
        assert (session != null);
        IPickingProviderService pickingService = O.getDefault().getPickingProviderService();
        pickingService.removePickingProvider((IPickingProvider)this.pickingManager);
        this.pickingManager = null;
        if (this.activateSender != null && !this.getCommonViewer().getTree().isDisposed()) {
            this.getCommonViewer().getTree().removeMouseListener((MouseListener)this.activateSender);
            this.activateSender = null;
        }
        INavigationService navigationService = O.getDefault().getNavigateService();
        navigationService.removeNavigationListener((INavigationListener)this);
        if (session.isOpen()) {
            session.getModel().removeModelListener((IModelChangeListener)this.modelChangeListener);
            session.getModel().removeStatusListener((IStatusChangeListener)this.modelChangeListener);
        }
        this.modelChangeListener = null;
        if (!this.getCommonViewer().getTree().isDisposed()) {
            this.getCommonViewer().setSelection(null);
            this.getCommonViewer().setInput(null);
        }
    }

    private void initEditor() {
        TextCellEditor[] cellEditors = new TextCellEditor[1];
        TextCellEditor editor = new TextCellEditor((Composite)this.getCommonViewer().getTree(), 0);
        editor.getControl().addKeyListener((KeyListener)new /* Unavailable Anonymous Inner Class!! */);
        cellEditors[0] = editor;
        this.getCommonViewer().setCellEditors((CellEditor[])cellEditors);
        String[] properties = new String[]{"name"};
        this.getCommonViewer().setColumnProperties(properties);
        this.getCommonViewer().setCellModifier(this.model.getLabelEditor(this));
        this.actSupport = new BrowserActivationStrategy((ColumnViewer)this.getCommonViewer());
        TreeViewerEditor.create((TreeViewer)this.getCommonViewer(), null, (ColumnViewerEditorActivationStrategy)this.actSupport, (int)58);
    }
}

