/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.internal.linkeditor.delete;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.statik.INamespaceUse;
import com.modeliosoft.modelio.core.jni.ITransaction;
import com.modeliosoft.modelio.core.transaction.ITransactionManager;
import com.modeliosoft.modelio.core.transaction.InvalidTransactionException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.PlatformUI;
import org.modelio.internal.linkeditor.plugin.LinkEditor;
import org.modelio.internal.linkeditor.view.background.BackgroundEditPart;
import org.modelio.internal.linkeditor.view.edge.EdgeEditPart;
import org.modelio.internal.linkeditor.view.node.GraphNode;
import org.modelio.internal.linkeditor.view.node.NodeEditPart;

public class DeleteSelectionHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        List selectedElements = this.getSelection();
        ITransactionManager transactionManager = LinkEditor.getInstance().getModelingSession().getTransactionManager();
        ITransaction t = transactionManager.createTransaction("delete selected elements");
        try {
            try {
                for (IElement el : selectedElements) {
                    if (!el.isValid()) continue;
                    el.delete();
                }
                transactionManager.commit(t);
                t = null;
            }
            catch (InvalidTransactionException e) {
                t = null;
                if (t != null) {
                    transactionManager.rollback(t);
                }
            }
        }
        finally {
            if (t != null) {
                transactionManager.rollback(t);
            }
        }
        return null;
    }

    protected List<IElement> getSelection() {
        ArrayList<IElement> selectedElements = new ArrayList<IElement>();
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (selection instanceof IStructuredSelection) {
            List selectedObjects = ((IStructuredSelection)selection).toList();
            for (Object selectedObject : selectedObjects) {
                GraphNode node;
                if (selectedObject instanceof EdgeEditPart) {
                    Edge edge = (Edge)((EdgeEditPart)selectedObject).getModel();
                    if (edge.data == null || !(edge.data instanceof IElement)) continue;
                    selectedElements.add((IElement)edge.data);
                    continue;
                }
                if (selectedObject instanceof NodeEditPart) {
                    node = ((NodeEditPart)selectedObject).getModel();
                    if (node.getData() == null) continue;
                    selectedElements.add(node.getData());
                    continue;
                }
                if (!(selectedObject instanceof BackgroundEditPart) || (node = ((BackgroundEditPart)selectedObject).getModel().getCenter()).getData() == null) continue;
                selectedElements.add(node.getData());
            }
        }
        return selectedElements;
    }

    public boolean isEnabled() {
        List selection = this.getSelection();
        for (IElement selectedElement : selection) {
            if (!(selectedElement instanceof INamespaceUse) && selectedElement.getElementStatus().isModifiable()) continue;
            return false;
        }
        return selection.size() > 0 && super.isEnabled();
    }
}

