/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.internal.linkeditor.image;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.gef.RootEditPart;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.handlers.HandlerUtil;
import org.modelio.internal.linkeditor.image.ImageBuilder;
import org.modelio.internal.linkeditor.image.SaveAsImageHandler;
import org.modelio.internal.linkeditor.plugin.LinkEditor;
import org.modelio.internal.linkeditor.view.LinkEditorView;

public class SaveAsImageHandler
extends AbstractHandler {
    static final String[] filterExtensions = new String[]{".png", ".bmp", ".jpg", ".gif"};
    static final String[] filterNames = new String[]{"PNG", "BMP", "JPEG", "GIF"};
    static final int[] filterFormats;
    static String initialFilterPath;
    static int initialFilterIndex;

    static {
        int[] nArray = new int[4];
        nArray[0] = 5;
        nArray[2] = 4;
        nArray[3] = 2;
        filterFormats = nArray;
        initialFilterPath = System.getenv("USERPROFILE");
        initialFilterIndex = 0;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        LinkEditorView linkEditorView = (LinkEditorView)HandlerUtil.getActivePart((ExecutionEvent)event);
        SaveInfo saveInfo = this.getSaveInfo();
        if (saveInfo != null) {
            this.saveAsImage(linkEditorView.getGraphicalViewer().getRootEditPart(), saveInfo);
        }
        return null;
    }

    private void saveAsImage(RootEditPart rootEditPart, SaveInfo saveInfo) {
        ImageBuilder imageBuilder = new ImageBuilder();
        Image img = imageBuilder.makeImage(rootEditPart);
        if (img != null) {
            ImageLoader imgLoader = new ImageLoader();
            imgLoader.data = new ImageData[]{img.getImageData()};
            imgLoader.save(saveInfo.location, saveInfo.format);
            img.dispose();
        }
    }

    private SaveInfo getSaveInfo() {
        FileDialog dlg = new FileDialog(Display.getCurrent().getActiveShell(), 8192);
        dlg.setOverwrite(true);
        dlg.setText(LinkEditor.I18N.getString("Gui.SaveAsImageDialog.Title"));
        dlg.setFilterExtensions(filterExtensions);
        dlg.setFilterNames(filterNames);
        dlg.setFilterIndex(initialFilterIndex);
        dlg.setFilterPath(initialFilterPath);
        dlg.setFileName("*" + filterExtensions[initialFilterIndex]);
        dlg.setOverwrite(true);
        String saveLocation = dlg.open();
        if (saveLocation == null) {
            return null;
        }
        int filterIndex = dlg.getFilterIndex();
        saveLocation = this.normalizeFilename(saveLocation, filterExtensions[filterIndex]);
        initialFilterIndex = filterIndex;
        initialFilterPath = dlg.getFilterPath();
        return new SaveInfo(this, saveLocation, filterFormats[filterIndex]);
    }

    private String normalizeFilename(String saveLocation, String fileExtension) {
        if (saveLocation.endsWith(fileExtension)) {
            return saveLocation;
        }
        return String.valueOf(saveLocation) + fileExtension;
    }
}

