/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.internal.linkeditor.options;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.State;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;

public class LinkEditorOptions {
    private int leftDepth = 1;
    private int rightDepth = 1;
    private PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    private List<IStereotype> dependencyFilter = new ArrayList();
    private static final String SHOW_DEPENDENCY_COMMAND_ID = "org.modelio.linkeditor.ShowDependencyCommandID";
    private static final String SHOW_ASSOCIATION_COMMAND_ID = "org.modelio.linkeditor.ShowAssociationCommandID";
    private static final String SHOW_INHERITANCE_COMMAND_ID = "org.modelio.linkeditor.ShowInheritanceCommandID";
    private static final String SHOW_ELEMENTIMPORT_COMMAND_ID = "org.modelio.linkeditor.ShowElementImportCommandID";
    private static final String PIN_EDITOR_COMMAND_ID = "org.modelio.linkeditor.PinEditorCommandID";
    private static final String SET_ORIENTATION_COMMAND_ID = "org.modelio.linkeditor.SetOrientationRadioCommandID";
    private static final String APPLY_DEPENDENCY_FILTER_COMMAND_ID = "org.modelio.linkeditor.ApplyDependencyFilterCommandID";
    private static final String SHOW_NAMESPACEUSE_COMMAND_ID = "org.modelio.linkeditor.ShowNamespaceUseCommandID";
    private static final String SHOW_TRACE_COMMAND_ID = "org.modelio.linkeditor.ShowTraceCommandID";

    public boolean isAssociationShown() {
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command command = commandService.getCommand(SHOW_ASSOCIATION_COMMAND_ID);
        State state = command.getState("org.eclipse.ui.commands.toggleState");
        return (Boolean)state.getValue();
    }

    public void setAssociationShown(boolean isAssociationShown) {
        this.listeners.firePropertyChange("isAssociationShown", !isAssociationShown, isAssociationShown);
    }

    public boolean isInheritanceShown() {
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command command = commandService.getCommand(SHOW_INHERITANCE_COMMAND_ID);
        State state = command.getState("org.eclipse.ui.commands.toggleState");
        return (Boolean)state.getValue();
    }

    public void setInheritanceShown(boolean isInheritanceShown) {
        this.listeners.firePropertyChange("isInheritanceShown", !isInheritanceShown, isInheritanceShown);
    }

    public boolean isDependencyShown() {
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command command = commandService.getCommand(SHOW_DEPENDENCY_COMMAND_ID);
        State state = command.getState("org.eclipse.ui.commands.toggleState");
        return (Boolean)state.getValue();
    }

    public void setDependencyShown(boolean isDependencyShown) {
        this.listeners.firePropertyChange("isDependencyShown", !isDependencyShown, isDependencyShown);
    }

    public List<IStereotype> getDependencyFilter() {
        return this.dependencyFilter;
    }

    public void setDependencyFilter(List<IStereotype> dependencyFilter) {
        if (this.dependencyFilter != dependencyFilter) {
            List oldValue = this.dependencyFilter;
            this.dependencyFilter = dependencyFilter;
            this.listeners.firePropertyChange("dependencyFilter", oldValue, this.dependencyFilter);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.removePropertyChangeListener(listener);
        this.listeners.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.removePropertyChangeListener(listener);
    }

    public int getLeftDepth() {
        return this.leftDepth;
    }

    public void setLeftDepth(int fromDepth) {
        if (this.leftDepth != fromDepth) {
            int oldDepth = this.leftDepth;
            this.leftDepth = fromDepth;
            this.listeners.firePropertyChange("leftDepth", oldDepth, this.leftDepth);
        }
    }

    public int getRightDepth() {
        return this.rightDepth;
    }

    public void setRightDepth(int toDepth) {
        if (this.rightDepth != toDepth) {
            int oldDepth = this.rightDepth;
            this.rightDepth = toDepth;
            this.listeners.firePropertyChange("rightDepth", oldDepth, this.rightDepth);
        }
    }

    public boolean isImportShown() {
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command command = commandService.getCommand(SHOW_ELEMENTIMPORT_COMMAND_ID);
        State state = command.getState("org.eclipse.ui.commands.toggleState");
        return (Boolean)state.getValue();
    }

    public void setImportShown(boolean isImportShown) {
        this.listeners.firePropertyChange("isImportShown", !isImportShown, isImportShown);
    }

    public void load() {
        IPreferenceStore preferenceStore = PlatformUI.getPreferenceStore();
        this.leftDepth = preferenceStore.getInt("org.modelio.linkeditor.fromDepth");
        this.rightDepth = preferenceStore.getInt("org.modelio.linkeditor.toDepth");
        this.dependencyFilter.clear();
    }

    public void save() {
        IPreferenceStore preferenceStore = PlatformUI.getPreferenceStore();
        preferenceStore.setValue("org.modelio.linkeditor.fromDepth", this.leftDepth);
        preferenceStore.setValue("org.modelio.linkeditor.toDepth", this.rightDepth);
    }

    public boolean isPinned() {
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command command = commandService.getCommand(PIN_EDITOR_COMMAND_ID);
        State state = command.getState("org.eclipse.ui.commands.toggleState");
        return (Boolean)state.getValue();
    }

    public boolean isLayoutOrientationVertical() {
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command command = commandService.getCommand(SET_ORIENTATION_COMMAND_ID);
        State state = command.getState("org.eclipse.ui.commands.radioState");
        if (state.getValue().equals("Auto")) {
            return this.isInheritanceShown() && !this.isAssociationShown() && !this.isDependencyShown() && !this.isTraceShown() && !this.isImportShown() && !this.isNamespaceUseShown();
        }
        return state.getValue().equals("Vertical");
    }

    public void changeLayoutOrientation() {
        this.listeners.firePropertyChange("layoutOrientation", true, false);
    }

    public boolean isDependencyFiltered() {
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command command = commandService.getCommand(APPLY_DEPENDENCY_FILTER_COMMAND_ID);
        State state = command.getState("org.eclipse.ui.commands.toggleState");
        return (Boolean)state.getValue();
    }

    public void setDependencyFiltered(boolean isDependencyFiltered) {
        this.listeners.firePropertyChange("isDependencyFiltered", !isDependencyFiltered, isDependencyFiltered);
    }

    public void setPinned(boolean isPinned) {
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command command = commandService.getCommand(PIN_EDITOR_COMMAND_ID);
        State state = command.getState("org.eclipse.ui.commands.toggleState");
        state.setValue((Object)isPinned);
    }

    public boolean isNamespaceUseShown() {
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command command = commandService.getCommand(SHOW_NAMESPACEUSE_COMMAND_ID);
        State state = command.getState("org.eclipse.ui.commands.toggleState");
        return (Boolean)state.getValue();
    }

    public void setNamespaceUseShown(boolean isNamespaceUseShown) {
        this.listeners.firePropertyChange("isNamespaceUseShown", !isNamespaceUseShown, isNamespaceUseShown);
    }

    public boolean isTraceShown() {
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command command = commandService.getCommand(SHOW_TRACE_COMMAND_ID);
        State state = command.getState("org.eclipse.ui.commands.toggleState");
        return (Boolean)state.getValue();
    }

    public void setTraceShown(boolean isTraceShown) {
        this.listeners.firePropertyChange("isDependencyShown", !isTraceShown, isTraceShown);
    }
}

