/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.internal.linkeditor.setdependencyfilter;

import com.modeliosoft.modelio.api.mdac.IMdac;
import com.modeliosoft.modelio.api.model.extension.IModule;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.app.StandardImageService;
import com.modeliosoft.modelio.core.model.IMetamodelExtensions;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.modelio.internal.linkeditor.plugin.LinkEditor;

public class CommonLabelProvider
extends LabelProvider {
    private static final String DOT_IMAGE = "dot.blue";

    public Image getImage(Object element) {
        if (element instanceof IMdac) {
            return this.getModuleImage((IMdac)element);
        }
        if (element instanceof IStereotype) {
            return this.getStereotypeImage((IStereotype)element);
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof IMdac) {
            return ((IMdac)element).getLabel();
        }
        if (element instanceof IStereotype) {
            StringBuffer stereotypeLabel = new StringBuffer();
            stereotypeLabel.append("\u00ab ");
            String label = ((IStereotype)element).getLabel();
            if (label != null && !label.isEmpty()) {
                stereotypeLabel.append(label);
            } else {
                stereotypeLabel.append(((IStereotype)element).getName());
            }
            stereotypeLabel.append(" \u00bb");
            return stereotypeLabel.toString();
        }
        return element.toString();
    }

    private Image getModuleImage(IMdac module) {
        String key = "MDAC." + module.getName();
        Image image = StandardImageService.getImage((String)key);
        if (image == null) {
            ImageDescriptor mdacImageDescriptor = module.getMdacImageDescriptor();
            if (mdacImageDescriptor != null) {
                StandardImageService.declareImage((String)key, (ImageDescriptor)mdacImageDescriptor);
                image = StandardImageService.getImage((String)key);
            } else {
                image = StandardImageService.getMetaclassImage(IModule.class);
            }
        }
        return image;
    }

    private Image getStereotypeImage(IStereotype stereotype) {
        Image image;
        IMdac mdac;
        IModelingSession modelingSession = LinkEditor.getInstance().getModelingSession();
        IMetamodelExtensions metamodelExtensions = modelingSession.getModel().getMetamodelExtensions();
        IModule module = metamodelExtensions.getModule(stereotype);
        if (module != null && (mdac = modelingSession.getMdacRegistry().getLoadedMdac(module)) != null) {
            Image image2 = mdac.getImage(stereotype, IMdac.ImageType.ICON);
            if (image2 != null) {
                return image2;
            }
            image2 = mdac.getImage(stereotype, IMdac.ImageType.DIAGRAM_ICON);
            if (image2 != null) {
                return image2;
            }
        }
        if ((image = StandardImageService.getImage((String)DOT_IMAGE)) != null) {
            return image;
        }
        ImageDescriptor desc = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.modelio.linkeditor", (String)"icons/dot_16.png");
        if (desc != null) {
            StandardImageService.declareImage((String)DOT_IMAGE, (ImageDescriptor)desc);
            return StandardImageService.getImage((String)DOT_IMAGE);
        }
        return null;
    }
}

