/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.internal.linkeditor.setdependencyfilter;

import com.modeliosoft.modelio.api.mdac.IMdac;
import com.modeliosoft.modelio.api.model.extension.IModule;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IDependency;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import com.modeliosoft.modelio.api.utils.ObList;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.model.IMetamodelExtensions;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.modelio.internal.linkeditor.plugin.LinkEditor;

class DialogModel {
    private Map<IMdac, Set<IStereotype>> notFilterStereotypes = new HashMap();
    private Map<IMdac, Set<IStereotype>> filterStereotypes = new HashMap();
    private static final String FILTER = "filter model changed";
    private PropertyChangeSupport listeners = new PropertyChangeSupport(this);

    public List<IStereotype> getFilter() {
        ArrayList<IStereotype> filter = new ArrayList<IStereotype>();
        filter.clear();
        for (IMdac mdac : this.filterStereotypes.keySet()) {
            for (IStereotype stereotype : (Set)this.filterStereotypes.get(mdac)) {
                filter.add(stereotype);
            }
        }
        return filter;
    }

    public DialogModel(List<IStereotype> currentFilter) {
        IModelingSession modelingSession = LinkEditor.getInstance().getModelingSession();
        if (modelingSession == null) {
            return;
        }
        IMetamodelExtensions metamodelExtensions = modelingSession.getModel().getMetamodelExtensions();
        ObList stereotypes = metamodelExtensions.getStereotypes(IDependency.class);
        for (IStereotype stereo : stereotypes) {
            if (stereo.isHidden() || "trace".equals(stereo.getName())) continue;
            IModule owningModule = metamodelExtensions.getModule(stereo);
            IMdac owningMdac = modelingSession.getMdacRegistry().getLoadedMdac(owningModule);
            Map mapToUse = currentFilter.contains(stereo) ? this.filterStereotypes : this.notFilterStereotypes;
            Set set = (Set)mapToUse.get(owningMdac);
            if (set == null) {
                mapToUse.put(owningMdac, new HashSet());
                set = (Set)mapToUse.get(owningMdac);
            }
            set.add(stereo);
        }
    }

    public void addToFilter(IStereotype stereotype) {
        Set set;
        IModelingSession modelingSession = LinkEditor.getInstance().getModelingSession();
        IModule module = modelingSession.getModel().getMetamodelExtensions().getModule(stereotype);
        assert (module != null) : "Could not find module that brought the stereotype: " + stereotype.getLabel();
        IMdac mdac = modelingSession.getMdacRegistry().getLoadedMdac(module);
        assert (mdac != null) : "Could not find the loaded mdac for the module: " + module.getName();
        ((Set)this.notFilterStereotypes.get(mdac)).remove(stereotype);
        if (((Set)this.notFilterStereotypes.get(mdac)).isEmpty()) {
            this.notFilterStereotypes.remove(mdac);
        }
        if ((set = (Set)this.filterStereotypes.get(mdac)) == null) {
            this.filterStereotypes.put(mdac, new HashSet());
            set = (Set)this.filterStereotypes.get(mdac);
        }
        set.add(stereotype);
        this.listeners.firePropertyChange(FILTER, null, stereotype);
    }

    public void removeFromFilter(IStereotype stereotype) {
        Set set;
        IModelingSession modelingSession = LinkEditor.getInstance().getModelingSession();
        IModule module = modelingSession.getModel().getMetamodelExtensions().getModule(stereotype);
        assert (module != null) : "Could not find module that brought the stereotype: " + stereotype.getLabel();
        IMdac mdac = modelingSession.getMdacRegistry().getLoadedMdac(module);
        assert (mdac != null) : "Could not find the loaded mdac for the module: " + module.getName();
        ((Set)this.filterStereotypes.get(mdac)).remove(stereotype);
        if (((Set)this.filterStereotypes.get(mdac)).isEmpty()) {
            this.filterStereotypes.remove(mdac);
        }
        if ((set = (Set)this.notFilterStereotypes.get(mdac)) == null) {
            this.notFilterStereotypes.put(mdac, new HashSet());
            set = (Set)this.notFilterStereotypes.get(mdac);
        }
        set.add(stereotype);
        this.listeners.firePropertyChange(FILTER, null, stereotype);
    }

    public void addToFilter(IMdac mdac) {
        Set fromSet = (Set)this.notFilterStereotypes.get(mdac);
        if (fromSet != null) {
            Set toSet = (Set)this.filterStereotypes.get(mdac);
            if (toSet == null) {
                this.filterStereotypes.put(mdac, new HashSet());
                toSet = (Set)this.filterStereotypes.get(mdac);
            }
            toSet.addAll(fromSet);
            fromSet.clear();
            this.notFilterStereotypes.remove(mdac);
            this.listeners.firePropertyChange(FILTER, null, mdac);
        }
    }

    public void removeFromFilter(IMdac mdac) {
        Set fromSet = (Set)this.filterStereotypes.get(mdac);
        if (fromSet != null) {
            Set toSet = (Set)this.notFilterStereotypes.get(mdac);
            if (toSet == null) {
                this.notFilterStereotypes.put(mdac, new HashSet());
                toSet = (Set)this.notFilterStereotypes.get(mdac);
            }
            toSet.addAll(fromSet);
            fromSet.clear();
            this.filterStereotypes.remove(mdac);
            this.listeners.firePropertyChange(FILTER, null, mdac);
        }
    }

    Map<IMdac, Set<IStereotype>> getNotFilterStereotypes() {
        return this.notFilterStereotypes;
    }

    Map<IMdac, Set<IStereotype>> getFilterStereotypes() {
        return this.filterStereotypes;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.removePropertyChangeListener(listener);
        this.listeners.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.removePropertyChangeListener(listener);
    }
}

