/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.internal.linkeditor.view;

import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.jni.ITransaction;
import com.modeliosoft.modelio.core.transaction.ITransactionManager;
import com.modeliosoft.modelio.core.transaction.InvalidTransactionException;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.modelio.internal.linkeditor.plugin.LinkEditor;

public class LinkEditorCommandStack
extends CommandStack {
    private IModelingSession session;

    public LinkEditorCommandStack(IModelingSession session) {
        this.session = session;
    }

    public boolean canRedo() {
        return this.session.getUndoManager().hasRedo();
    }

    public boolean canUndo() {
        return this.session.getUndoManager().hasUndo();
    }

    public void undo() {
        Command command = null;
        this.notifyListeners(command, 4);
        try {
            this.session.getUndoManager().undo();
            this.notifyListeners();
        }
        finally {
            this.notifyListeners(command, 32);
        }
    }

    public void redo() {
        if (!this.canRedo()) {
            return;
        }
        Command command = null;
        this.notifyListeners(command, 2);
        try {
            this.session.getUndoManager().redo();
            this.notifyListeners();
        }
        finally {
            this.notifyListeners(command, 16);
        }
    }

    public int getUndoLimit() {
        return -1;
    }

    public void flush() {
        throw new UnsupportedOperationException();
    }

    public boolean isDirty() {
        return this.session.isDirty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute(Command command) {
        if (command == null || !command.canExecute()) {
            return;
        }
        this.notifyListeners(command, 1);
        try {
            ITransactionManager transactionManager = this.session.getTransactionManager();
            ITransaction t = transactionManager.createTransaction(command.getLabel());
            try {
                try {
                    command.execute();
                    transactionManager.commit(t);
                    t = null;
                    this.notifyListeners();
                    return;
                }
                catch (InvalidTransactionException e) {
                    t = null;
                    if (t == null) return;
                    try {
                        transactionManager.rollback(t);
                        return;
                    }
                    catch (Exception e2) {
                        LinkEditor.LOG.error("Error while trying to rollback transaction:");
                        LinkEditor.LOG.error((Throwable)e2);
                    }
                    return;
                }
                catch (Exception e) {
                    LinkEditor.LOG.error((Throwable)e);
                    if (t == null) return;
                    try {
                        transactionManager.rollback(t);
                        return;
                    }
                    catch (Exception e3) {
                        LinkEditor.LOG.error("Error while trying to rollback transaction:");
                        LinkEditor.LOG.error((Throwable)e3);
                    }
                    return;
                }
            }
            finally {
                if (t != null) {
                    try {
                        transactionManager.rollback(t);
                    }
                    catch (Exception e) {
                        LinkEditor.LOG.error("Error while trying to rollback transaction:");
                        LinkEditor.LOG.error((Throwable)e);
                    }
                }
            }
        }
        finally {
            this.notifyListeners(command, 8);
        }
    }

    public void markSaveLocation() {
    }
}

