/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.internal.linkeditor.view;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.modelio.Modelio;
import com.modeliosoft.modelio.api.ui.dnd.ModelElementTransfer;
import com.modeliosoft.modelio.api.utils.ObRef;
import java.util.ArrayList;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.dnd.AbstractTransferDropTargetListener;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;

public class LinkEditorDropTargetListener
extends AbstractTransferDropTargetListener {
    public static final String DROPPED_ELEMENTS = "dropped elements";

    public LinkEditorDropTargetListener(EditPartViewer viewer) {
        super(viewer, (Transfer)ModelElementTransfer.getInstance());
        this.setEnablementDeterminedByCommand(true);
    }

    public LinkEditorDropTargetListener(EditPartViewer viewer, Transfer xfer) {
        super(viewer, xfer);
    }

    protected CreateRequest createTargetRequest() {
        return new CreateRequest((Object)"create child");
    }

    protected void updateTargetRequest() {
        this.getTargetRequest().setLocation(this.getDropLocation());
        this.setRequestDroppedElements(this.getCurrentEvent());
    }

    private IElement[] getLocalDraggedElements() {
        ArrayList<IElement> selectedElements = new ArrayList<IElement>();
        ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object o : structuredSelection) {
                IAdaptable adapter;
                IElement element;
                if (!(o instanceof IAdaptable) || (element = (IElement)(adapter = (IAdaptable)o).getAdapter(IElement.class)) == null) continue;
                selectedElements.add(element);
            }
        }
        return selectedElements.toArray(new IElement[0]);
    }

    protected CreateRequest getTargetRequest() {
        return (CreateRequest)super.getTargetRequest();
    }

    private void setRequestDroppedElements(DropTargetEvent event) {
        if (ModelElementTransfer.getInstance().isSupportedType(event.currentDataType)) {
            IElement[] droppedElements = null;
            ObRef[] refs = (ObRef[])event.data;
            if (refs != null) {
                droppedElements = new IElement[refs.length];
                int i = 0;
                while (i < droppedElements.length) {
                    droppedElements[i] = Modelio.getInstance().getModelingSession().findByRef(refs[i]);
                    ++i;
                }
            }
            if (droppedElements == null) {
                droppedElements = this.getLocalDraggedElements();
            }
            if (droppedElements != null) {
                this.getTargetRequest().getExtendedData().put(DROPPED_ELEMENTS, droppedElements);
            }
        }
    }
}

