/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.internal.linkeditor.view;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.app.O;
import com.modeliosoft.modelio.core.app.events.IPickingProvider;
import com.modeliosoft.modelio.core.app.events.ISessionListener;
import com.modeliosoft.modelio.core.model.change.IModelChangeListener;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.KeyStroke;
import org.eclipse.gef.MouseWheelHandler;
import org.eclipse.gef.MouseWheelZoomHandler;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.Tool;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CommandStackListener;
import org.eclipse.gef.dnd.TransferDropTargetListener;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.DeleteAction;
import org.eclipse.gef.ui.actions.DirectEditAction;
import org.eclipse.gef.ui.actions.PrintAction;
import org.eclipse.gef.ui.actions.RedoAction;
import org.eclipse.gef.ui.actions.SelectAllAction;
import org.eclipse.gef.ui.actions.UndoAction;
import org.eclipse.gef.ui.actions.UpdateAction;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.gef.ui.parts.SelectionSynchronizer;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.menus.IMenuService;
import org.eclipse.ui.part.ViewPart;
import org.modelio.internal.linkeditor.options.LinkEditorOptions;
import org.modelio.internal.linkeditor.plugin.LinkEditor;
import org.modelio.internal.linkeditor.view.LinkEditorCommandStack;
import org.modelio.internal.linkeditor.view.LinkEditorContextMenuProvider;
import org.modelio.internal.linkeditor.view.LinkEditorDropTargetListener;
import org.modelio.internal.linkeditor.view.LinkEditorEditPartFactory;
import org.modelio.internal.linkeditor.view.LinkEditorView;
import org.modelio.internal.linkeditor.view.ModelChangeListener;
import org.modelio.internal.linkeditor.view.OptionsChangeListener;
import org.modelio.internal.linkeditor.view.SelectionListener;
import org.modelio.internal.linkeditor.view.TreeBuilder;
import org.modelio.internal.linkeditor.view.background.BackgroundModel;
import org.modelio.internal.linkeditor.view.node.GraphNode;
import org.modelio.internal.linkeditor.view.tools.PanSelectionTool;
import org.modelio.internal.linkeditor.view.tools.PickingSelectionTool;

public class LinkEditorView
extends ViewPart
implements IPickingProvider,
CommandStackListener,
ISessionListener {
    public static final String VIEW_ID = "org.modelio.linkeditor.view.LinkEditorViewID";
    private EditDomain editDomain;
    private GraphicalViewer graphicalViewer;
    private ActionRegistry actionRegistry;
    private SelectionSynchronizer synchronizer;
    private final RootEditPart rootEditPart = new ScalableFreeformRootEditPart();
    private IElement currentSelection;
    private SelectionListener selectionListener;
    private OptionsChangeListener optionsChangeListener;
    private ModelChangeListener modelChangeListener;
    private ToolBarManager mgr;
    private static final String CONTEXT_ID = "org.modelio.linkeditor.ContextID";
    private static final String BOTTOM_TOOLBAR_ID = "toolbar:org.modelio.linkeditor.view.LinkEditorViewID.bottomtoolbar";
    private List<String> selectionActions = new ArrayList();
    private List<String> stackActions = new ArrayList();
    private List<String> propertyActions = new ArrayList();
    private FocusListener focusListener;

    public void setInput(IElement element) {
        GraphicalViewer viewer = this.getGraphicalViewer();
        Display display = viewer.getControl().getDisplay();
        BackgroundModel backgroundModel = (BackgroundModel)viewer.getContents().getModel();
        backgroundModel.nodes.clear();
        backgroundModel.edges.clear();
        display.syncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        if (element != null && element.isValid()) {
            Font systemFont = display.getSystemFont();
            GraphNode.WIDTH = 20 + FigureUtilities.getStringExtents((String)"abcdefghijklmn...", (Font)systemFont).width() + 3;
            GraphNode.HEIGHT = 2 + Math.max(16, systemFont.getFontData()[0].getHeight()) + 2 + 2;
            LinkEditorOptions currentOptions = LinkEditor.getInstance().getOptions();
            GraphNode centralNode = new GraphNode(element);
            centralNode.setCentral(true);
            backgroundModel.addNode((Node)centralNode);
            backgroundModel.setCenter(centralNode);
            if (currentOptions.getLeftDepth() > 0) {
                TreeBuilder.buildLeftTree((BackgroundModel)backgroundModel, (GraphNode)centralNode, (int)currentOptions.getLeftDepth(), (LinkEditorOptions)currentOptions);
            }
            if (currentOptions.getRightDepth() > 0) {
                TreeBuilder.buildRightTree((BackgroundModel)backgroundModel, (GraphNode)centralNode, (int)currentOptions.getRightDepth(), (LinkEditorOptions)currentOptions);
            }
        }
        display.syncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void createPartControl(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, true);
        gl.horizontalSpacing = 0;
        gl.verticalSpacing = 0;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        panel.setLayout((Layout)gl);
        this.createGraphicalViewer(panel);
        GridData viewerLayoutData = new GridData();
        viewerLayoutData.grabExcessHorizontalSpace = true;
        viewerLayoutData.grabExcessVerticalSpace = true;
        viewerLayoutData.horizontalAlignment = 4;
        viewerLayoutData.verticalAlignment = 4;
        this.getGraphicalViewer().getControl().setLayoutData((Object)viewerLayoutData);
        this.mgr = new ToolBarManager(0x800040);
        IMenuService menuService = (IMenuService)this.getViewSite().getService(IMenuService.class);
        menuService.populateContributionManager((ContributionManager)this.mgr, BOTTOM_TOOLBAR_ID);
        ToolBar tb = this.mgr.createControl(panel);
        GridData tbLayoutData = new GridData();
        tbLayoutData.grabExcessHorizontalSpace = true;
        tbLayoutData.grabExcessVerticalSpace = false;
        tbLayoutData.horizontalAlignment = 131072;
        tbLayoutData.verticalAlignment = 1024;
        tb.setLayoutData((Object)tbLayoutData);
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        contextService.activateContext(CONTEXT_ID);
    }

    public void setFocus() {
        this.getGraphicalViewer().getControl().setFocus();
    }

    public void commandStackChanged(EventObject event) {
        this.updateActions(this.stackActions);
    }

    protected void configureGraphicalViewer() {
        GraphicalViewer viewer = this.getGraphicalViewer();
        viewer.getControl().setBackground(ColorConstants.listBackground);
        viewer.setRootEditPart(this.rootEditPart);
        viewer.setEditPartFactory((EditPartFactory)new LinkEditorEditPartFactory());
        PanSelectionTool selectionTool = new PanSelectionTool();
        this.getEditDomain().setActiveTool((Tool)selectionTool);
        this.getEditDomain().setDefaultTool((Tool)selectionTool);
        viewer.setEditDomain(this.getEditDomain());
        IModelingSession modelingSession = LinkEditor.getInstance().getModelingSession();
        if (modelingSession != null) {
            this.getEditDomain().setCommandStack((CommandStack)new LinkEditorCommandStack(modelingSession));
        }
        int nZoomLevels = 32;
        double minZoom = 0.25;
        double maxZoom = 4.0;
        double[] zoomLevels = new double[nZoomLevels];
        double zoomIncrement = (maxZoom - minZoom) / (double)nZoomLevels;
        int i = 0;
        while (i < nZoomLevels) {
            zoomLevels[i] = minZoom + zoomIncrement * (double)i;
            ++i;
        }
        ZoomManager zoomManager = ((ScalableFreeformRootEditPart)viewer.getRootEditPart()).getZoomManager();
        zoomManager.setZoomLevels(zoomLevels);
        viewer.setProperty(MouseWheelHandler.KeyGenerator.getKey((int)SWT.MOD1), (Object)MouseWheelZoomHandler.SINGLETON);
        viewer.setContextMenu((MenuManager)new LinkEditorContextMenuProvider(viewer, this));
        GraphicalViewerKeyHandler kh = new GraphicalViewerKeyHandler(viewer);
        kh.put(KeyStroke.getPressed((int)0x100000B, (int)0), this.getActionRegistry().getAction((Object)"org.eclipse.gef.direct_edit"));
        kh.setParent(viewer.getKeyHandler());
        viewer.setKeyHandler((KeyHandler)kh);
    }

    protected void createActions() {
        ActionRegistry registry = this.getActionRegistry();
        UndoAction action = new UndoAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getStackActions().add(action.getId());
        action = new RedoAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getStackActions().add(action.getId());
        action = new SelectAllAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        action = new DeleteAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        registry.registerAction((IAction)new PrintAction((IWorkbenchPart)this));
        action = new DirectEditAction((IWorkbenchPart)this);
        this.getActionRegistry().registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
    }

    protected void createGraphicalViewer(Composite parent) {
        3 viewer = new /* Unavailable Anonymous Inner Class!! */;
        viewer.createControl(parent);
        this.setGraphicalViewer((GraphicalViewer)viewer);
        this.configureGraphicalViewer();
        this.hookGraphicalViewer();
        this.initializeGraphicalViewer();
        viewer.addDropTargetListener((TransferDropTargetListener)new LinkEditorDropTargetListener((EditPartViewer)viewer));
        this.focusListener = new /* Unavailable Anonymous Inner Class!! */;
        viewer.getControl().addFocusListener(this.focusListener);
    }

    public void dispose() {
        if (this.getGraphicalViewer().getControl() != null && !this.getGraphicalViewer().getControl().isDisposed()) {
            this.getGraphicalViewer().getControl().removeFocusListener(this.focusListener);
        }
        LinkEditor.getInstance().getOptions().removePropertyChangeListener((PropertyChangeListener)this.optionsChangeListener);
        this.optionsChangeListener = null;
        O.getDefault().getPickingProviderService().removePickingProvider((IPickingProvider)this);
        O.getDefault().getSessionService().removeSessionListener((ISessionListener)this);
        if (this.modelChangeListener != null) {
            LinkEditor.getInstance().getModelingSession().getModel().removeModelListener((IModelChangeListener)this.modelChangeListener);
            this.modelChangeListener = null;
        }
        this.getCommandStack().removeCommandStackListener((CommandStackListener)this);
        this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener((ISelectionListener)this.selectionListener);
        this.selectionListener = null;
        this.getEditDomain().setActiveTool(null);
        this.getActionRegistry().dispose();
        super.dispose();
    }

    protected void firePropertyChange(int property) {
        super.firePropertyChange(property);
        this.updateActions(this.propertyActions);
    }

    protected ActionRegistry getActionRegistry() {
        if (this.actionRegistry == null) {
            this.actionRegistry = new ActionRegistry();
        }
        return this.actionRegistry;
    }

    public Object getAdapter(Class type) {
        if (type == ZoomManager.class) {
            return ((ScalableFreeformRootEditPart)this.getGraphicalViewer().getRootEditPart()).getZoomManager();
        }
        if (type == GraphicalViewer.class) {
            return this.getGraphicalViewer();
        }
        if (type == CommandStack.class) {
            return this.getCommandStack();
        }
        if (type == ActionRegistry.class) {
            return this.getActionRegistry();
        }
        if (type == EditPart.class && this.getGraphicalViewer() != null) {
            return this.getGraphicalViewer().getRootEditPart();
        }
        if (type == IFigure.class && this.getGraphicalViewer() != null) {
            return ((GraphicalEditPart)this.getGraphicalViewer().getRootEditPart()).getFigure();
        }
        return super.getAdapter(type);
    }

    protected CommandStack getCommandStack() {
        return this.getEditDomain().getCommandStack();
    }

    protected EditDomain getEditDomain() {
        return this.editDomain;
    }

    public GraphicalViewer getGraphicalViewer() {
        return this.graphicalViewer;
    }

    protected List<String> getPropertyActions() {
        return this.propertyActions;
    }

    protected List<String> getSelectionActions() {
        return this.selectionActions;
    }

    protected SelectionSynchronizer getSelectionSynchronizer() {
        if (this.synchronizer == null) {
            this.synchronizer = new SelectionSynchronizer();
        }
        return this.synchronizer;
    }

    protected List<String> getStackActions() {
        return this.stackActions;
    }

    protected void hookGraphicalViewer() {
        this.getSelectionSynchronizer().addViewer((EditPartViewer)this.getGraphicalViewer());
        this.getSite().setSelectionProvider((ISelectionProvider)this.getGraphicalViewer());
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.setEditDomain(new EditDomain());
        this.getCommandStack().addCommandStackListener((CommandStackListener)this);
        this.selectionListener = new SelectionListener(this);
        this.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this.selectionListener);
        this.initializeActionRegistry();
        O.getDefault().getSessionService().addSessionListener((ISessionListener)this);
        O.getDefault().getPickingProviderService().addPickingProvider((IPickingProvider)this);
        this.optionsChangeListener = new OptionsChangeListener(this);
        LinkEditor.getInstance().getOptions().addPropertyChangeListener((PropertyChangeListener)this.optionsChangeListener);
    }

    protected void initializeActionRegistry() {
        this.createActions();
        this.updateActions(this.propertyActions);
        this.updateActions(this.stackActions);
    }

    protected void initializeGraphicalViewer() {
        BackgroundModel backgroundModel = new BackgroundModel();
        this.getGraphicalViewer().setContents((Object)backgroundModel);
    }

    protected void setActionRegistry(ActionRegistry registry) {
        this.actionRegistry = registry;
    }

    protected void setEditDomain(EditDomain ed) {
        this.editDomain = ed;
    }

    protected void setGraphicalViewer(GraphicalViewer viewer) {
        this.getEditDomain().addViewer((EditPartViewer)viewer);
        this.graphicalViewer = viewer;
    }

    protected void updateActions(List<String> actionIds) {
        ActionRegistry registry = this.getActionRegistry();
        for (String actionId : actionIds) {
            IAction action = registry.getAction((Object)actionId);
            if (!(action instanceof UpdateAction)) continue;
            ((UpdateAction)action).update();
        }
    }

    public void beginPicking() {
        this.getEditDomain().setActiveTool((Tool)new PickingSelectionTool());
    }

    public void endPicking() {
        this.getEditDomain().setActiveTool((Tool)new PanSelectionTool());
    }

    public void refreshFromCurrentSelection() {
        if (this.getGraphicalViewer().getControl() != null && !this.getGraphicalViewer().getControl().isDisposed() && (this.currentSelection == null || this.currentSelection.isValid())) {
            this.setInput(this.currentSelection);
        }
    }

    public void sessionOpened(IModelingSession modelingSession) {
        this.modelChangeListener = new ModelChangeListener(this);
        modelingSession.getModel().addModelListener((IModelChangeListener)this.modelChangeListener);
        GraphicalViewer viewer = this.getGraphicalViewer();
        if (viewer != null) {
            this.getEditDomain().setCommandStack((CommandStack)new LinkEditorCommandStack(modelingSession));
        }
    }

    public void sessionClosed(IModelingSession modelingSession) {
        this.setCurrentSelection(null);
        this.refreshFromCurrentSelection();
        modelingSession.getModel().removeModelListener((IModelChangeListener)this.modelChangeListener);
        this.modelChangeListener = null;
    }

    void setCurrentSelection(IElement currentSelection) {
        this.currentSelection = currentSelection;
    }

    void forceRefreshCenterNode() {
        GraphicalEditPart centerPart;
        GraphNode centerNode;
        if (this.currentSelection != null && this.currentSelection.isValid() && (centerNode = ((BackgroundModel)this.graphicalViewer.getContents().getModel()).getCenter()) != null && (centerPart = (GraphicalEditPart)this.graphicalViewer.getEditPartRegistry().get(centerNode)) != null) {
            centerPart.refresh();
        }
    }
}

