/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.internal.linkeditor.view;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IDependency;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import com.modeliosoft.modelio.api.model.uml.statik.IAssociationEnd;
import com.modeliosoft.modelio.api.model.uml.statik.IClassifier;
import com.modeliosoft.modelio.api.model.uml.statik.IElementImport;
import com.modeliosoft.modelio.api.model.uml.statik.IGeneralization;
import com.modeliosoft.modelio.api.model.uml.statik.IInterface;
import com.modeliosoft.modelio.api.model.uml.statik.IInterfaceRealization;
import com.modeliosoft.modelio.api.model.uml.statik.INameSpace;
import com.modeliosoft.modelio.api.model.uml.statik.INamespaceUse;
import com.modeliosoft.modelio.api.model.uml.statik.IOperation;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.Node;
import org.modelio.internal.linkeditor.options.LinkEditorOptions;
import org.modelio.internal.linkeditor.view.background.BackgroundModel;
import org.modelio.internal.linkeditor.view.node.EdgeBus;
import org.modelio.internal.linkeditor.view.node.GraphNode;

/*
 * Exception performing whole class analysis ignored.
 */
class TreeBuilder {
    TreeBuilder() {
    }

    public static void buildLeftTree(BackgroundModel graph, GraphNode node, int depth, LinkEditorOptions options) {
        IElement nodeElement = node.getData();
        if (options.isInheritanceShown()) {
            TreeBuilder.buildInheritanceLeftTree((BackgroundModel)graph, (GraphNode)node, (IElement)nodeElement, (int)depth, (LinkEditorOptions)options);
        }
        if (options.isNamespaceUseShown()) {
            TreeBuilder.buildNamespaceUseLeftTree((BackgroundModel)graph, (GraphNode)node, (IElement)nodeElement, (int)depth, (LinkEditorOptions)options);
        }
        if (options.isAssociationShown() && nodeElement instanceof IClassifier) {
            TreeBuilder.buildAssociationLeftTree((BackgroundModel)graph, (GraphNode)node, (IElement)nodeElement, (int)depth, (LinkEditorOptions)options);
        }
        if (options.isDependencyShown() && nodeElement instanceof IModelElement) {
            TreeBuilder.buildDependencyLeftTree((BackgroundModel)graph, (GraphNode)node, (IElement)nodeElement, (int)depth, (LinkEditorOptions)options);
        }
        if (options.isTraceShown() && nodeElement instanceof IModelElement) {
            TreeBuilder.buildTraceLeftTree((BackgroundModel)graph, (GraphNode)node, (IElement)nodeElement, (int)depth, (LinkEditorOptions)options);
        }
        if (options.isImportShown() && nodeElement instanceof INameSpace) {
            TreeBuilder.buildElementImportLeftTree((BackgroundModel)graph, (GraphNode)node, (IElement)nodeElement, (int)depth, (LinkEditorOptions)options);
        }
    }

    public static void buildRightTree(BackgroundModel graph, GraphNode node, int depth, LinkEditorOptions options) {
        IElement nodeElement = node.getData();
        if (options.isInheritanceShown()) {
            TreeBuilder.buildInheritanceRightTree((BackgroundModel)graph, (GraphNode)node, (IElement)nodeElement, (int)depth, (LinkEditorOptions)options);
        }
        if (options.isNamespaceUseShown()) {
            TreeBuilder.buildNamespaceUseRightTree((BackgroundModel)graph, (GraphNode)node, (IElement)nodeElement, (int)depth, (LinkEditorOptions)options);
        }
        if (options.isAssociationShown() && nodeElement instanceof IClassifier) {
            TreeBuilder.buildAssociationRightTree((BackgroundModel)graph, (GraphNode)node, (IElement)nodeElement, (int)depth, (LinkEditorOptions)options);
        }
        if (options.isDependencyShown() && nodeElement instanceof IModelElement) {
            TreeBuilder.buildDependencyRightTree((BackgroundModel)graph, (GraphNode)node, (IElement)nodeElement, (int)depth, (LinkEditorOptions)options);
        }
        if (options.isTraceShown() && nodeElement instanceof IModelElement) {
            TreeBuilder.buildTraceRightTree((BackgroundModel)graph, (GraphNode)node, (IElement)nodeElement, (int)depth, (LinkEditorOptions)options);
        }
        if (options.isImportShown()) {
            TreeBuilder.buildElementImportRightTree((BackgroundModel)graph, (GraphNode)node, (IElement)nodeElement, (int)depth, (LinkEditorOptions)options);
        }
    }

    private static void buildAssociationLeftTree(BackgroundModel graph, GraphNode node, IElement nodeElement, int depth, LinkEditorOptions options) {
        IClassifier classifierElement = (IClassifier)nodeElement;
        for (IAssociationEnd assocEnd : classifierElement.getPart(IAssociationEnd.class)) {
            if (assocEnd.isNavigable() || assocEnd.getOppositeEnds().size() != 1 || !((IAssociationEnd)assocEnd.getOppositeEnds().get(0)).isNavigable()) continue;
            GraphNode associatedNode = new GraphNode((IElement)((IAssociationEnd)assocEnd.getOppositeEnds().get(0)).getOwner());
            Edge assocEndEdge = TreeBuilder.createEdge((Object)assocEnd.getOppositeEnds().get(0), (GraphNode)associatedNode, (GraphNode)node, (BackgroundModel)graph);
            graph.addNode((Node)associatedNode);
            graph.addEdge(assocEndEdge);
            if (depth <= 1) continue;
            TreeBuilder.buildLeftTree((BackgroundModel)graph, (GraphNode)associatedNode, (int)(depth - 1), (LinkEditorOptions)options);
        }
    }

    private static void buildAssociationRightTree(BackgroundModel graph, GraphNode node, IElement nodeElement, int depth, LinkEditorOptions options) {
        IClassifier classifierElement = (IClassifier)nodeElement;
        for (IAssociationEnd assocEnd : classifierElement.getPart(IAssociationEnd.class)) {
            if (!assocEnd.isNavigable() && (assocEnd.getOppositeEnds().size() != 1 || ((IAssociationEnd)assocEnd.getOppositeEnds().get(0)).isNavigable())) continue;
            GraphNode associatedNode = new GraphNode((IElement)((IAssociationEnd)assocEnd.getOppositeEnds().get(0)).getOwner());
            Edge assocEdge = TreeBuilder.createEdge((Object)assocEnd, (GraphNode)node, (GraphNode)associatedNode, (BackgroundModel)graph);
            graph.addNode((Node)associatedNode);
            graph.addEdge(assocEdge);
            if (depth <= 1) continue;
            TreeBuilder.buildRightTree((BackgroundModel)graph, (GraphNode)associatedNode, (int)(depth - 1), (LinkEditorOptions)options);
        }
    }

    private static void buildDependencyLeftTree(BackgroundModel graph, GraphNode node, IElement nodeElement, int depth, LinkEditorOptions options) {
        IModelElement modelElement = (IModelElement)nodeElement;
        for (IDependency dependency : modelElement.getImpactedDependency()) {
            boolean passedFilter = true;
            if (options.isDependencyFiltered()) {
                passedFilter = false;
                for (IStereotype allowedStereotype : options.getDependencyFilter()) {
                    if (!dependency.isStereotyped(allowedStereotype.getName())) continue;
                    passedFilter = true;
                    break;
                }
            } else if (dependency.isStereotyped("trace")) {
                passedFilter = false;
            }
            if (!passedFilter) continue;
            GraphNode impactedNode = new GraphNode((IElement)dependency.getImpacted());
            Edge dependencyEdge = TreeBuilder.createEdge((Object)dependency, (GraphNode)impactedNode, (GraphNode)node, (BackgroundModel)graph);
            graph.addNode((Node)impactedNode);
            graph.addEdge(dependencyEdge);
            if (depth <= 1) continue;
            TreeBuilder.buildLeftTree((BackgroundModel)graph, (GraphNode)impactedNode, (int)(depth - 1), (LinkEditorOptions)options);
        }
    }

    private static void buildDependencyRightTree(BackgroundModel graph, GraphNode node, IElement nodeElement, int depth, LinkEditorOptions options) {
        IModelElement modelElement = (IModelElement)nodeElement;
        for (IDependency dependency : modelElement.getDependsOnDependency()) {
            boolean passedFilter = true;
            if (options.isDependencyFiltered()) {
                passedFilter = false;
                for (IStereotype allowedStereotype : options.getDependencyFilter()) {
                    if (!dependency.isStereotyped(allowedStereotype.getName())) continue;
                    passedFilter = true;
                    break;
                }
            } else if (dependency.isStereotyped("trace")) {
                passedFilter = false;
            }
            if (!passedFilter || dependency.getDependsOn() == null) continue;
            GraphNode dependsOnNode = new GraphNode((IElement)dependency.getDependsOn());
            Edge dependencyEdge = TreeBuilder.createEdge((Object)dependency, (GraphNode)node, (GraphNode)dependsOnNode, (BackgroundModel)graph);
            graph.addNode((Node)dependsOnNode);
            graph.addEdge(dependencyEdge);
            if (depth <= 1) continue;
            TreeBuilder.buildRightTree((BackgroundModel)graph, (GraphNode)dependsOnNode, (int)(depth - 1), (LinkEditorOptions)options);
        }
    }

    private static void buildElementImportLeftTree(BackgroundModel graph, GraphNode node, IElement nodeElement, int depth, LinkEditorOptions options) {
        INameSpace namespaceElement = (INameSpace)nodeElement;
        for (IElementImport elementImport : namespaceElement.getImporting()) {
            GraphNode importedNode = elementImport.getImportingOperation() != null ? new GraphNode((IElement)elementImport.getImportingOperation()) : new GraphNode((IElement)elementImport.getImportingNameSpace());
            Edge importEdge = TreeBuilder.createEdge((Object)elementImport, (GraphNode)importedNode, (GraphNode)node, (BackgroundModel)graph);
            graph.addNode((Node)importedNode);
            graph.addEdge(importEdge);
            if (depth <= 1) continue;
            TreeBuilder.buildLeftTree((BackgroundModel)graph, (GraphNode)importedNode, (int)(depth - 1), (LinkEditorOptions)options);
        }
    }

    private static void buildElementImportRightTree(BackgroundModel graph, GraphNode node, IElement nodeElement, int depth, LinkEditorOptions options) {
        Edge importEdge;
        GraphNode importedNode;
        if (nodeElement instanceof IOperation) {
            IOperation operationElement = (IOperation)nodeElement;
            for (IElementImport elementImport : operationElement.getOwnedImport()) {
                importedNode = new GraphNode((IElement)elementImport.getImportedElement());
                importEdge = TreeBuilder.createEdge((Object)elementImport, (GraphNode)node, (GraphNode)importedNode, (BackgroundModel)graph);
                graph.addNode((Node)importedNode);
                graph.addEdge(importEdge);
                if (depth <= 1) continue;
                TreeBuilder.buildRightTree((BackgroundModel)graph, (GraphNode)importedNode, (int)(depth - 1), (LinkEditorOptions)options);
            }
        }
        if (nodeElement instanceof INameSpace) {
            INameSpace namespaceElement = (INameSpace)nodeElement;
            for (IElementImport elementImport : namespaceElement.getOwnedImport()) {
                importedNode = new GraphNode((IElement)elementImport.getImportedElement());
                importEdge = TreeBuilder.createEdge((Object)elementImport, (GraphNode)node, (GraphNode)importedNode, (BackgroundModel)graph);
                graph.addNode((Node)importedNode);
                graph.addEdge(importEdge);
                if (depth <= 1) continue;
                TreeBuilder.buildRightTree((BackgroundModel)graph, (GraphNode)importedNode, (int)(depth - 1), (LinkEditorOptions)options);
            }
        }
    }

    private static void buildInheritanceLeftTree(BackgroundModel graph, GraphNode node, IElement nodeElement, int depth, LinkEditorOptions options) {
        if (nodeElement instanceof INameSpace) {
            INameSpace namespaceElement = (INameSpace)nodeElement;
            for (IGeneralization generalisation : namespaceElement.getSpecialization()) {
                GraphNode subTypeNode = new GraphNode((IElement)generalisation.getSubType());
                Edge generalisationEdge = TreeBuilder.createEdge((Object)generalisation, (GraphNode)subTypeNode, (GraphNode)node, (BackgroundModel)graph);
                graph.addNode((Node)subTypeNode);
                graph.addEdge(generalisationEdge);
                if (depth <= 1) continue;
                TreeBuilder.buildLeftTree((BackgroundModel)graph, (GraphNode)subTypeNode, (int)(depth - 1), (LinkEditorOptions)options);
            }
        }
        if (nodeElement instanceof IInterface) {
            IInterface interfaceElement = (IInterface)nodeElement;
            for (IInterfaceRealization interfaceRealization : interfaceElement.getImplementedLink()) {
                GraphNode implementerNode = new GraphNode((IElement)interfaceRealization.getImplementer());
                Edge interfaceRealizationEdge = TreeBuilder.createEdge((Object)interfaceRealization, (GraphNode)implementerNode, (GraphNode)node, (BackgroundModel)graph);
                graph.addNode((Node)implementerNode);
                graph.addEdge(interfaceRealizationEdge);
                if (depth <= 1) continue;
                TreeBuilder.buildLeftTree((BackgroundModel)graph, (GraphNode)implementerNode, (int)(depth - 1), (LinkEditorOptions)options);
            }
        }
        if (nodeElement instanceof IOperation) {
            IOperation operationElement = (IOperation)nodeElement;
            for (IOperation operationRedefinition : operationElement.getRedefinition()) {
                GraphNode redefinitionNode = new GraphNode((IElement)operationRedefinition);
                Edge operationRedefinitionEdge = TreeBuilder.createEdge((Object)operationRedefinition, (GraphNode)redefinitionNode, (GraphNode)node, (BackgroundModel)graph);
                graph.addNode((Node)redefinitionNode);
                graph.addEdge(operationRedefinitionEdge);
                if (depth <= 1) continue;
                TreeBuilder.buildLeftTree((BackgroundModel)graph, (GraphNode)redefinitionNode, (int)(depth - 1), (LinkEditorOptions)options);
            }
        }
    }

    private static void buildInheritanceRightTree(BackgroundModel graph, GraphNode node, IElement nodeElement, int depth, LinkEditorOptions options) {
        IOperation operationElement;
        IOperation redefinedOperation;
        if (nodeElement instanceof INameSpace) {
            INameSpace namespaceElement = (INameSpace)nodeElement;
            for (IGeneralization generalisation : namespaceElement.getParent()) {
                GraphNode superTypeNode = new GraphNode((IElement)generalisation.getSuperType());
                Edge generalisationEdge = TreeBuilder.createEdge((Object)generalisation, (GraphNode)node, (GraphNode)superTypeNode, (BackgroundModel)graph);
                graph.addNode((Node)superTypeNode);
                graph.addEdge(generalisationEdge);
                if (depth <= 1) continue;
                TreeBuilder.buildRightTree((BackgroundModel)graph, (GraphNode)superTypeNode, (int)(depth - 1), (LinkEditorOptions)options);
            }
            for (IInterfaceRealization interfaceRealization : namespaceElement.getRealized()) {
                GraphNode implementedInterfaceNode = new GraphNode((IElement)interfaceRealization.getImplemented());
                Edge interfaceRealisationEdge = TreeBuilder.createEdge((Object)interfaceRealization, (GraphNode)node, (GraphNode)implementedInterfaceNode, (BackgroundModel)graph);
                graph.addNode((Node)implementedInterfaceNode);
                graph.addEdge(interfaceRealisationEdge);
                if (depth <= 1) continue;
                TreeBuilder.buildRightTree((BackgroundModel)graph, (GraphNode)implementedInterfaceNode, (int)(depth - 1), (LinkEditorOptions)options);
            }
        }
        if (nodeElement instanceof IOperation && (redefinedOperation = (operationElement = (IOperation)nodeElement).getRedefines()) != null) {
            GraphNode redefinedOperationNode = new GraphNode((IElement)redefinedOperation);
            Edge redefiningOperationEdge = TreeBuilder.createEdge((Object)operationElement, (GraphNode)node, (GraphNode)redefinedOperationNode, (BackgroundModel)graph);
            graph.addNode((Node)redefinedOperationNode);
            graph.addEdge(redefiningOperationEdge);
            if (depth > 1) {
                TreeBuilder.buildRightTree((BackgroundModel)graph, (GraphNode)redefinedOperationNode, (int)(depth - 1), (LinkEditorOptions)options);
            }
        }
    }

    private static void buildNamespaceUseLeftTree(BackgroundModel graph, GraphNode node, IElement nodeElement, int depth, LinkEditorOptions options) {
        INamespaceUse useEl;
        INameSpace user;
        if (nodeElement instanceof INameSpace) {
            INameSpace namespaceElement = (INameSpace)nodeElement;
            for (INamespaceUse use : namespaceElement.getuserNamespaceUse()) {
                GraphNode userNode = new GraphNode((IElement)use.getuser());
                Edge generalisationEdge = TreeBuilder.createEdge((Object)use, (GraphNode)userNode, (GraphNode)node, (BackgroundModel)graph);
                graph.addNode((Node)userNode);
                graph.addEdge(generalisationEdge);
                if (depth <= 1) continue;
                TreeBuilder.buildLeftTree((BackgroundModel)graph, (GraphNode)userNode, (int)(depth - 1), (LinkEditorOptions)options);
            }
        } else if (nodeElement instanceof INamespaceUse && (user = (useEl = (INamespaceUse)nodeElement).getuser()) != null) {
            GraphNode userNode = new GraphNode((IElement)user);
            Edge edge = TreeBuilder.createEdge((Object)useEl, (GraphNode)userNode, (GraphNode)node, (BackgroundModel)graph);
            graph.addNode((Node)userNode);
            graph.addEdge(edge);
            if (depth > 1) {
                TreeBuilder.buildLeftTree((BackgroundModel)graph, (GraphNode)userNode, (int)(depth - 1), (LinkEditorOptions)options);
            }
        }
    }

    private static void buildNamespaceUseRightTree(BackgroundModel graph, GraphNode node, IElement nodeElement, int depth, LinkEditorOptions options) {
        INamespaceUse useEl;
        INameSpace user;
        if (nodeElement instanceof INameSpace) {
            INameSpace namespaceElement = (INameSpace)nodeElement;
            for (INamespaceUse use : namespaceElement.getusedNamespaceUse()) {
                GraphNode usedNode = new GraphNode((IElement)use.getused());
                Edge generalisationEdge = TreeBuilder.createEdge((Object)use, (GraphNode)node, (GraphNode)usedNode, (BackgroundModel)graph);
                graph.addNode((Node)usedNode);
                graph.addEdge(generalisationEdge);
                if (depth <= 1) continue;
                TreeBuilder.buildRightTree((BackgroundModel)graph, (GraphNode)usedNode, (int)(depth - 1), (LinkEditorOptions)options);
            }
        } else if (nodeElement instanceof INamespaceUse && (user = (useEl = (INamespaceUse)nodeElement).getused()) != null) {
            GraphNode userNode = new GraphNode((IElement)user);
            Edge edge = TreeBuilder.createEdge((Object)useEl, (GraphNode)node, (GraphNode)userNode, (BackgroundModel)graph);
            graph.addNode((Node)userNode);
            graph.addEdge(edge);
            if (depth > 1) {
                TreeBuilder.buildRightTree((BackgroundModel)graph, (GraphNode)userNode, (int)(depth - 1), (LinkEditorOptions)options);
            }
        }
    }

    private static void buildTraceLeftTree(BackgroundModel graph, GraphNode node, IElement nodeElement, int depth, LinkEditorOptions options) {
        IModelElement modelElement = (IModelElement)nodeElement;
        for (IDependency dependency : modelElement.getImpactedDependency()) {
            if (!dependency.isStereotyped("trace")) continue;
            GraphNode impactedNode = new GraphNode((IElement)dependency.getImpacted());
            Edge dependencyEdge = TreeBuilder.createEdge((Object)dependency, (GraphNode)impactedNode, (GraphNode)node, (BackgroundModel)graph);
            graph.addNode((Node)impactedNode);
            graph.addEdge(dependencyEdge);
            if (depth <= 1) continue;
            TreeBuilder.buildLeftTree((BackgroundModel)graph, (GraphNode)impactedNode, (int)(depth - 1), (LinkEditorOptions)options);
        }
    }

    private static void buildTraceRightTree(BackgroundModel graph, GraphNode node, IElement nodeElement, int depth, LinkEditorOptions options) {
        IModelElement modelElement = (IModelElement)nodeElement;
        for (IDependency dependency : modelElement.getDependsOnDependency()) {
            if (!dependency.isStereotyped("trace") || dependency.getDependsOn() == null) continue;
            GraphNode dependsOnNode = new GraphNode((IElement)dependency.getDependsOn());
            Edge dependencyEdge = TreeBuilder.createEdge((Object)dependency, (GraphNode)node, (GraphNode)dependsOnNode, (BackgroundModel)graph);
            graph.addNode((Node)dependsOnNode);
            graph.addEdge(dependencyEdge);
            if (depth <= 1) continue;
            TreeBuilder.buildRightTree((BackgroundModel)graph, (GraphNode)dependsOnNode, (int)(depth - 1), (LinkEditorOptions)options);
        }
    }

    private static Edge createEdge(Object data, GraphNode fromNode, GraphNode toNode, BackgroundModel graph) {
        Edge busEdge;
        EdgeBus bus;
        Edge modifiedEdge;
        GraphNode realFrom = fromNode;
        GraphNode realTo = toNode;
        if (fromNode.outgoing.size() > 0) {
            if (fromNode.outgoing.getEdge((int)0).target instanceof EdgeBus) {
                realFrom = fromNode.outgoing.getEdge((int)0).target;
            } else {
                modifiedEdge = fromNode.outgoing.getEdge(0);
                bus = new EdgeBus();
                busEdge = new Edge((Node)fromNode, (Node)bus);
                modifiedEdge.setSource((Node)bus);
                graph.addNode((Node)bus);
                graph.addEdge(busEdge);
                realFrom = bus;
            }
        }
        if (toNode.incoming.size() > 0) {
            if (toNode.incoming.getEdge((int)0).source instanceof EdgeBus) {
                realTo = toNode.incoming.getEdge((int)0).source;
            } else {
                modifiedEdge = toNode.incoming.getEdge(0);
                bus = new EdgeBus();
                busEdge = new Edge((Node)bus, (Node)toNode);
                modifiedEdge.setTarget((Node)bus);
                graph.addNode((Node)bus);
                graph.addEdge(busEdge);
                realTo = bus;
            }
        }
        return new Edge(data, (Node)realFrom, (Node)realTo);
    }
}

