/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.internal.linkeditor.view.background;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.EdgeList;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.modelio.internal.linkeditor.plugin.LinkEditor;
import org.modelio.internal.linkeditor.view.background.BackgroundModel;
import org.modelio.internal.linkeditor.view.background.DropEditPolicy;
import org.modelio.internal.linkeditor.view.node.EdgeBus;
import org.modelio.internal.linkeditor.view.node.GraphNode;

public class BackgroundEditPart
extends AbstractGraphicalEditPart
implements PropertyChangeListener {
    private static int HORIZONTAL_RANK_GAP;
    private static int VERTICAL_GAP;
    private static int VERTICAL_RANK_GAP;
    private static int HORIZONTAL_GAP;

    public void activate() {
        super.activate();
        this.getModel().addPropertyChangeListener((PropertyChangeListener)this);
    }

    public void deactivate() {
        super.deactivate();
        this.getModel().removePropertyChangeListener((PropertyChangeListener)this);
    }

    public BackgroundModel getModel() {
        return (BackgroundModel)super.getModel();
    }

    public void performRequest(Request req) {
        if ("open".equals(req.getType())) {
            LinkEditor.getInstance().getOptions().setPinned(!LinkEditor.getInstance().getOptions().isPinned());
        } else {
            super.performRequest(req);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("Content")) {
            HORIZONTAL_RANK_GAP = (int)(0.75 * (double)GraphNode.WIDTH);
            VERTICAL_GAP = HORIZONTAL_RANK_GAP / 2;
            VERTICAL_RANK_GAP = -VERTICAL_GAP / 4 * 3;
            HORIZONTAL_GAP = (int)((double)HORIZONTAL_RANK_GAP * 1.5);
            this.refreshChildren();
            this.refreshVisuals();
        }
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        IFigure child = ((GraphicalEditPart)childEditPart).getFigure();
        Node model = (Node)childEditPart.getModel();
        this.getContentPane().add(child, (Object)new Rectangle(model.x, model.y, model.width, model.height), index);
    }

    protected void createEditPolicies() {
        this.installEditPolicy((Object)"LayoutEditPolicy", (EditPolicy)new DropEditPolicy());
    }

    protected IFigure createFigure() {
        FreeformLayer freeformLayer = new FreeformLayer();
        freeformLayer.setLayoutManager((LayoutManager)new FreeformLayout());
        freeformLayer.setOpaque(true);
        Color swtColor = Display.getDefault().getSystemColor(25);
        freeformLayer.setBackgroundColor(swtColor);
        return freeformLayer;
    }

    protected List<?> getModelChildren() {
        BackgroundModel directedGraph = this.getModel();
        boolean vertical = LinkEditor.getInstance().getOptions().isLayoutOrientationVertical();
        GraphNode center = directedGraph.getCenter();
        if (center != null) {
            int offsetLeft = this.layout((Node)center, 0, 0, vertical, true);
            int offsetRight = this.layout((Node)center, 0, 0, vertical, false);
            int offset = Math.max(offsetLeft, offsetRight);
            this.layout((Node)center, 0, (offset - offsetLeft) / 2, vertical, true);
            this.layout((Node)center, 0, (offset - offsetRight) / 2, vertical, false);
            this.fixBusesSize(directedGraph, vertical);
            this.shiftAll(directedGraph);
        }
        return directedGraph.nodes;
    }

    private void fixBusesSize(BackgroundModel directedGraph, boolean vertical) {
        for (Object node : directedGraph.nodes) {
            int tmp2;
            int tmp;
            if (!(node instanceof EdgeBus)) continue;
            int min = Integer.MAX_VALUE;
            int max = Integer.MIN_VALUE;
            if (((EdgeBus)node).incoming.size() > 1) {
                for (Object incomingEdge : ((EdgeBus)node).incoming) {
                    tmp = vertical ? ((Edge)incomingEdge).source.x : ((Edge)incomingEdge).source.y;
                    int n = tmp2 = vertical ? tmp + ((Edge)incomingEdge).source.width : tmp + ((Edge)incomingEdge).source.height;
                    if (tmp < min) {
                        min = tmp;
                    }
                    if (max >= tmp2) continue;
                    max = tmp2;
                }
            }
            if (((EdgeBus)node).outgoing.size() > 1) {
                for (Object outgoingEdge : ((EdgeBus)node).outgoing) {
                    tmp = vertical ? ((Edge)outgoingEdge).target.x : ((Edge)outgoingEdge).target.y;
                    int n = tmp2 = vertical ? tmp + ((Edge)outgoingEdge).target.width : tmp + ((Edge)outgoingEdge).target.height;
                    if (tmp < min) {
                        min = tmp;
                    }
                    if (max >= tmp2) continue;
                    max = tmp2;
                }
            }
            if (vertical) {
                ((EdgeBus)node).x = min;
                ((EdgeBus)node).width = max - min;
                continue;
            }
            ((EdgeBus)node).y = min;
            ((EdgeBus)node).height = max - min;
        }
    }

    private Point getViewAreaSize() {
        Point controlSize = new Point(0, 0);
        this.getViewer().getControl().getDisplay().syncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        return controlSize;
    }

    private int layout(Node node, int rank, int initialOffset, boolean vertical, boolean goLeft) {
        int offset = initialOffset;
        EdgeList edges = goLeft ? node.incoming : node.outgoing;
        for (Object edgeObj : edges) {
            int rankGap;
            Edge edge = (Edge)edgeObj;
            Node nextNode = goLeft ? edge.source : edge.target;
            int n = rankGap = vertical ? VERTICAL_RANK_GAP : HORIZONTAL_RANK_GAP;
            int rankIncrement = node instanceof EdgeBus ? 2 * rankGap : (nextNode instanceof EdgeBus ? 1 * rankGap : (int)(2.5 * (double)rankGap));
            int nextRank = goLeft ? rank - rankIncrement : rank + rankIncrement;
            offset = (vertical ? HORIZONTAL_GAP : VERTICAL_GAP) + this.layout(nextNode, nextRank, offset, vertical, goLeft);
        }
        if (edges.size() > 0) {
            offset -= vertical ? HORIZONTAL_GAP : VERTICAL_GAP;
        }
        if (vertical) {
            node.x = initialOffset + (offset - initialOffset) / 2;
            node.y = rank - node.height / 2;
        } else {
            node.x = rank - node.width / 2;
            node.y = initialOffset + (offset - initialOffset) / 2;
        }
        return offset;
    }

    private void shiftAll(BackgroundModel directedGraph) {
        int yDelta;
        int xDelta;
        Point controlSize = this.getViewAreaSize();
        GraphNode centerNode = directedGraph.getCenter();
        boolean vertical = LinkEditor.getInstance().getOptions().isLayoutOrientationVertical();
        if (centerNode.incoming.isEmpty() && !centerNode.outgoing.isEmpty()) {
            if (vertical) {
                xDelta = controlSize.x / 2 - (centerNode.x + centerNode.width / 2);
                yDelta = controlSize.y - (centerNode.y + centerNode.height + 2);
            } else {
                xDelta = -centerNode.x + 2;
                yDelta = controlSize.y / 2 - (centerNode.y + centerNode.height / 2);
            }
        } else if (centerNode.outgoing.isEmpty() && !centerNode.incoming.isEmpty()) {
            if (vertical) {
                xDelta = controlSize.x / 2 - (centerNode.x + centerNode.width / 2);
                yDelta = -centerNode.y + 2;
            } else {
                xDelta = controlSize.x - (centerNode.x + centerNode.width + 2);
                yDelta = controlSize.y / 2 - (centerNode.y + centerNode.height / 2);
            }
        } else {
            xDelta = controlSize.x / 2 - (centerNode.x + centerNode.width / 2);
            yDelta = controlSize.y / 2 - (centerNode.y + centerNode.height / 2);
        }
        for (Object nodeObj : directedGraph.nodes) {
            Node node = (Node)nodeObj;
            node.x += xDelta;
            node.y += yDelta;
        }
    }
}

