/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.internal.linkeditor.view.background;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IDependency;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import com.modeliosoft.modelio.api.model.uml.statik.IAssociation;
import com.modeliosoft.modelio.api.model.uml.statik.IClassifier;
import com.modeliosoft.modelio.api.model.uml.statik.IElementImport;
import com.modeliosoft.modelio.api.model.uml.statik.IGeneralization;
import com.modeliosoft.modelio.api.model.uml.statik.IInterface;
import com.modeliosoft.modelio.api.model.uml.statik.IInterfaceRealization;
import com.modeliosoft.modelio.api.model.uml.statik.INameSpace;
import com.modeliosoft.modelio.api.model.uml.statik.IOperation;
import com.modeliosoft.modelio.core.app.O;
import com.modeliosoft.modelio.core.factory.BasicElementInitializer;
import com.modeliosoft.modelio.core.factory.IModelFactory;
import com.modeliosoft.modelio.core.model.expert.CreationExpertRegistry;
import com.modeliosoft.modelio.core.model.expert.ICreationExpert;
import java.util.List;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.widgets.Display;
import org.modelio.internal.linkeditor.plugin.LinkEditor;
import org.modelio.internal.linkeditor.view.background.typeselection.TypeSelectionModel;
import org.modelio.internal.linkeditor.view.background.typeselection.TypeSelectionPopup;

public class CreateLinkCommand
extends Command {
    private IElement from;
    private IElement to;
    private List<Object> newLinkTypes;
    private static Object linkTypeToUse = null;

    public CreateLinkCommand(IElement from, IElement to, List<Object> newLinkTypes) {
        this.from = from;
        this.to = to;
        this.newLinkTypes = newLinkTypes;
        linkTypeToUse = null;
    }

    public boolean canExecute() {
        boolean isFromModifiable = this.from.getElementStatus().isModifiable();
        boolean canLink = true;
        if (this.newLinkTypes.size() == 0) {
            canLink = true;
        } else if (this.newLinkTypes.size() == 1) {
            Object newLinkType = this.newLinkTypes.get(0);
            if (newLinkType instanceof Class) {
                if (IAssociation.class.isAssignableFrom((Class)newLinkType)) {
                    canLink = CreationExpertRegistry.getExpert(IAssociation.class).canLink(this.from, this.to, null);
                } else if (IDependency.class.isAssignableFrom((Class)newLinkType)) {
                    canLink = CreationExpertRegistry.getExpert(IDependency.class).canLink(this.from, this.to, null);
                } else if (IElementImport.class.isAssignableFrom((Class)newLinkType)) {
                    canLink = CreationExpertRegistry.getExpert(IElementImport.class).canLink(this.from, this.to, null);
                } else if (IGeneralization.class.isAssignableFrom((Class)newLinkType)) {
                    canLink = CreationExpertRegistry.getExpert(IGeneralization.class).canLink(this.from, this.to, null);
                } else if (IInterfaceRealization.class.isAssignableFrom((Class)newLinkType)) {
                    canLink = CreationExpertRegistry.getExpert(IInterfaceRealization.class).canLink(this.from, this.to, null);
                }
            } else if (newLinkType instanceof IStereotype) {
                ICreationExpert creationExpert = CreationExpertRegistry.getExpert((IStereotype)((IStereotype)newLinkType));
                if (creationExpert == null) {
                    creationExpert = CreationExpertRegistry.getExpert(IDependency.class);
                }
                canLink = creationExpert.canLink(this.from, this.to, null);
            }
        }
        return isFromModifiable && canLink;
    }

    public void execute() {
        IDependency dependency;
        if (this.newLinkTypes.size() == 0) {
            if (linkTypeToUse == null) {
                return;
            }
        } else if (this.newLinkTypes.size() == 1) {
            linkTypeToUse = this.newLinkTypes.get(0);
        } else {
            TypeSelectionModel model = new TypeSelectionModel(this.newLinkTypes);
            TypeSelectionPopup popup = new TypeSelectionPopup(Display.getDefault().getActiveShell(), model);
            popup.setBlockOnOpen(true);
            linkTypeToUse = popup.open() == 0 ? model.getSelectedType() : null;
        }
        IModelFactory factory = LinkEditor.getInstance().getModelingSession().getModelFactory();
        IElement newElement = null;
        if (linkTypeToUse instanceof Class) {
            if (IAssociation.class.isAssignableFrom((Class)linkTypeToUse)) {
                newElement = (IElement)factory.createAssociation((IClassifier)this.from, (IClassifier)this.to, "").getConnection().get(0);
            } else if (IElementImport.class.isAssignableFrom((Class)linkTypeToUse)) {
                newElement = this.from instanceof INameSpace ? factory.createElementImport((INameSpace)this.from, (INameSpace)this.to) : factory.createElementImport((IOperation)this.from, (INameSpace)this.to);
            } else if (IGeneralization.class.isAssignableFrom((Class)linkTypeToUse)) {
                newElement = factory.createGeneralization((INameSpace)this.from, (INameSpace)this.to);
            } else if (IInterfaceRealization.class.isAssignableFrom((Class)linkTypeToUse)) {
                newElement = factory.createInterfaceRealization((INameSpace)this.from, (IInterface)this.to);
            } else if (IDependency.class.isAssignableFrom((Class)linkTypeToUse)) {
                dependency = factory.createDependency();
                dependency.setImpacted((IModelElement)this.from);
                dependency.setDependsOn((IModelElement)this.to);
                newElement = dependency;
            }
        } else if (linkTypeToUse instanceof IStereotype) {
            dependency = factory.createDependency();
            dependency.setImpacted((IModelElement)this.from);
            dependency.setDependsOn((IModelElement)this.to);
            dependency.addExtension((IStereotype)linkTypeToUse);
            newElement = dependency;
        }
        if (newElement != null) {
            BasicElementInitializer initializer = new BasicElementInitializer(O.getDefault().getModelingSession());
            initializer.initialize(newElement);
        }
    }
}

