/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.internal.linkeditor.view.background;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IDependency;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import com.modeliosoft.modelio.api.model.uml.statik.IAssociation;
import com.modeliosoft.modelio.api.model.uml.statik.IElementImport;
import com.modeliosoft.modelio.api.model.uml.statik.IGeneralization;
import com.modeliosoft.modelio.api.model.uml.statik.IInterfaceRealization;
import com.modeliosoft.modelio.api.utils.StereotypeNotFoundException;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.model.IMetamodelExtensions;
import com.modeliosoft.modelio.core.model.expert.CreationExpertRegistry;
import com.modeliosoft.modelio.core.model.expert.ICreationExpert;
import com.modeliosoft.modelio.core.ui.CoreFontRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionLocator;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.PolylineDecoration;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.XYAnchor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;
import org.modelio.internal.linkeditor.options.LinkEditorOptions;
import org.modelio.internal.linkeditor.plugin.LinkEditor;
import org.modelio.internal.linkeditor.view.background.BackgroundModel;
import org.modelio.internal.linkeditor.view.background.CreateLinkCommand;
import org.modelio.internal.linkeditor.view.node.GraphNode;

/*
 * Exception performing whole class analysis ignored.
 */
public class DropEditPolicy
extends XYLayoutEditPolicy {
    private static final String CLOSING = " \u00bb";
    private static final String OPENING = "\u00ab ";
    private XYAnchor dummyXYAnchor = new XYAnchor(new Point(10, 10));
    private PolylineConnection connectionFeedback;
    private static final PointList TRIANGLE_TIP;
    private ChopboxAnchor dummyChopBoxAnchor = new ChopboxAnchor(null);

    static {
        int[] nArray = new int[6];
        nArray[0] = -1;
        nArray[1] = 1;
        nArray[4] = -1;
        nArray[5] = -1;
        TRIANGLE_TIP = new PointList(nArray);
    }

    protected Command getCreateCommand(CreateRequest request) {
        IElement[] droppedElements = (IElement[])request.getExtendedData().get("dropped elements");
        if (droppedElements != null && droppedElements.length > 0 && LinkEditor.getInstance().getOptions().isPinned()) {
            boolean isFrom = this.getSide(request);
            List newLinkTypes = DropEditPolicy.getNewLinkType((IElement)this.getCenterNode().getData(), (IElement[])droppedElements, (boolean)isFrom);
            if (newLinkTypes.size() == 0) {
                return UnexecutableCommand.INSTANCE;
            }
            CompoundCommand command = new CompoundCommand();
            IElement[] iElementArray = droppedElements;
            int n = droppedElements.length;
            int n2 = 0;
            while (n2 < n) {
                IElement element = iElementArray[n2];
                if (isFrom) {
                    command.add((Command)new CreateLinkCommand(element, this.getCenterNode().getData(), newLinkTypes));
                } else {
                    command.add((Command)new CreateLinkCommand(this.getCenterNode().getData(), element, newLinkTypes));
                }
                newLinkTypes = Collections.emptyList();
                ++n2;
            }
            return command.unwrap();
        }
        return UnexecutableCommand.INSTANCE;
    }

    private static List<Object> getNewLinkType(IElement centerElement, IElement[] droppedElements, boolean isFrom) {
        if (droppedElements.length == 0) {
            return Collections.emptyList();
        }
        LinkEditorOptions options = LinkEditor.getInstance().getOptions();
        Class<?> dropType = null;
        IElement[] iElementArray = droppedElements;
        int n = droppedElements.length;
        int n2 = 0;
        while (n2 < n) {
            IElement droppedElement = iElementArray[n2];
            if (dropType == null) {
                dropType = droppedElement.getClass();
            } else if (!dropType.equals(droppedElement.getClass())) {
                return Collections.emptyList();
            }
            ++n2;
        }
        ArrayList<Object> types = new ArrayList<Object>();
        if (options.isAssociationShown() && (isFrom && CreationExpertRegistry.getExpert(IAssociation.class).canLink(droppedElements[0], centerElement, null) || !isFrom && CreationExpertRegistry.getExpert(IAssociation.class).canLink(centerElement, droppedElements[0], null))) {
            types.add(IAssociation.class);
        }
        if (options.isImportShown() && (isFrom && CreationExpertRegistry.getExpert(IElementImport.class).canLink(droppedElements[0], centerElement, null) || !isFrom && CreationExpertRegistry.getExpert(IElementImport.class).canLink(centerElement, droppedElements[0], null))) {
            types.add(IElementImport.class);
        }
        if (options.isInheritanceShown()) {
            if (isFrom && CreationExpertRegistry.getExpert(IGeneralization.class).canLink(droppedElements[0], centerElement, null) || !isFrom && CreationExpertRegistry.getExpert(IGeneralization.class).canLink(centerElement, droppedElements[0], null)) {
                types.add(IGeneralization.class);
            }
            if (isFrom && CreationExpertRegistry.getExpert(IInterfaceRealization.class).canLink(droppedElements[0], centerElement, null) || !isFrom && CreationExpertRegistry.getExpert(IInterfaceRealization.class).canLink(centerElement, droppedElements[0], null)) {
                types.add(IInterfaceRealization.class);
            }
        }
        if (options.isDependencyShown()) {
            if (options.isDependencyFiltered() && options.getDependencyFilter() != null) {
                for (IStereotype stereo : options.getDependencyFilter()) {
                    ICreationExpert expert = CreationExpertRegistry.getExpert((IStereotype)stereo);
                    if (expert == null) {
                        expert = CreationExpertRegistry.getExpert(IDependency.class);
                    }
                    if ((!isFrom || !expert.canLink(droppedElements[0], centerElement, null)) && (isFrom || !expert.canLink(centerElement, droppedElements[0], null))) continue;
                    types.add(stereo);
                }
            } else if (isFrom && CreationExpertRegistry.getExpert(IDependency.class).canLink(droppedElements[0], centerElement, null) || !isFrom && CreationExpertRegistry.getExpert(IDependency.class).canLink(centerElement, droppedElements[0], null)) {
                types.add(IDependency.class);
            }
        }
        if (options.isTraceShown()) {
            IModelingSession modelingSession = LinkEditor.getInstance().getModelingSession();
            IMetamodelExtensions metamodelExtensions = modelingSession.getModel().getMetamodelExtensions();
            try {
                IStereotype traceStereotype = metamodelExtensions.getStereotype(IDependency.class, "trace");
                types.add(traceStereotype);
            }
            catch (StereotypeNotFoundException e) {
                LinkEditor.LOG.error((Throwable)e);
            }
        }
        return types;
    }

    protected EditPolicy createChildEditPolicy(EditPart child) {
        return null;
    }

    protected void showLayoutTargetFeedback(Request request) {
        if (!(request instanceof CreateRequest)) {
            return;
        }
        CreateRequest createRequest = (CreateRequest)request;
        GraphNode centerNode = this.getCenterNode();
        GraphicalEditPart centerNodeEditPart = (GraphicalEditPart)this.getHost().getViewer().getEditPartRegistry().get(centerNode);
        IFigure centerNodeFigure = centerNodeEditPart.getFigure();
        this.dummyChopBoxAnchor.setOwner(centerNodeFigure);
        this.dummyXYAnchor.setLocation(createRequest.getLocation());
        boolean isFrom = this.getSide(createRequest);
        if (this.connectionFeedback == null) {
            this.connectionFeedback = new PolylineConnection();
            this.connectionFeedback.setVisible(true);
            this.connectionFeedback.setOpaque(true);
            IElement[] droppedElements = (IElement[])request.getExtendedData().get("dropped elements");
            List newLinkTypes = DropEditPolicy.getNewLinkType((IElement)this.getCenterNode().getData(), (IElement[])droppedElements, (boolean)isFrom);
            if (newLinkTypes.size() == 1) {
                Object newLinkType = newLinkTypes.get(0);
                if (newLinkType == IAssociation.class) {
                    this.decorateAssociation(this.connectionFeedback);
                } else if (newLinkType == IElementImport.class) {
                    this.decorateElementImport(this.connectionFeedback);
                } else if (newLinkType == IGeneralization.class || newLinkType == IInterfaceRealization.class) {
                    this.decorateGeneralization(this.connectionFeedback);
                } else if (newLinkType == IDependency.class) {
                    this.decorateDependency(this.connectionFeedback, null);
                } else if (newLinkType instanceof IStereotype) {
                    this.decorateDependency(this.connectionFeedback, (IStereotype)newLinkType);
                }
            }
            this.getFeedbackLayer().add((IFigure)this.connectionFeedback);
        }
        if (isFrom) {
            this.connectionFeedback.setSourceAnchor((ConnectionAnchor)this.dummyXYAnchor);
            this.connectionFeedback.setTargetAnchor((ConnectionAnchor)this.dummyChopBoxAnchor);
        } else {
            this.connectionFeedback.setSourceAnchor((ConnectionAnchor)this.dummyChopBoxAnchor);
            this.connectionFeedback.setTargetAnchor((ConnectionAnchor)this.dummyXYAnchor);
        }
        this.getFeedbackLayer().remove((IFigure)this.connectionFeedback);
        this.getFeedbackLayer().add((IFigure)this.connectionFeedback);
        super.showLayoutTargetFeedback(request);
    }

    public void deactivate() {
        super.deactivate();
        if (this.connectionFeedback != null) {
            this.getFeedbackLayer().remove((IFigure)this.connectionFeedback);
            this.connectionFeedback = null;
        }
    }

    private boolean getSide(CreateRequest request) {
        GraphNode centerNode = this.getCenterNode();
        if (LinkEditor.getInstance().getOptions().isLayoutOrientationVertical()) {
            return request.getLocation().y >= centerNode.y + centerNode.height / 2;
        }
        return request.getLocation().x < centerNode.x + centerNode.width / 2;
    }

    protected void eraseLayoutTargetFeedback(Request request) {
        if (this.connectionFeedback != null) {
            this.getFeedbackLayer().remove((IFigure)this.connectionFeedback);
            this.connectionFeedback = null;
        }
        super.eraseLayoutTargetFeedback(request);
    }

    private void decorateElementImport(PolylineConnection fig) {
        fig.setLineStyle(2);
        fig.setTargetDecoration((RotatableDecoration)new PolylineDecoration());
        Label role = new Label();
        role.setText("\u00ab access \u00bb");
        role.setFont(CoreFontRegistry.getScaledFont((Font)Display.getDefault().getSystemFont(), (float)0.9f));
        ConnectionLocator constraint = new ConnectionLocator((Connection)fig, 4);
        constraint.setGap(2);
        constraint.setRelativePosition(1);
        fig.add((IFigure)role, 0);
        fig.setConstraint((IFigure)role, (Object)constraint);
    }

    private void decorateDependency(PolylineConnection fig, IStereotype stereo) {
        String stereoLabel;
        fig.setLineStyle(2);
        fig.setTargetDecoration((RotatableDecoration)new PolylineDecoration());
        if (stereo != null && (stereoLabel = stereo.getLabel() != null && !stereo.getLabel().isEmpty() ? stereo.getLabel() : stereo.getName()) != null && !stereoLabel.isEmpty()) {
            Label role = new Label();
            role.setText("\u00ab " + stereoLabel + " \u00bb");
            role.setFont(CoreFontRegistry.getScaledFont((Font)Display.getDefault().getSystemFont(), (float)0.9f));
            ConnectionLocator constraint = new ConnectionLocator((Connection)fig, 4);
            constraint.setGap(2);
            constraint.setRelativePosition(1);
            fig.add((IFigure)role, 0);
            fig.setConstraint((IFigure)role, (Object)constraint);
        }
    }

    private void decorateAssociation(PolylineConnection fig) {
        PolylineDecoration targetDecoration = new PolylineDecoration();
        targetDecoration.setTemplate(TRIANGLE_TIP);
        fig.setTargetDecoration((RotatableDecoration)targetDecoration);
        Label role = new Label();
        role.setText("associationEnd");
        role.setFont(CoreFontRegistry.getScaledFont((Font)Display.getDefault().getSystemFont(), (float)0.9f));
        ConnectionLocator constraint = new ConnectionLocator((Connection)fig, 3);
        constraint.setGap(5);
        constraint.setRelativePosition(9);
        fig.add((IFigure)role, 0);
        fig.setConstraint((IFigure)role, (Object)constraint);
        Label card = new Label();
        card.setText("[0..1]");
        card.setFont(CoreFontRegistry.getScaledFont((Font)Display.getDefault().getSystemFont(), (float)0.9f));
        constraint = new ConnectionLocator((Connection)fig, 3);
        constraint.setGap(5);
        constraint.setRelativePosition(12);
        fig.add((IFigure)card, 0);
        fig.setConstraint((IFigure)card, (Object)constraint);
    }

    private void decorateGeneralization(PolylineConnection fig) {
        PolygonDecoration arrow = new PolygonDecoration();
        arrow.setTemplate(PolygonDecoration.TRIANGLE_TIP);
        arrow.setScale(8.0, 5.0);
        arrow.setOpaque(true);
        arrow.setFill(true);
        Color swtColor = Display.getDefault().getSystemColor(24);
        arrow.setForegroundColor(swtColor);
        arrow.setBackgroundColor(ColorConstants.white);
        fig.setTargetDecoration((RotatableDecoration)arrow);
    }

    private GraphNode getCenterNode() {
        GraphNode centerNode = ((BackgroundModel)this.getHost().getModel()).getCenter();
        return centerNode;
    }
}

