/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.internal.linkeditor.view.edge;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IDependency;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import com.modeliosoft.modelio.api.model.uml.statik.IAssociationEnd;
import com.modeliosoft.modelio.api.model.uml.statik.IElementImport;
import com.modeliosoft.modelio.api.model.uml.statik.IGeneralization;
import com.modeliosoft.modelio.api.model.uml.statik.IInterfaceRealization;
import com.modeliosoft.modelio.api.model.uml.statik.INamespaceUse;
import com.modeliosoft.modelio.api.model.uml.statik.IOperation;
import com.modeliosoft.modelio.api.model.uml.statik.ObAggregationKindEnum;
import com.modeliosoft.modelio.api.model.uml.statik.ObVisibilityModeEnum;
import com.modeliosoft.modelio.api.utils.ObList;
import com.modeliosoft.modelio.core.ui.CoreFontRegistry;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionLocator;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.ManhattanConnectionRouter;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.PolylineDecoration;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gef.editpolicies.ConnectionEndpointEditPolicy;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;
import org.modelio.internal.linkeditor.plugin.LinkEditor;
import org.modelio.internal.linkeditor.view.edge.DeleteEdgeEditPolicy;

public class EdgeEditPart
extends AbstractConnectionEditPart {
    private static final String CLOSING = " \u00bb";
    private static final String OPENING = "\u00ab ";
    private static final PointList AGGREG_TIP;
    private static final PointList NAVIG_AGGREG_TIP;
    private static final PointList TRIANGLE_TIP;

    static {
        int[] nArray = new int[8];
        nArray[0] = -1;
        nArray[1] = 1;
        nArray[4] = -1;
        nArray[5] = -1;
        nArray[6] = -2;
        AGGREG_TIP = new PointList(nArray);
        int[] nArray2 = new int[16];
        nArray2[0] = -1;
        nArray2[1] = 1;
        nArray2[4] = -1;
        nArray2[5] = -1;
        nArray2[6] = -2;
        nArray2[8] = -3;
        nArray2[9] = -1;
        nArray2[10] = -2;
        nArray2[12] = -3;
        nArray2[13] = 1;
        nArray2[14] = -2;
        NAVIG_AGGREG_TIP = new PointList(nArray2);
        int[] nArray3 = new int[6];
        nArray3[0] = -1;
        nArray3[1] = 1;
        nArray3[4] = -1;
        nArray3[5] = -1;
        TRIANGLE_TIP = new PointList(nArray3);
    }

    protected void createEditPolicies() {
        this.installEditPolicy((Object)"Connection Endpoint Policy", (EditPolicy)new ConnectionEndpointEditPolicy());
        this.installEditPolicy((Object)"ComponentEditPolicy", (EditPolicy)new DeleteEdgeEditPolicy());
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        PolylineConnection fig = (PolylineConnection)this.getFigure();
        ManhattanConnectionRouter router = new ManhattanConnectionRouter();
        fig.setConnectionRouter((ConnectionRouter)router);
        Edge edge = (Edge)this.getModel();
        Object model = edge.data;
        if (model != null) {
            Color swtColor = Display.getDefault().getSystemColor(24);
            fig.setForegroundColor(swtColor);
            if (model instanceof IGeneralization || model instanceof IOperation) {
                this.decorateGeneralization(fig);
            } else if (model instanceof IInterfaceRealization) {
                this.decorateGeneralization(fig);
                fig.setLineStyle(2);
            } else if (model instanceof IAssociationEnd) {
                this.decorateAssociation(fig, model);
            } else if (model instanceof IDependency) {
                this.decorateDependency(fig, model);
            } else if (model instanceof IElementImport) {
                this.decorateElementImport(fig, model);
            } else if (model instanceof INamespaceUse) {
                this.decorateNamespaceUse(fig, model);
            }
        } else {
            fig.setForegroundColor(ColorConstants.lightGray);
            fig.setLineWidth(2);
        }
    }

    public Object getAdapter(Class adapter) {
        Object model = this.getModel();
        if (adapter.isInstance(model)) {
            return model;
        }
        if (model instanceof Edge && adapter.isInstance(((Edge)model).data)) {
            return ((Edge)model).data;
        }
        return super.getAdapter(adapter);
    }

    private void decorateElementImport(PolylineConnection fig, Object model) {
        fig.setLineStyle(2);
        fig.setTargetDecoration((RotatableDecoration)new PolylineDecoration());
        Label role = new Label();
        if (((IElementImport)model).getVisibility() == ObVisibilityModeEnum.PUBLIC) {
            role.setText("\u00ab import \u00bb");
        } else {
            role.setText("\u00ab access \u00bb");
        }
        role.setFont(CoreFontRegistry.getScaledFont((Font)Display.getDefault().getSystemFont(), (float)0.9f));
        ConnectionLocator constraint = new ConnectionLocator((Connection)fig, 4);
        constraint.setGap(2);
        constraint.setRelativePosition(1);
        fig.add((IFigure)role, 0);
        fig.setConstraint((IFigure)role, (Object)constraint);
    }

    private void decorateDependency(PolylineConnection fig, Object model) {
        IDependency dependency = (IDependency)model;
        fig.setLineStyle(2);
        fig.setTargetDecoration((RotatableDecoration)new PolylineDecoration());
        ObList stereotypes = dependency.getExtension();
        if (stereotypes != null && !stereotypes.isEmpty()) {
            Label role = new Label();
            if (stereotypes.size() == 1) {
                IStereotype stereotype = (IStereotype)stereotypes.get(0);
                String stereoLabel = stereotype.getLabel() != null && !stereotype.getLabel().isEmpty() ? stereotype.getLabel() : stereotype.getName();
                role.setText(OPENING + stereoLabel + CLOSING);
            } else {
                IStereotype stereotype2;
                Label tooltip = new Label();
                for (IStereotype stereotype2 : dependency.getExtension()) {
                    String stereoLabel;
                    String string = stereoLabel = stereotype2.getLabel() != null && !stereotype2.getLabel().isEmpty() ? stereotype2.getLabel() : stereotype2.getName();
                    if (tooltip.getText() == null || tooltip.getText().isEmpty()) {
                        tooltip.setText(OPENING + stereoLabel);
                        continue;
                    }
                    tooltip.setText(String.valueOf(tooltip.getText()) + ", " + stereoLabel);
                }
                tooltip.setText(String.valueOf(tooltip.getText()) + CLOSING);
                role.setToolTip((IFigure)tooltip);
                stereotype2 = (IStereotype)stereotypes.get(0);
                String stereoLabel = stereotype2.getLabel() != null && !stereotype2.getLabel().isEmpty() ? stereotype2.getLabel() : stereotype2.getName();
                role.setText(OPENING + stereoLabel + ", ... " + CLOSING);
            }
            role.setFont(CoreFontRegistry.getScaledFont((Font)Display.getDefault().getSystemFont(), (float)0.9f));
            ConnectionLocator constraint = new ConnectionLocator((Connection)fig, 4);
            constraint.setGap(2);
            constraint.setRelativePosition(1);
            fig.add((IFigure)role, 0);
            fig.setConstraint((IFigure)role, (Object)constraint);
        }
    }

    private void decorateAssociation(PolylineConnection fig, Object model) {
        IAssociationEnd assocEnd = (IAssociationEnd)model;
        this.decorateAssociationSource(fig, assocEnd);
        this.decorateAssociationTarget(fig, assocEnd);
    }

    private void decorateGeneralization(PolylineConnection fig) {
        PolygonDecoration arrow = new PolygonDecoration();
        arrow.setTemplate(PolygonDecoration.TRIANGLE_TIP);
        arrow.setScale(8.0, 5.0);
        arrow.setOpaque(true);
        arrow.setFill(true);
        Color swtColor = Display.getDefault().getSystemColor(24);
        arrow.setForegroundColor(swtColor);
        arrow.setBackgroundColor(ColorConstants.white);
        fig.setTargetDecoration((RotatableDecoration)arrow);
    }

    public boolean isSelectable() {
        return ((Edge)this.getModel()).data != null;
    }

    private void decorateAssociationTarget(PolylineConnection fig, IAssociationEnd assocEnd) {
        if (assocEnd.isNavigable()) {
            boolean hasMax;
            PolygonDecoration targetDecoration;
            IAssociationEnd opposite = (IAssociationEnd)assocEnd.getOppositeEnds().get(0);
            if (opposite.getAggregation() == ObAggregationKindEnum.KIND_IS_AGGREGATION || opposite.getAggregation() == ObAggregationKindEnum.KIND_IS_COMPOSITION) {
                targetDecoration = new PolygonDecoration();
                targetDecoration.setTemplate(NAVIG_AGGREG_TIP);
                if (opposite.getAggregation() == ObAggregationKindEnum.KIND_IS_AGGREGATION) {
                    targetDecoration.setBackgroundColor(ColorConstants.white);
                } else {
                    targetDecoration.setBackgroundColor(ColorConstants.black);
                }
            } else {
                targetDecoration = new PolylineDecoration();
                ((PolylineDecoration)targetDecoration).setTemplate(TRIANGLE_TIP);
            }
            fig.setTargetDecoration((RotatableDecoration)targetDecoration);
            Label role = new Label();
            role.setText(assocEnd.getName());
            role.setFont(CoreFontRegistry.getScaledFont((Font)Display.getDefault().getSystemFont(), (float)0.9f));
            ConnectionLocator constraint = new ConnectionLocator((Connection)fig, 3);
            constraint.setGap(5);
            if (LinkEditor.getInstance().getOptions().isLayoutOrientationVertical()) {
                constraint.setRelativePosition(12);
            } else {
                constraint.setRelativePosition(9);
            }
            fig.add((IFigure)role, 0);
            fig.setConstraint((IFigure)role, (Object)constraint);
            Label card = new Label();
            String cardText = "";
            boolean hasMin = assocEnd.getMultiplicityMin() != null && !assocEnd.getMultiplicityMin().isEmpty();
            boolean bl = hasMax = assocEnd.getMultiplicityMax() != null && !assocEnd.getMultiplicityMax().isEmpty();
            if (hasMin && !hasMax) {
                cardText = "[" + assocEnd.getMultiplicityMin() + "]";
            } else if (!hasMin && hasMax) {
                cardText = "[" + assocEnd.getMultiplicityMax() + "]";
            } else if (hasMin && hasMax) {
                cardText = "[" + assocEnd.getMultiplicityMin() + ".." + assocEnd.getMultiplicityMax() + "]";
            }
            card.setText(cardText);
            card.setFont(CoreFontRegistry.getScaledFont((Font)Display.getDefault().getSystemFont(), (float)0.9f));
            constraint = new ConnectionLocator((Connection)fig, 3);
            constraint.setGap(5);
            if (LinkEditor.getInstance().getOptions().isLayoutOrientationVertical()) {
                constraint.setRelativePosition(20);
            } else {
                constraint.setRelativePosition(12);
            }
            fig.add((IFigure)card, 0);
            fig.setConstraint((IFigure)card, (Object)constraint);
        } else if (((IAssociationEnd)assocEnd.getOppositeEnds().get(0)).getAggregation() == ObAggregationKindEnum.KIND_IS_AGGREGATION || ((IAssociationEnd)assocEnd.getOppositeEnds().get(0)).getAggregation() == ObAggregationKindEnum.KIND_IS_COMPOSITION) {
            PolygonDecoration targetDecoration = new PolygonDecoration();
            targetDecoration.setTemplate(AGGREG_TIP);
            if (((IAssociationEnd)assocEnd.getOppositeEnds().get(0)).getAggregation() == ObAggregationKindEnum.KIND_IS_AGGREGATION) {
                targetDecoration.setBackgroundColor(ColorConstants.white);
            } else {
                targetDecoration.setBackgroundColor(ColorConstants.black);
            }
            fig.setTargetDecoration((RotatableDecoration)targetDecoration);
        }
    }

    private void decorateAssociationSource(PolylineConnection fig, IAssociationEnd assocEnd) {
        PolygonDecoration sourceDecoration = new PolygonDecoration();
        if (((IAssociationEnd)assocEnd.getOppositeEnds().get(0)).isNavigable()) {
            boolean hasMax;
            IAssociationEnd opposite = (IAssociationEnd)assocEnd.getOppositeEnds().get(0);
            if (assocEnd.getAggregation() == ObAggregationKindEnum.KIND_IS_AGGREGATION || assocEnd.getAggregation() == ObAggregationKindEnum.KIND_IS_COMPOSITION) {
                sourceDecoration = new PolygonDecoration();
                sourceDecoration.setTemplate(NAVIG_AGGREG_TIP);
                if (assocEnd.getAggregation() == ObAggregationKindEnum.KIND_IS_AGGREGATION) {
                    sourceDecoration.setBackgroundColor(ColorConstants.white);
                } else {
                    sourceDecoration.setBackgroundColor(ColorConstants.black);
                }
            } else {
                sourceDecoration = new PolylineDecoration();
                ((PolylineDecoration)sourceDecoration).setTemplate(TRIANGLE_TIP);
            }
            fig.setSourceDecoration((RotatableDecoration)sourceDecoration);
            Label role = new Label();
            role.setText(opposite.getName());
            role.setFont(CoreFontRegistry.getScaledFont((Font)Display.getDefault().getSystemFont(), (float)0.9f));
            ConnectionLocator constraint = new ConnectionLocator((Connection)fig, 2);
            constraint.setGap(5);
            if (LinkEditor.getInstance().getOptions().isLayoutOrientationVertical()) {
                constraint.setRelativePosition(9);
            } else {
                constraint.setRelativePosition(17);
            }
            fig.add((IFigure)role, 0);
            fig.setConstraint((IFigure)role, (Object)constraint);
            Label card = new Label();
            String cardText = "";
            boolean hasMin = opposite.getMultiplicityMin() != null && !opposite.getMultiplicityMin().isEmpty();
            boolean bl = hasMax = opposite.getMultiplicityMax() != null && !opposite.getMultiplicityMax().isEmpty();
            if (hasMin && !hasMax) {
                cardText = "[" + opposite.getMultiplicityMin() + "]";
            } else if (!hasMin && hasMax) {
                cardText = "[" + opposite.getMultiplicityMax() + "]";
            } else if (hasMin && hasMax) {
                cardText = "[" + opposite.getMultiplicityMin() + ".." + opposite.getMultiplicityMax() + "]";
            }
            card.setText(cardText);
            card.setFont(CoreFontRegistry.getScaledFont((Font)Display.getDefault().getSystemFont(), (float)0.9f));
            constraint = new ConnectionLocator((Connection)fig, 2);
            constraint.setGap(5);
            if (LinkEditor.getInstance().getOptions().isLayoutOrientationVertical()) {
                constraint.setRelativePosition(17);
            } else {
                constraint.setRelativePosition(20);
            }
            fig.add((IFigure)card, 0);
            fig.setConstraint((IFigure)card, (Object)constraint);
        } else if (assocEnd.getAggregation() == ObAggregationKindEnum.KIND_IS_AGGREGATION || assocEnd.getAggregation() == ObAggregationKindEnum.KIND_IS_COMPOSITION) {
            sourceDecoration = new PolygonDecoration();
            sourceDecoration.setTemplate(AGGREG_TIP);
            if (assocEnd.getAggregation() == ObAggregationKindEnum.KIND_IS_AGGREGATION) {
                sourceDecoration.setBackgroundColor(ColorConstants.white);
            } else {
                sourceDecoration.setBackgroundColor(ColorConstants.black);
            }
            fig.setSourceDecoration((RotatableDecoration)sourceDecoration);
        }
    }

    private void decorateNamespaceUse(PolylineConnection fig, Object model) {
        fig.setLineStyle(4);
        fig.setForegroundColor(ColorConstants.lightBlue);
        fig.setLineWidth(2);
        PolylineDecoration arrow = new PolylineDecoration();
        arrow.setTemplate(PolylineDecoration.TRIANGLE_TIP);
        arrow.setScale(7.0, 4.0);
        arrow.setLineWidth(2);
        arrow.setOpaque(false);
        fig.setTargetDecoration((RotatableDecoration)arrow);
        Label role = new Label();
        role.setText(String.valueOf(((INamespaceUse)model).getcause().size()) + " cause(s)");
        role.setFont(CoreFontRegistry.getScaledFont((Font)Display.getDefault().getSystemFont(), (float)0.9f));
        ConnectionLocator constraint = new ConnectionLocator((Connection)fig, 4);
        constraint.setGap(2);
        constraint.setRelativePosition(1);
        fig.add((IFigure)role, 0);
        fig.setConstraint((IFigure)role, (Object)constraint);
    }
}

