/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.internal.linkeditor.view.node;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.statik.INamespaceUse;
import com.modeliosoft.modelio.core.app.StandardImageService;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.modelio.internal.linkeditor.plugin.LinkEditor;
import org.modelio.internal.linkeditor.view.node.FromSideAnchor;
import org.modelio.internal.linkeditor.view.node.GraphNode;
import org.modelio.internal.linkeditor.view.node.ToSideAnchor;

public class NodeEditPart
extends AbstractGraphicalEditPart
implements org.eclipse.gef.NodeEditPart {
    public static boolean hasFocus = false;

    protected IFigure createFigure() {
        Figure rectangleFigure = new Figure();
        rectangleFigure.setOpaque(true);
        GridLayout manager = new GridLayout(1, true);
        manager.marginHeight = 2;
        manager.marginWidth = 3;
        manager.verticalSpacing = 1;
        rectangleFigure.setLayoutManager((LayoutManager)manager);
        rectangleFigure.setBorder((Border)new LineBorder(ColorConstants.lightGray, 1, 1));
        Label label = new Label();
        label.setLabelAlignment(1);
        label.setToolTip((IFigure)new Label());
        GridData data = new GridData(1, 2, true, true);
        rectangleFigure.add((IFigure)label, (Object)data);
        return rectangleFigure;
    }

    protected void createEditPolicies() {
        this.installEditPolicy((Object)"Selection Feedback", (EditPolicy)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        GraphNode model = this.getModel();
        Figure fig = (Figure)this.getFigure();
        Color swtColor = Display.getDefault().getSystemColor(model.isCentral() ? (hasFocus ? 26 : 22) : 25);
        fig.setBackgroundColor(swtColor);
        ((LineBorder)fig.getBorder()).setColor(ColorConstants.lightGray);
        Label label = (Label)fig.getChildren().get(0);
        Label tooltip = (Label)label.getToolTip();
        label.setIcon(StandardImageService.getStereotypedImage((IElement)model.getData(), null));
        if (model.getData() instanceof INamespaceUse) {
            INamespaceUse use = (INamespaceUse)model.getData();
            label.setText(LinkEditor.I18N.getMessage("Gui.Content.NameSpaceUse.label", new String[]{use.getuser().getName(), use.getused().getName()}));
            tooltip.setText(LinkEditor.I18N.getMessage("Gui.Content.NameSpaceUse.tooltip", new String[]{use.getuser().getName(), use.getused().getName()}));
        } else {
            label.setText(model.getData().getName());
            tooltip.setText(model.getData().getName());
        }
        label.setForegroundColor(Display.getDefault().getSystemColor(model.isCentral() ? (hasFocus ? 27 : 24) : 24));
    }

    public List<?> getModelSourceConnections() {
        return this.getModel().outgoing;
    }

    public List<?> getModelTargetConnections() {
        return this.getModel().incoming;
    }

    public GraphNode getModel() {
        return (GraphNode)super.getModel();
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return new ToSideAnchor(this.getFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return new FromSideAnchor(this.getFigure());
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return new ToSideAnchor(this.getFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return new FromSideAnchor(this.getFigure());
    }

    public Object getAdapter(Class adapter) {
        GraphNode model = this.getModel();
        if (adapter.isInstance(model)) {
            return model;
        }
        if (model instanceof GraphNode && adapter.isInstance(model.data)) {
            return model.data;
        }
        return super.getAdapter(adapter);
    }
}

