/*
 * Decompiled with CFR 0.152.
 */
package org.modelio.internal.linkeditor.zoom;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.ui.handlers.HandlerUtil;
import org.modelio.internal.linkeditor.view.LinkEditorView;

public class ZoomToFitHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        LinkEditorView linkEditorView = (LinkEditorView)HandlerUtil.getActivePart((ExecutionEvent)event);
        int MARGIN = 30;
        ZoomManager zoomManager = (ZoomManager)linkEditorView.getAdapter(ZoomManager.class);
        Rectangle overallRect = this.computeOverallSize(linkEditorView.getGraphicalViewer().getRootEditPart());
        Dimension viewSize = ((FigureCanvas)linkEditorView.getGraphicalViewer().getRootEditPart().getViewer().getControl()).getViewport().getSize().getCopy();
        viewSize.shrink(30, 30);
        double zoomFactor = 1.0;
        double zoomFactorX = (double)overallRect.width / (double)viewSize.width;
        double zoomFactorY = (double)overallRect.height / (double)viewSize.height;
        zoomFactor = 1.0 / Math.max(zoomFactorX, zoomFactorY);
        if (zoomManager != null) {
            zoomManager.setZoom(zoomFactor);
        }
        FigureCanvas canvas = (FigureCanvas)linkEditorView.getGraphicalViewer().getRootEditPart().getViewer().getControl();
        Rectangle scaledRect = overallRect.scale(zoomFactor);
        int xPos = scaledRect.x + scaledRect.width / 2;
        int yPos = scaledRect.y + scaledRect.height / 2;
        canvas.getViewport().setViewLocation(xPos, yPos);
        return null;
    }

    private Rectangle computeOverallSize(RootEditPart rootEditPart) {
        Rectangle nodesRect;
        Rectangle overallRect = null;
        LayerManager lm = (LayerManager)rootEditPart;
        ConnectionLayer connectionLayer = (ConnectionLayer)lm.getLayer((Object)"Connection Layer");
        Layer backgroundLayer = (Layer)((GraphicalEditPart)rootEditPart.getContents()).getFigure();
        assert (backgroundLayer != null);
        overallRect = nodesRect = this.computeMinimumBounds(backgroundLayer);
        Rectangle linksRect = this.computeMinimumBounds((Layer)connectionLayer);
        overallRect.union(linksRect);
        return overallRect;
    }

    private Rectangle computeMinimumBounds(Layer layer) {
        int xMin = Integer.MAX_VALUE;
        int xMax = Integer.MIN_VALUE;
        int yMin = Integer.MAX_VALUE;
        int yMax = Integer.MIN_VALUE;
        for (Object o : layer.getChildren()) {
            Rectangle b = ((Figure)o).getBounds();
            if (b.x < xMin) {
                xMin = b.x;
            }
            if (b.x + b.width > xMax) {
                xMax = b.x + b.width;
            }
            if (b.y < yMin) {
                yMin = b.y;
            }
            if (b.y + b.height <= yMax) continue;
            yMax = b.y + b.height;
        }
        return new Rectangle(xMin, yMin, xMax - xMin, yMax - yMin);
    }
}

