/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.app.modules.listDlg;

import com.modeliosoft.modelio.api.mdac.IMdac;
import com.modeliosoft.modelio.api.mdac.MdacException;
import com.modeliosoft.modelio.api.model.extension.IModule;
import com.modeliosoft.modelio.app.modules.listDlg.ModuleAdapter;
import com.modeliosoft.modelio.app.modules.ui.Messages;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.mdainfra.mdacs.core.IMdacManager;
import com.modeliosoft.modelio.mdainfra.mdacs.core.MdacLoader;
import com.modeliosoft.modelio.mdainfra.mdacs.core.MdacManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class MdacListDataProvider
implements IStructuredContentProvider,
ITableLabelProvider,
IColorProvider {
    private ModuleAdapter[] mdacs = null;
    private final IModelingSession modelingSession;
    private Map<String, Image> modulesImages = null;

    public MdacListDataProvider(IModelingSession modelingSession) {
        this.modelingSession = modelingSession;
        this.modulesImages = new HashMap();
    }

    public Object[] getElements(Object arg0) {
        return this.mdacs;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput != null) {
            Collection theAdapters = (Collection)newInput;
            this.mdacs = theAdapters.toArray(new ModuleAdapter[theAdapters.size()]);
        }
    }

    public Image getColumnImage(Object obj, int index) {
        ModuleAdapter adapter = (ModuleAdapter)obj;
        IModule mdacModel = adapter.getModule();
        IMdac mdac = this.modelingSession.getMdacRegistry().getLoadedMdac(mdacModel);
        if (mdac == null) {
            try {
                MdacManager mdacManager = new MdacManager(this.modelingSession);
                MdacLoader loader = new MdacLoader(this.modelingSession, (IMdacManager)mdacManager, this.modelingSession.getProjectSpacePath());
                List mdaClasspath = mdacManager.getMdacClasspath(mdacModel);
                mdac = loader.loadMdac(mdacModel, mdaClasspath);
            }
            catch (MdacException e) {
                e.printStackTrace();
            }
        }
        switch (index) {
            case 0: {
                ImageDescriptor desc;
                Image moduleImage;
                if (mdacModel.getName().equals("ModelerModule")) {
                    moduleImage = (Image)this.modulesImages.get("ModelerModule");
                    if (moduleImage == null) {
                        desc = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.modelio.app.internal", (String)"icons/modelio_16.png");
                        if (desc != null) {
                            moduleImage = desc.createImage();
                            this.modulesImages.put("ModelerModule", moduleImage);
                        } else {
                            return null;
                        }
                    }
                    return moduleImage;
                }
                moduleImage = null;
                if (mdac != null) {
                    this.modulesImages.get(mdac.getName());
                    desc = mdac.getMdacImageDescriptor();
                    if (desc != null) {
                        moduleImage = desc.createImage();
                        this.modulesImages.put(mdac.getName(), moduleImage);
                    }
                }
                if (moduleImage == null && (moduleImage = (Image)this.modulesImages.get("DefaultModuleImage")) == null) {
                    desc = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.modelio.app.modules", (String)"icons/mdacomponent_16.png");
                    if (desc != null) {
                        moduleImage = desc.createImage();
                        this.modulesImages.put("DefaultModuleImage", moduleImage);
                    } else {
                        return null;
                    }
                }
                return moduleImage;
            }
        }
        return null;
    }

    public String getColumnText(Object obj, int index) {
        ModuleAdapter adapter = (ModuleAdapter)obj;
        IModule mdacModel = adapter.getModule();
        IMdac mdac = this.modelingSession.getMdacRegistry().getLoadedMdac(mdacModel);
        if (mdac == null) {
            try {
                MdacManager mdacManager = new MdacManager(this.modelingSession);
                MdacLoader loader = new MdacLoader(this.modelingSession, (IMdacManager)mdacManager, this.modelingSession.getProjectSpacePath());
                List mdaClasspath = mdacManager.getMdacClasspath(mdacModel);
                mdac = loader.loadMdac(mdacModel, mdaClasspath);
            }
            catch (MdacException mdacException) {
                // empty catch block
            }
        }
        switch (index) {
            case 0: {
                return mdac != null ? mdac.getLabel() : mdacModel.getName();
            }
            case 1: {
                return mdacModel.getVersion().toString();
            }
            case 2: {
                return Messages.getString((String)("ListMdacsDlg.ModuleState." + adapter.getMdacState().name()));
            }
        }
        return null;
    }

    public void addListener(ILabelProviderListener arg0) {
    }

    public boolean isLabelProperty(Object arg0, String arg1) {
        return false;
    }

    public void removeListener(ILabelProviderListener arg0) {
    }

    public Color getBackground(Object element) {
        return null;
    }

    public Color getForeground(Object element) {
        if (element instanceof ModuleAdapter) {
            ModuleAdapter adapter = (ModuleAdapter)element;
            IMdac loadedMdac = this.modelingSession.getMdacRegistry().getLoadedMdac(adapter.getModule());
            if (loadedMdac != null && loadedMdac.getState() == IMdac.MdacState.Incompatible) {
                return Display.getCurrent().getSystemColor(4);
            }
            if (adapter.stateCanBeModify()) {
                return Display.getCurrent().getSystemColor(2);
            }
            return Display.getCurrent().getSystemColor(15);
        }
        return Display.getCurrent().getSystemColor(15);
    }

    protected void finalize() throws Throwable {
        for (Image image : this.modulesImages.values()) {
            image.dispose();
        }
        super.finalize();
    }
}

