/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.app.modules.listDlg;

import com.modeliosoft.modelio.api.mdac.IMdac;
import com.modeliosoft.modelio.app.modules.listDlg.ModuleAdapter;
import com.modeliosoft.modelio.app.modules.listDlg.ModulesActivationDlg;
import com.modeliosoft.modelio.core.IModelingSession;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;

class ModuleSelectionListener
implements ISelectionChangedListener {
    private ModulesActivationDlg dialog = null;
    private IModelingSession modelingSession = null;

    public ModuleSelectionListener(ModulesActivationDlg dialog, IModelingSession modelingSession) {
        this.dialog = dialog;
        this.modelingSession = modelingSession;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            if (structuredSelection.size() == 1) {
                Object obj = structuredSelection.getFirstElement();
                if (obj instanceof ModuleAdapter) {
                    ModuleAdapter adapter = (ModuleAdapter)obj;
                    this.updateDescription(adapter);
                }
            } else {
                this.dialog.setModuleDescription("");
            }
        }
        this.dialog.refresh();
    }

    public ModulesActivationDlg getDialog() {
        return this.dialog;
    }

    private void updateDescription(ModuleAdapter adapter) {
        IMdac mdac = this.modelingSession.getMdacRegistry().getLoadedMdac(adapter.getModule());
        if (mdac != null) {
            this.dialog.setModuleDescription(mdac.getDescription());
        } else {
            this.dialog.setModuleDescription("");
        }
    }
}

